/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.base.test;

import be.iminds.ilabt.jfed.fedmon.webapi.base.AbstractWebApiApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.base.AbstractWebApiConfigurationIface;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.skife.jdbi.v2.Handle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestPostgresDB {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestPostgresDB.class);
    private Handle handle;
    private Connection con;
    private String clearScript;
    private String fillScript;
    private final String migrationsFile;

    public AbstractTestPostgresDB(DropwizardAppRule<? extends AbstractWebApiConfigurationIface> RULE, String migrationsFile, String clearFile, String fillFile, Class resourceBaseClass) {
        this.migrationsFile = migrationsFile;
        assert (RULE != null);
        try {
            this.clearScript = IOUtils.resourceToString((String)clearFile, (Class)resourceBaseClass);
            this.fillScript = IOUtils.resourceToString((String)fillFile, (Class)resourceBaseClass);
            AbstractWebApiApplication app = (AbstractWebApiApplication)RULE.getApplication();
            assert (app != null);
            assert (app.getJdbi() != null);
            this.handle = app.getJdbi().open();
            assert (this.handle != null);
            this.con = this.handle.getConnection();
            assert (this.con != null);
            assert (!this.con.isClosed());
            assert (this.con.getAutoCommit());
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while setting up test DB helper", e);
        }
    }

    public void dropAllTables() throws SQLException {
        try {
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(this.con));
            Liquibase liquibase = new Liquibase(this.migrationsFile, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.dropAll();
        }
        catch (LiquibaseException e) {
            LOG.error("Liquibase failed to drop all tables", (Throwable)e);
            throw new RuntimeException("Liquibase failed to drop all tables", e);
        }
        assert (!this.con.isClosed());
        this.con.setAutoCommit(true);
    }

    public void clearAllTables() throws SQLException {
        assert (this.con != null);
        assert (!this.con.isClosed());
        assert (this.con.getAutoCommit());
        Statement stmt = this.con.createStatement();
        stmt.execute(this.clearScript);
        stmt.close();
    }

    public void createAllTables() throws SQLException {
        this.liquibaseUpdate();
    }

    public void liquibaseUpdate() throws SQLException {
        try {
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(this.con));
            Liquibase liquibase = new Liquibase(this.migrationsFile, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.update("");
        }
        catch (LiquibaseException e) {
            LOG.error("Liquibase failed to migrate all tables", (Throwable)e);
            throw new RuntimeException("Liquibase failed to migrate all tables", e);
        }
        assert (!this.con.isClosed());
        this.con.setAutoCommit(true);
    }

    public void fillAllTables() throws SQLException {
        assert (this.con != null);
        assert (!this.con.isClosed());
        assert (this.con.getAutoCommit());
        Statement stmt = this.con.createStatement();
        stmt.execute(this.fillScript);
        stmt.close();
    }

    public void executeStatement(String statementString) throws SQLException {
        assert (this.con != null);
        assert (!this.con.isClosed());
        assert (this.con.getAutoCommit());
        Statement stmt = this.con.createStatement();
        stmt.execute(statementString);
        stmt.close();
    }

    public void recreateDB() throws SQLException {
        assert (this.con != null);
        assert (!this.con.isClosed());
        this.dropAllTables();
        this.createAllTables();
        this.fillAllTables();
    }

    public void refillDB() throws SQLException {
        assert (this.con != null);
        assert (!this.con.isClosed());
        this.clearAllTables();
        this.fillAllTables();
    }

    public void close() throws SQLException {
        assert (this.handle != null);
        assert (this.con != null);
        this.handle.close();
        this.handle = null;
        this.con = null;
    }
}

