/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.base;

import be.iminds.ilabt.jfed.fedmon.webapi.base.AbstractWebApiConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.util.EmailSender;
import be.iminds.ilabt.jfed.fedmon.webapi.service.util.JFedLoggingExceptionMapper;
import io.dropwizard.Application;
import io.dropwizard.Bundle;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.jersey.errors.EarlyEofExceptionMapper;
import io.dropwizard.jersey.jackson.JsonProcessingExceptionMapper;
import io.dropwizard.jersey.setup.JerseyEnvironment;
import io.dropwizard.jetty.setup.ServletEnvironment;
import io.dropwizard.migrations.MigrationsBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.skife.jdbi.v2.DBI;

public abstract class AbstractWebApiApplication<Conf extends AbstractWebApiConfiguration>
extends Application<Conf> {
    protected final String migrationsFile;
    protected EmailSender emailSender;
    protected DBI jdbi;

    protected AbstractWebApiApplication(String migrationsFile) {
        this.migrationsFile = migrationsFile;
    }

    public void initialize(Bootstrap<Conf> bootstrap) {
        bootstrap.addBundle((Bundle)new MigrationsBundle<Conf>(){

            public DataSourceFactory getDataSourceFactory(Conf configuration) {
                return ((AbstractWebApiConfiguration)configuration).getDataSourceFactory();
            }

            public String getMigrationsFileName() {
                return AbstractWebApiApplication.this.migrationsFile;
            }
        });
    }

    public DBI getJdbi() {
        return this.jdbi;
    }

    public EmailSender getEmailSender() {
        return this.emailSender;
    }

    public void run(Conf configuration, Environment environment) {
        ((AbstractWebApiConfiguration)configuration).getJsonLdObjectsMetaData();
        this.emailSender = new EmailSender(((AbstractWebApiConfiguration)configuration).getAdminEmail());
        JerseyEnvironment jerseyEnvironment = environment.jersey();
        jerseyEnvironment.register((Object)new JFedLoggingExceptionMapper<Throwable>(this.emailSender){});
        jerseyEnvironment.register((Object)new JsonProcessingExceptionMapper());
        jerseyEnvironment.register((Object)new EarlyEofExceptionMapper());
        DBIFactory factory = new DBIFactory();
        this.jdbi = factory.build(environment, (PooledDataSourceFactory)((AbstractWebApiConfiguration)configuration).getDataSourceFactory(), "postgresql");
        this.initializeDaosAndResources(configuration, environment, this.jdbi);
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        ServletEnvironment servletEnvironment = environment.servlets();
        Class<CrossOriginFilter> crossorgFilterClass = CrossOriginFilter.class;
        FilterRegistration.Dynamic filter = servletEnvironment.addFilter("CORSFilter", crossorgFilterClass);
        filter.setInitParameter("allowedOrigins", "*");
        filter.setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin");
        filter.setInitParameter("allowedMethods", "OPTIONS,GET,HEAD");
        filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        FilterRegistration.Dynamic filter2 = servletEnvironment.addFilter("CORSFilterForWriteLocal", CrossOriginFilter.class);
        filter2.setInitParameter("allowedOrigins", "http://localhost:9001");
        filter2.setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin");
        filter2.setInitParameter("allowedMethods", "OPTIONS,GET,HEAD,PUT,POST,DELETE");
        filter2.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        FilterRegistration.Dynamic filter3 = servletEnvironment.addFilter("CORSFilterForWrite", CrossOriginFilter.class);
        filter3.setInitParameter("allowedOrigins", "https://flsmonitor.fed4fire.eu,https://fedmon.fed4fire.eu");
        filter3.setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin");
        filter3.setInitParameter("allowedMethods", "OPTIONS,GET,HEAD,PUT,POST,DELETE");
        filter3.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        if (this.emailSender.hasValidConfig() && this.emailSender.getConfig().getNotifyOnStartup().booleanValue()) {
            this.emailSender.sendToAdmin("Fedmon API: Succesfull start", "The Fedmon wep API service has started.");
        }
    }

    public abstract void initializeDaosAndResources(Conf var1, Environment var2, DBI var3);
}

