/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.base.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Location;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.skife.jdbi.v2.Query;

public class DaoCommon {
    public static String makeWherePartList(String varName, int matchValueCount) {
        Object res = "";
        boolean first = true;
        for (int i = 0; i < matchValueCount; ++i) {
            if (!first) {
                res = (String)res + ",";
            }
            res = (String)res + "#" + varName + i;
            first = false;
        }
        res = (String)res;
        return res;
    }

    public static String makeCastWherePartList(String varName, int matchValueCount, String castType) {
        Object res = "";
        boolean first = true;
        for (int i = 0; i < matchValueCount; ++i) {
            if (!first) {
                res = (String)res + ",";
            }
            res = (String)res + "CAST ( #" + varName + i + " AS " + castType + " )";
            first = false;
        }
        res = (String)res;
        return res;
    }

    public static String makeWherePart(String colName, String varName, int matchValueCount) {
        String res = colName + " IN (";
        res = res + DaoCommon.makeWherePartList(varName, matchValueCount);
        res = res + ")";
        return res;
    }

    public static String makeCastWherePart(String colName, String varName, int matchValueCount, String castType) {
        String res = colName + " IN (";
        res = res + DaoCommon.makeCastWherePartList(varName, matchValueCount, castType);
        res = res + ")";
        return res;
    }

    public static String joinWhereParts(List<String> whereParts) {
        Object res = "";
        if (!whereParts.isEmpty()) {
            res = (String)res + " WHERE ";
            boolean first = true;
            for (String wherePart : whereParts) {
                if (!first) {
                    res = (String)res + " AND ";
                }
                res = (String)res + "(" + wherePart + ")";
                first = false;
            }
            res = (String)res + " ";
        }
        return res;
    }

    public static Query<Map<String, Object>> setVars(Query<Map<String, Object>> q, String varName, List values) {
        int i = 0;
        for (Object val : values) {
            q = (Query)q.bind(varName + i++, val);
        }
        return q;
    }

    public static Location toLocation(String columnValue) {
        if (columnValue == null) {
            return null;
        }
        if (columnValue.trim().isEmpty()) {
            return null;
        }
        return Location.decodeFromString((String)columnValue);
    }

    public static String rowString(Map<String, Object> row, String key) {
        if (!row.containsKey(key)) {
            throw new RuntimeException("row does not have column \"" + key + "\". All columns: " + row.keySet());
        }
        Object res = row.get(key);
        if (res == null) {
            return null;
        }
        if (res instanceof String) {
            return (String)res;
        }
        throw new RuntimeException("row \"" + key + "\" is not a String. It is a " + res.getClass().getName());
    }

    public static List<String> rowStringArray(Map<String, Object> row, String key) {
        if (!row.containsKey(key)) {
            throw new RuntimeException("row does not have column \"" + key + "\". All columns: " + row.keySet());
        }
        Object res = row.get(key);
        if (res == null) {
            return null;
        }
        if (res instanceof String) {
            String s = (String)res;
            if (s.trim().isEmpty()) {
                return Collections.emptyList();
            }
            String[] rr = s.trim().split(",");
            if (rr.length == 1 && rr[0].trim().isEmpty()) {
                return Collections.emptyList();
            }
            return Arrays.asList(rr);
        }
        throw new RuntimeException("row \"" + key + "\" is not a String. It is a " + res.getClass().getName());
    }

    public static List<String> rowStringArray(ResultSet resultSet, String key) throws SQLException {
        String value = resultSet.getString(key);
        return DaoCommon.csvToStringArray(value);
    }

    public static List<GeniUrn> rowGeniUrnArray(Map<String, Object> row, String key) {
        if (!row.containsKey(key)) {
            throw new RuntimeException("row does not have column \"" + key + "\". All columns: " + row.keySet());
        }
        Object res = row.get(key);
        if (res == null) {
            return null;
        }
        if (res instanceof String) {
            String s = (String)res;
            if (s.trim().isEmpty()) {
                return Collections.emptyList();
            }
            String[] rr = s.trim().split(",");
            if (rr.length == 1 && rr[0].trim().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<GeniUrn> resList = new ArrayList<GeniUrn>();
            for (String r : rr) {
                try {
                    resList.add(new GeniUrn(r));
                }
                catch (GeniUrn.GeniUrnParseException e) {
                    throw new RuntimeException("row \"" + key + "\" contains String \"" + r + "\" which is not a GeniUrn.");
                }
            }
            return resList;
        }
        throw new RuntimeException("row \"" + key + "\" is not a String. It is a " + res.getClass().getName());
    }

    public static List<Integer> rowIntegerArray(Map<String, Object> row, String key) {
        if (!row.containsKey(key)) {
            throw new RuntimeException("row does not have column \"" + key + "\". All columns: " + row.keySet());
        }
        Object res = row.get(key);
        if (res == null) {
            return null;
        }
        if (res instanceof String) {
            String s = (String)res;
            if (s.trim().isEmpty()) {
                return Collections.emptyList();
            }
            String[] rr = s.trim().split(",");
            if (rr.length == 1 && rr[0].trim().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Integer> ia = new ArrayList<Integer>();
            for (String r : rr) {
                int i = Integer.parseInt(r.trim());
                ia.add(i);
            }
            return ia;
        }
        throw new RuntimeException("row \"" + key + "\" is not a String. It is a " + res.getClass().getName());
    }

    public static List<Integer> rowIntegerArray(ResultSet resultSet, String key) throws SQLException {
        String value = resultSet.getString(key);
        return DaoCommon.csvToIntegerArray(value);
    }

    @Nullable
    public static Boolean rowBoolean(@Nonnull Map<String, Object> row, @Nonnull String key) {
        if (!row.containsKey(key)) {
            throw new RuntimeException("row does not have column \"" + key + "\". All columns: " + row.keySet());
        }
        Object res = row.get(key);
        if (res == null) {
            return null;
        }
        if (res instanceof Boolean) {
            return (Boolean)res;
        }
        throw new RuntimeException("row \"" + key + "\" is not a Boolean. It is a " + res.getClass().getName());
    }

    @Nullable
    public static Boolean rowBoolean(@Nonnull ResultSet row, @Nonnull String key) throws SQLException {
        if (row.getObject(key) == null) {
            return null;
        }
        return row.getBoolean(key);
    }

    public static boolean rowBoolean(@Nonnull ResultSet row, @Nonnull String key, boolean defaultValue) throws SQLException {
        if (row.getObject(key) == null) {
            return defaultValue;
        }
        return row.getBoolean(key);
    }

    public static Integer rowInteger(Map<String, Object> row, String key) {
        if (!row.containsKey(key)) {
            throw new RuntimeException("row does not have column \"" + key + "\". All columns: " + row.keySet());
        }
        Object res = row.get(key);
        if (res == null) {
            return null;
        }
        if (res instanceof Integer) {
            return (Integer)res;
        }
        if (res instanceof Long) {
            return ((Long)res).intValue();
        }
        if (res instanceof Number) {
            return ((Number)res).intValue();
        }
        throw new RuntimeException("row \"" + key + "\" is not a Integer. It is a " + res.getClass().getName());
    }

    public static Integer rowInteger(ResultSet row, String key) throws SQLException {
        if (row.getObject(key) == null) {
            return null;
        }
        return row.getInt(key);
    }

    public static Long rowLong(ResultSet row, String key) throws SQLException {
        if (row.getObject(key) == null) {
            return null;
        }
        return row.getLong(key);
    }

    public static Service rowService(ResultSet row, String key) throws SQLException {
        if (row.getObject(key) == null) {
            return null;
        }
        int serviceId = row.getInt(key);
        return DaoCommon.idToService(serviceId);
    }

    public static List<Service> idsToService(String columnValue) {
        if (columnValue == null) {
            return null;
        }
        return DaoCommon.idToService(DaoCommon.csvToIntegerArray(columnValue));
    }

    public static List<Server> idsToServer(String columnValue) {
        if (columnValue == null) {
            return null;
        }
        return DaoCommon.idToServer(DaoCommon.csvToIntegerArray(columnValue));
    }

    public static Service singleIdToService(String columnValue) {
        if (columnValue == null) {
            return null;
        }
        Integer id = Integer.parseInt(columnValue);
        return DaoCommon.idToService(id);
    }

    public static Server singleIdToServer(String columnValue) {
        if (columnValue == null) {
            return null;
        }
        Integer id = Integer.parseInt(columnValue);
        return DaoCommon.idToServer(id);
    }

    private static List<Service> idToService(List<Integer> serviceIds) {
        if (serviceIds == null) {
            return null;
        }
        return serviceIds.stream().map(i -> DaoCommon.idToService(i)).collect(Collectors.toList());
    }

    private static List<Server> idToServer(List<Integer> serverIds) {
        if (serverIds == null) {
            return null;
        }
        return serverIds.stream().map(i -> DaoCommon.idToServer(i)).collect(Collectors.toList());
    }

    private static Service idToService(Integer serviceId) {
        if (serviceId == null) {
            return null;
        }
        return ((ServiceBuilder)new ServiceBuilder().setId((Object)serviceId)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
    }

    private static Server idToServer(Integer serviceId) {
        if (serviceId == null) {
            return null;
        }
        return ((ServerBuilder)new ServerBuilder().setId((Object)serviceId)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
    }

    public static List<Integer> csvToIntegerArray(String columnValue) {
        if (columnValue == null) {
            return null;
        }
        String s = columnValue;
        if (s.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] rr = s.trim().split(",");
        if (rr.length == 1 && rr[0].trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> ia = new ArrayList<Integer>();
        for (String r : rr) {
            int i = Integer.parseInt(r.trim());
            ia.add(i);
        }
        return ia;
    }

    public static List<String> csvToStringArray(String columnValue) {
        if (columnValue == null) {
            return null;
        }
        String s = columnValue;
        if (s.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] rr = s.trim().split(",");
        if (rr.length == 1 && rr[0].trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(rr);
    }

    public static class MapRowHandler
    implements RowHandler {
        @Nonnull
        private final Map<String, Object> row;

        public MapRowHandler(@Nonnull Map<String, Object> row) {
            this.row = row;
        }

        @Override
        @Nullable
        public String getString(@Nonnull String columnLabel) throws SQLException {
            return DaoCommon.rowString(this.row, columnLabel);
        }

        @Override
        @Nullable
        public Integer getInt(@Nonnull String columnLabel) throws SQLException {
            return DaoCommon.rowInteger(this.row, columnLabel);
        }

        @Override
        @Nullable
        public Boolean getBoolean(@Nonnull String columnLabel) throws SQLException {
            return DaoCommon.rowBoolean(this.row, columnLabel);
        }

        @Override
        @Nullable
        public List<Integer> getIntegerArray(@Nonnull String columnLabel) throws SQLException {
            return DaoCommon.rowIntegerArray(this.row, columnLabel);
        }

        @Override
        @Nullable
        public List<String> getStringArray(@Nonnull String columnLabel) throws SQLException {
            return DaoCommon.rowStringArray(this.row, columnLabel);
        }

        @Override
        @Nullable
        public Server getServer(@Nonnull String columnLabel) throws SQLException {
            Integer serverId = this.getInt(columnLabel);
            if (serverId == null) {
                return null;
            }
            return ((ServerBuilder)new ServerBuilder().setId((Object)serverId)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
        }
    }

    public static class ResultSetRowHandler
    implements RowHandler {
        @Nonnull
        private final ResultSet resultSet;

        public ResultSetRowHandler(@Nonnull ResultSet resultSet) {
            this.resultSet = resultSet;
        }

        @Override
        @Nullable
        public String getString(@Nonnull String columnLabel) throws SQLException {
            return this.resultSet.getString(columnLabel);
        }

        @Override
        @Nullable
        public Integer getInt(@Nonnull String columnLabel) throws SQLException {
            if (this.resultSet.getObject(columnLabel) == null) {
                return null;
            }
            return this.resultSet.getInt(columnLabel);
        }

        @Override
        @Nullable
        public Boolean getBoolean(@Nonnull String columnLabel) throws SQLException {
            if (this.resultSet.getObject(columnLabel) == null) {
                return null;
            }
            return this.resultSet.getBoolean(columnLabel);
        }

        @Override
        @Nullable
        public List<Integer> getIntegerArray(@Nonnull String columnLabel) throws SQLException {
            return DaoCommon.rowIntegerArray(this.resultSet, columnLabel);
        }

        @Override
        @Nullable
        public List<String> getStringArray(@Nonnull String columnLabel) throws SQLException {
            return DaoCommon.rowStringArray(this.resultSet, columnLabel);
        }

        @Override
        @Nullable
        public Server getServer(@Nonnull String columnLabel) throws SQLException {
            Integer serverId = this.getInt(columnLabel);
            if (serverId == null) {
                return null;
            }
            return ((ServerBuilder)new ServerBuilder().setId((Object)serverId)).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
        }
    }

    public static interface RowHandler {
        @Nullable
        public String getString(@Nonnull String var1) throws SQLException;

        @Nullable
        public Integer getInt(@Nonnull String var1) throws SQLException;

        @Nullable
        public Boolean getBoolean(@Nonnull String var1) throws SQLException;

        @Nullable
        public List<Integer> getIntegerArray(@Nonnull String var1) throws SQLException;

        @Nullable
        public List<String> getStringArray(@Nonnull String var1) throws SQLException;

        @Nullable
        public Server getServer(@Nonnull String var1) throws SQLException;
    }
}

