/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestbedDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.LinkedTestbedDataTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.OrganisationTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServerTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServiceTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllTestbedDataDaoTest {
    private static final Logger LOG = LoggerFactory.getLogger(AllTestbedDataDaoTest.class);
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static TestbedDao testbedDao;
    private static Lock lock;
    private LinkedTestbedDataTestCollection linkedTestbedDataTestCollection;
    private TestbedTestCollection testbedTestCollection;
    private OrganisationTestCollection organisationTestCollection;
    private ServerTestCollection serverTestCollection;
    private ServiceTestCollection serviceTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        testbedDao = (TestbedDao)jdbi.onDemand(TestbedDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)testbedDao);
        jdbi = null;
        testbedDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.linkedTestbedDataTestCollection = new LinkedTestbedDataTestCollection(true, 0, "http://localhost:9000");
        this.testbedTestCollection = new TestbedTestCollection();
        this.organisationTestCollection = new OrganisationTestCollection();
        this.serverTestCollection = new ServerTestCollection();
        this.serviceTestCollection = new ServiceTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testFindAll() throws Exception {
        List res = testbedDao.query(null, null, null, null, null, null, true);
        System.out.println("testFindAll res:");
        for (TestbedBuilder testbed : res) {
            Testbed testbedForString = TestbedBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN, (Testbed)testbed.create());
            ObjectMapper mapper = new ObjectMapper();
            try {
                System.out.println("  " + mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)testbedForString));
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting Testbed " + (String)testbed.getId() + " to JSON", (Throwable)e);
            }
        }
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)this.linkedTestbedDataTestCollection.getAllTestbedsSize()));
        for (TestbedBuilder resTestbedBuilder : res) {
            Testbed resTestbed = resTestbedBuilder == null ? null : resTestbedBuilder.create();
            MatcherAssert.assertThat((Object)resTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)((String)resTestbed.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Testbed origTestbed = this.linkedTestbedDataTestCollection.getTestbedById((String)resTestbed.getId());
            MatcherAssert.assertThat((Object)origTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.testbedTestCollection.assertSameButIgnoreUri(resTestbed, origTestbed);
            if (origTestbed.getOrganisation() != null) {
                this.organisationTestCollection.assertSame((JsonLdObjectWithId)resTestbed.getOrganisation(), (JsonLdObjectWithId)origTestbed.getOrganisation(), CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
            } else {
                MatcherAssert.assertThat((Object)resTestbed.getOrganisation(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            }
            if (origTestbed.getServers() != null) {
                MatcherAssert.assertThat((Object)resTestbed.getServers(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                for (int i = 0; i < origTestbed.getServers().size(); ++i) {
                    Server origServer = (Server)origTestbed.getServers().get(i);
                    Server resServer = (Server)resTestbed.getServers().get(i);
                    assert (origServer != null);
                    MatcherAssert.assertThat((Object)resServer, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                    try {
                        this.serverTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resServer, (JsonLdObjectWithId)origServer);
                    }
                    catch (AssertionError e) {
                        System.err.flush();
                        System.out.println("\n\nCompared servers differ!\nExpected:\n" + origServer);
                        System.out.println("\n\nActual:\n" + resServer + "\n\n");
                        System.out.flush();
                        System.err.flush();
                        throw e;
                    }
                    if (origServer.getServices() != null) {
                        MatcherAssert.assertThat((Object)resServer.getServices(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                        for (int j = 0; j < origServer.getServices().size(); ++j) {
                            Service origService = (Service)origServer.getServices().get(j);
                            Service resService = (Service)resServer.getServices().get(j);
                            assert (origService != null);
                            MatcherAssert.assertThat((Object)resService, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                            this.serviceTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resService, (JsonLdObjectWithId)origService);
                        }
                        continue;
                    }
                    MatcherAssert.assertThat((Object)resServer.getServices(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                }
                continue;
            }
            MatcherAssert.assertThat((Object)resTestbed.getServers(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    static {
        lock = new ReentrantLock();
    }
}

