/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.FederationDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FederationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FederationTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class FederationDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static FederationDao federationDao;
    private static Lock lock;
    private FederationTestCollection federationTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        federationDao = (FederationDao)jdbi.onDemand(FederationDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)federationDao);
        jdbi = null;
        federationDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.federationTestCollection = new FederationTestCollection(true);
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testFindById0() throws Exception {
        Federation expectedFederation = (Federation)this.federationTestCollection.getByIndex(0);
        Federation actualFederation = federationDao.findById((String)expectedFederation.getId()).create();
        this.federationTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualFederation, (JsonLdObjectWithId)expectedFederation);
    }

    @Test
    public void testFindById1() throws Exception {
        Federation expectedFederation = (Federation)this.federationTestCollection.getByIndex(1);
        Federation actualFederation = federationDao.findById((String)expectedFederation.getId()).create();
        this.federationTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualFederation, (JsonLdObjectWithId)expectedFederation);
    }

    @Test
    public void testFindById2() throws Exception {
        Federation expectedFederation = (Federation)this.federationTestCollection.getByIndex(2);
        Federation actualFederation = federationDao.findById((String)expectedFederation.getId()).create();
        this.federationTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualFederation, (JsonLdObjectWithId)expectedFederation);
    }

    @Test
    public void testFindAll() throws Exception {
        List res = federationDao.findAll();
        System.out.println("testFindAll res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)this.federationTestCollection.getSize()));
        for (FederationBuilder resFederation : res) {
            MatcherAssert.assertThat((Object)resFederation, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Federation origFederation = (Federation)this.federationTestCollection.getById((String)resFederation.getId());
            MatcherAssert.assertThat((Object)origFederation, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.federationTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resFederation.create(), (JsonLdObjectWithId)origFederation);
        }
    }

    @Test
    public void testInsert() {
        String newId = "ins";
        Federation newFederation = null;
        try {
            newFederation = ((FederationBuilder)new FederationBuilder().setId((Object)newId)).setLongName("insertTest").setDescription("insert descr").setNotes("notes for the inserted").setUrlsFromStrings(Arrays.asList("http://example.com/insert", "https://www.example.com/insertalso")).setFederatedWith("fed2").setTestbeds(Collections.emptyList()).create();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("should not happen", e);
        }
        String newIdRes = federationDao.insert(newFederation);
        MatcherAssert.assertThat((Object)newIdRes, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)newIdRes, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)newId)));
        Federation expectedFederation = new FederationBuilder(newFederation).create();
        Federation actualNewFederation = federationDao.findById(newId).create();
        System.out.println("Lookup inserted federation (" + newId + ") result: " + actualNewFederation);
        MatcherAssert.assertThat((Object)actualNewFederation, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)actualNewFederation.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)newId)));
        this.federationTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)expectedFederation, (JsonLdObjectWithId)actualNewFederation);
    }

    @Test
    public void testUpdate() {
        Federation origFederation = (Federation)this.federationTestCollection.getByIndex(1);
        Federation updatedFederation = null;
        try {
            updatedFederation = new FederationBuilder(origFederation).setLongName("updateTest").setDescription("update descr").setNotes("notes for the updated").setUrlsFromStrings(Arrays.asList("http://example.com/update", "https://www.example.com/updatealso")).setFederatedWith("fed1").create();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("should not happen", e);
        }
        federationDao.update(updatedFederation);
        Federation actualUpdatedFederation = federationDao.findById((String)origFederation.getId()).create();
        System.out.println("Lookup updated federation (" + (String)origFederation.getId() + ") result: " + actualUpdatedFederation);
        MatcherAssert.assertThat((Object)actualUpdatedFederation, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)actualUpdatedFederation.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((String)origFederation.getId()))));
        this.federationTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)updatedFederation, (JsonLdObjectWithId)actualUpdatedFederation);
    }

    static {
        lock = new ReentrantLock();
    }
}

