/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.FrequencyDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FrequencyTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class FrequencyDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static FrequencyDao frequencyDao;
    private static Lock lock;
    private FrequencyTestCollection frequencyTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        frequencyDao = (FrequencyDao)jdbi.onDemand(FrequencyDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)frequencyDao);
        jdbi = null;
        frequencyDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.frequencyTestCollection = new FrequencyTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testFindById1() throws Exception {
        Frequency expectedFrequency = (Frequency)this.frequencyTestCollection.getByIndex(0);
        Frequency actualFrequency = frequencyDao.findById((Integer)expectedFrequency.getId());
        this.frequencyTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualFrequency, (JsonLdObjectWithId)expectedFrequency);
    }

    @Test
    public void testFindById2() throws Exception {
        Frequency expectedFrequency = (Frequency)this.frequencyTestCollection.getByIndex(1);
        Frequency actualFrequency = frequencyDao.findById((Integer)expectedFrequency.getId());
        this.frequencyTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualFrequency, (JsonLdObjectWithId)expectedFrequency);
    }

    @Test
    public void testFindById3() throws Exception {
        Frequency expectedFrequency = (Frequency)this.frequencyTestCollection.getByIndex(2);
        Frequency actualFrequency = frequencyDao.findById((Integer)expectedFrequency.getId());
        this.frequencyTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualFrequency, (JsonLdObjectWithId)expectedFrequency);
    }

    @Test
    public void testFindAll() throws Exception {
        List res = frequencyDao.findAll();
        System.out.println("testFindAll res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)this.frequencyTestCollection.getSize()));
        for (Frequency resFrequency : res) {
            MatcherAssert.assertThat((Object)resFrequency, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Frequency origFrequency = (Frequency)this.frequencyTestCollection.getById((Integer)resFrequency.getId());
            MatcherAssert.assertThat((Object)origFrequency, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.frequencyTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resFrequency, (JsonLdObjectWithId)origFrequency);
        }
    }

    static {
        lock = new ReentrantLock();
    }
}

