/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.GraphDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Graph;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GraphBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.GraphTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestClock;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class GraphDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static GraphDao graphDao;
    private static Lock lock;
    private GraphTestCollection graphTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        graphDao = new GraphDao(jdbi);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        graphDao.close();
        jdbi = null;
        graphDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.graphTestCollection = new GraphTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testGetById0() throws Exception {
        Graph expectedGraph = (Graph)this.graphTestCollection.getByIndex(0);
        Graph actualGraph = graphDao.getById((String)expectedGraph.getId());
        this.graphTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualGraph, (JsonLdObjectWithId)expectedGraph);
    }

    @Test
    public void testGetById1() throws Exception {
        Graph expectedGraph = (Graph)this.graphTestCollection.getByIndex(1);
        Graph actualGraph = graphDao.getById((String)expectedGraph.getId());
        this.graphTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualGraph, (JsonLdObjectWithId)expectedGraph);
    }

    @Test
    public void testGetByTestInstanceId1() throws Exception {
        Graph expectedGraph = (Graph)this.graphTestCollection.getByIndex(0);
        assert (expectedGraph.getTestInstanceId() != null);
        List actualGraphs = graphDao.getByTestInstanceId(expectedGraph.getTestInstanceId());
        MatcherAssert.assertThat((Object)actualGraphs, (Matcher)Matchers.hasSize((int)1));
        this.graphTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)((Graph)actualGraphs.get(0)), (JsonLdObjectWithId)expectedGraph);
    }

    @Test
    public void testGetByTestInstanceIdNone() throws Exception {
        List actualGraphs = graphDao.getByTestInstanceId(Integer.valueOf(11));
        MatcherAssert.assertThat((Object)actualGraphs, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testGetByTestInstanceId2() throws Exception {
        Graph expectedGraph1 = (Graph)this.graphTestCollection.getByIndex(0);
        assert (expectedGraph1.getTestInstanceId() != null);
        GraphBuilder expectedGraph2Builder = this.graphTestCollection.getGraphToInsert();
        expectedGraph2Builder.setTestInstanceId(expectedGraph1.getTestInstanceId());
        expectedGraph2Builder.setId(expectedGraph1.getTestInstanceId() + "-" + expectedGraph2Builder.getGraphDefinitionId() + "-" + expectedGraph2Builder.getSubType() + "-" + expectedGraph2Builder.getPeriodString());
        Graph expectedGraph2 = expectedGraph2Builder.create();
        graphDao.upsertFields(expectedGraph2);
        List actualGraphs = graphDao.getByTestInstanceId(expectedGraph1.getTestInstanceId());
        MatcherAssert.assertThat((Object)actualGraphs, (Matcher)Matchers.hasSize((int)2));
        boolean sawOne = false;
        boolean sawTwo = false;
        for (Graph actualGraph : actualGraphs) {
            if (((String)actualGraph.getId()).equals(expectedGraph1.getId())) {
                this.graphTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualGraph, (JsonLdObjectWithId)expectedGraph1);
                sawOne = true;
            }
            if (!((String)actualGraph.getId()).equals(expectedGraph2.getId())) continue;
            this.graphTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualGraph, (JsonLdObjectWithId)expectedGraph2);
            sawTwo = true;
        }
        MatcherAssert.assertThat((Object)sawOne, (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)sawTwo, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGetImageDataById0() throws Exception {
        Graph expectedGraph = (Graph)this.graphTestCollection.getByIndex(0);
        byte[] actualImageData = graphDao.getImageDataById((String)expectedGraph.getId());
        byte[] expectedImageData = this.graphTestCollection.getImageDataByIndex(0);
        MatcherAssert.assertThat((Object)actualImageData, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedImageData)));
    }

    @Test
    public void testGetImageDataById1() throws Exception {
        Graph expectedGraph = (Graph)this.graphTestCollection.getByIndex(1);
        byte[] actualImageData = graphDao.getImageDataById((String)expectedGraph.getId());
        byte[] expectedImageData = this.graphTestCollection.getImageDataByIndex(1);
        assert (expectedImageData == null);
        expectedImageData = new byte[]{};
        MatcherAssert.assertThat((Object)actualImageData, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedImageData)));
        MatcherAssert.assertThat((Object)actualImageData, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGetImageDataByIdX() throws Exception {
        byte[] actualImageData = graphDao.getImageDataById("nonexisting");
        MatcherAssert.assertThat((Object)actualImageData, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testUpdateImageDataById0a() throws Exception {
        Graph expectedGraph = (Graph)this.graphTestCollection.getByIndex(0);
        graphDao.updateImageData((String)expectedGraph.getId(), null);
        byte[] actualImageData = graphDao.getImageDataById((String)expectedGraph.getId());
        MatcherAssert.assertThat((Object)actualImageData, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualImageData, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)new byte[0])));
    }

    @Test
    public void testUpdateImageDataById0b() throws Exception {
        Graph expectedGraph = (Graph)this.graphTestCollection.getByIndex(0);
        byte[] expectedImageData = new byte[]{7, 8, 9, 10, 11};
        ByteArrayInputStream is = new ByteArrayInputStream(expectedImageData);
        graphDao.updateImageData((String)expectedGraph.getId(), (InputStream)is);
        byte[] actualImageData = graphDao.getImageDataById((String)expectedGraph.getId());
        MatcherAssert.assertThat((Object)actualImageData, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedImageData)));
    }

    @Test
    public void testUpdateImageDataById1a() throws Exception {
        Graph expectedGraph = (Graph)this.graphTestCollection.getByIndex(1);
        graphDao.updateImageData((String)expectedGraph.getId(), null);
        byte[] actualImageData = graphDao.getImageDataById((String)expectedGraph.getId());
        MatcherAssert.assertThat((Object)actualImageData, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualImageData, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)new byte[0])));
    }

    @Test
    public void testUpdateImageDataById1b() throws Exception {
        Graph expectedGraph = (Graph)this.graphTestCollection.getByIndex(1);
        byte[] expectedImageData = new byte[]{4, 5, 6, 7};
        ByteArrayInputStream is = new ByteArrayInputStream(expectedImageData);
        graphDao.updateImageData((String)expectedGraph.getId(), (InputStream)is);
        byte[] actualImageData = graphDao.getImageDataById((String)expectedGraph.getId());
        MatcherAssert.assertThat((Object)actualImageData, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedImageData)));
    }

    @Test
    public void testUpsertInsert() throws Exception {
        Graph newGraph = this.graphTestCollection.getGraphToInsert().create();
        int rowsChanged = graphDao.upsertFields(newGraph);
        MatcherAssert.assertThat((Object)rowsChanged, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        Graph expectedGraph = newGraph;
        Graph actualGraph = graphDao.getById((String)newGraph.getId());
        this.graphTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualGraph, (JsonLdObjectWithId)expectedGraph);
    }

    @Test
    public void testUpsertUpdateFields() throws Exception {
        Graph origGraph = (Graph)this.graphTestCollection.getByIndex(0);
        GraphBuilder updatedGraphBuilder = new GraphBuilder(origGraph);
        updatedGraphBuilder.setGraphDefinitionId("testU");
        updatedGraphBuilder.setSubType("tU");
        updatedGraphBuilder.setPeriodString("2day");
        updatedGraphBuilder.setPeriodInSeconds(Long.valueOf(172800L));
        updatedGraphBuilder.setDescription("Test 2 Day Graph");
        updatedGraphBuilder.setTestInstanceId(Integer.valueOf(11));
        updatedGraphBuilder.setTestDefinitionId("anyGetVersion");
        updatedGraphBuilder.setGraphStartTime(TestClock.get().getOffsetMinutes(103680L));
        updatedGraphBuilder.setGraphEndTime(TestClock.get().getOffsetMinutes(106560L));
        updatedGraphBuilder.setExpire(TestClock.get().getOffsetMinutes(106570L));
        Graph updatedGraph = updatedGraphBuilder.create();
        MatcherAssert.assertThat((Object)((String)updatedGraph.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((String)origGraph.getId()))));
        int rowsChanged = graphDao.upsertFields(updatedGraph);
        MatcherAssert.assertThat((Object)rowsChanged, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        Graph expectedGraph = updatedGraph;
        Graph actualGraph = graphDao.getById((String)origGraph.getId());
        this.graphTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualGraph, (JsonLdObjectWithId)expectedGraph);
    }

    static {
        lock = new ReentrantLock();
    }
}

