/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.GuiConfigSetDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GuiConfigSet;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.GuiConfigSetTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class GuiConfigSetDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static GuiConfigSetDao guiConfigSetDao;
    private static Lock lock;
    private GuiConfigSetTestCollection guiConfigSetTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        guiConfigSetDao = (GuiConfigSetDao)jdbi.onDemand(GuiConfigSetDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)guiConfigSetDao);
        jdbi = null;
        guiConfigSetDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.guiConfigSetTestCollection = new GuiConfigSetTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testFindById1() throws Exception {
        GuiConfigSet expectedGuiConfigSet = (GuiConfigSet)this.guiConfigSetTestCollection.getByIndex(0);
        GuiConfigSet actualGuiConfigSet = guiConfigSetDao.findById((String)expectedGuiConfigSet.getId());
        this.guiConfigSetTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualGuiConfigSet, (JsonLdObjectWithId)expectedGuiConfigSet);
    }

    @Test
    public void testFindById2() throws Exception {
        GuiConfigSet expectedGuiConfigSet = (GuiConfigSet)this.guiConfigSetTestCollection.getByIndex(1);
        GuiConfigSet actualGuiConfigSet = guiConfigSetDao.findById((String)expectedGuiConfigSet.getId());
        this.guiConfigSetTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualGuiConfigSet, (JsonLdObjectWithId)expectedGuiConfigSet);
    }

    @Test
    public void testFindAll() throws Exception {
        List res = guiConfigSetDao.findAll();
        System.out.println("testFindAll res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)this.guiConfigSetTestCollection.getSize()));
        for (GuiConfigSet resGuiConfigSet : res) {
            MatcherAssert.assertThat((Object)resGuiConfigSet, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            GuiConfigSet origGuiConfigSet = (GuiConfigSet)this.guiConfigSetTestCollection.getById((String)resGuiConfigSet.getId());
            MatcherAssert.assertThat((Object)origGuiConfigSet, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.guiConfigSetTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resGuiConfigSet, (JsonLdObjectWithId)origGuiConfigSet);
        }
    }

    static {
        lock = new ReentrantLock();
    }
}

