/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.LogDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LogBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.LogTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestClock;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.jersey.internal.util.Base64;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class LogDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static LogDao logDao;
    private static Lock lock;
    private LogTestCollection logTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        logDao = new LogDao(jdbi);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        logDao.close();
        jdbi = null;
        logDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.logTestCollection = new LogTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testGetById1() throws Exception {
        Log expectedLog = (Log)this.logTestCollection.getByIndex(0);
        Log actualLog = logDao.getById((Long)expectedLog.getId());
        this.logTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualLog, (JsonLdObjectWithId)expectedLog);
    }

    @Test
    public void testGetById2() throws Exception {
        Log expectedLog = (Log)this.logTestCollection.getByIndex(1);
        Log actualLog = logDao.getById((Long)expectedLog.getId());
        this.logTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualLog, (JsonLdObjectWithId)expectedLog);
    }

    @Test
    public void testInsert() throws Exception {
        LogBuilder newLog = new LogBuilder().setStartTime(TestClock.get().getOffsetMinutes(44L)).setComplete(Boolean.valueOf(false)).setName("testadd.html").setLive(Boolean.valueOf(false)).setResult(null).setTask(null).setMediaType(Log.LogMediaType.HTML).setStopTime(null);
        Long newLogId = logDao.insert(newLog.create());
        MatcherAssert.assertThat((Object)newLogId, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)200L)));
        Log expectedLog = ((LogBuilder)new LogBuilder(newLog.create()).setId((Object)newLogId)).setSize(Long.valueOf(0L)).create();
        Log actualLog = logDao.getById((Long)expectedLog.getId());
        this.logTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualLog, (JsonLdObjectWithId)expectedLog);
    }

    @Test
    public void testUpdateFields1a() throws Exception {
        Log origLog = (Log)this.logTestCollection.getByIndex(0);
        testPostgresDB.executeStatement("UPDATE log SET complete=false WHERE id=0");
        logDao.updateFields((Long)origLog.getId(), TestClock.get().getOffsetMinutes(33L), true, Long.valueOf(2L), Long.valueOf(2L));
        Log expectedLog = new LogBuilder(origLog).setStopTime(TestClock.get().getOffsetMinutes(33L)).setComplete(Boolean.valueOf(true)).setResultId(Long.valueOf(2L)).setTaskId(Long.valueOf(2L)).create();
        Log actualLog = logDao.getById((Long)expectedLog.getId());
        this.logTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualLog, (JsonLdObjectWithId)expectedLog);
    }

    @Test
    public void testUpdateFields1b() throws Exception {
        Log origLog = (Log)this.logTestCollection.getByIndex(0);
        Log expectedLog = new LogBuilder(origLog).setComplete(Boolean.valueOf(true)).setResultId(Long.valueOf(2L)).setTaskId(Long.valueOf(2L)).setStopTime(TestClock.get().getOffsetMinutes(33L)).create();
        logDao.updateFields((Long)origLog.getId(), TestClock.get().getOffsetMinutes(33L), true, Long.valueOf(2L), Long.valueOf(2L));
        Log actualLog = logDao.getById((Long)origLog.getId());
        this.logTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualLog, (JsonLdObjectWithId)expectedLog);
    }

    @Test
    public void testUpdateFields2() throws Exception {
        Log origLog = (Log)this.logTestCollection.getByIndex(1);
        logDao.updateFields((Long)origLog.getId(), TestClock.get().getOffsetMinutes(44L), true, Long.valueOf(2L), Long.valueOf(3L));
        Log expectedLog = new LogBuilder(origLog).setStopTime(TestClock.get().getOffsetMinutes(44L)).setComplete(Boolean.valueOf(true)).setResultId(Long.valueOf(2L)).setTaskId(Long.valueOf(3L)).create();
        Log actualLog = logDao.getById((Long)expectedLog.getId());
        this.logTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualLog, (JsonLdObjectWithId)expectedLog);
    }

    @Test
    public void testGetContent1() throws Exception {
        Log log = (Log)this.logTestCollection.getByIndex(0);
        String expectedLogContent = this.logTestCollection.getContent0();
        LogDao.ContentAndType contentAndType = logDao.getContentById((Long)log.getId());
        MatcherAssert.assertThat((Object)contentAndType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)contentAndType.getMediaType(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)contentAndType.getMediaType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)log.getMediaType())));
        byte[] actualLogContentBytes = contentAndType.getContent();
        MatcherAssert.assertThat((Object)actualLogContentBytes, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        String actualLogContent = new String(actualLogContentBytes, Charset.forName("UTF-8"));
        MatcherAssert.assertThat((Object)actualLogContent, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedLogContent)));
    }

    @Test
    public void testGetContent2() throws Exception {
        Log log = (Log)this.logTestCollection.getByIndex(1);
        LogDao.ContentAndType contentAndType = logDao.getContentById((Long)log.getId());
        MatcherAssert.assertThat((Object)contentAndType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)contentAndType.getMediaType(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)contentAndType.getMediaType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)log.getMediaType())));
        byte[] actualLogContentBytes = contentAndType.getContent();
        MatcherAssert.assertThat((Object)actualLogContentBytes, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualLogContentBytes.length, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void testAppendContent1a() throws Exception {
        testPostgresDB.executeStatement("UPDATE log SET complete=false WHERE id=0");
        Log log = (Log)this.logTestCollection.getByIndex(0);
        String appendedString = "Another line added for test1";
        String appendedContentBase64 = Base64.encodeAsString((String)appendedString);
        ByteArrayInputStream appendedIS = new ByteArrayInputStream(appendedString.getBytes(Charset.forName("UTF-8")));
        logDao.appendContent((Long)log.getId(), (InputStream)appendedIS, log.getMediaType().name());
        String expectedLogContent = this.logTestCollection.getContent0() + appendedString;
        LogDao.ContentAndType contentAndType = logDao.getContentById((Long)log.getId());
        MatcherAssert.assertThat((Object)contentAndType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)contentAndType.getMediaType(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)contentAndType.getMediaType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)log.getMediaType())));
        byte[] actualLogContentBytes = contentAndType.getContent();
        MatcherAssert.assertThat((Object)actualLogContentBytes, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        String actualLogContent = new String(actualLogContentBytes, Charset.forName("UTF-8"));
        MatcherAssert.assertThat((Object)actualLogContent, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedLogContent)));
    }

    @Test
    public void testAppendContent1b() throws Exception {
        Log log = (Log)this.logTestCollection.getByIndex(0);
        String appendedString = "Another line added for test1";
        String appendedContentBase64 = Base64.encodeAsString((String)appendedString);
        ByteArrayInputStream appendedIS = new ByteArrayInputStream(appendedString.getBytes(Charset.forName("UTF-8")));
        logDao.appendContent((Long)log.getId(), (InputStream)appendedIS, log.getMediaType().name());
        LogDao.ContentAndType contentAndType = logDao.getContentById((Long)log.getId());
        MatcherAssert.assertThat((Object)contentAndType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)contentAndType.getMediaType(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)contentAndType.getMediaType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)log.getMediaType())));
        byte[] actualLogContentBytes = contentAndType.getContent();
        MatcherAssert.assertThat((Object)actualLogContentBytes, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        String actualLogContent = new String(actualLogContentBytes, Charset.forName("UTF-8"));
        String expectedLogContent = this.logTestCollection.getContent0();
        MatcherAssert.assertThat((Object)actualLogContent, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedLogContent)));
    }

    @Test
    public void testAppendContent2() throws Exception {
        Log log = (Log)this.logTestCollection.getByIndex(1);
        System.out.println("testAppendContent2() works on log with ID=" + log.getId() + " and mediaType=" + log.getMediaType().name());
        String appendedString = "Another line added for test2\nyes, test2\n";
        String appendedContentBase64 = Base64.encodeAsString((String)appendedString);
        ByteArrayInputStream appendedIS = new ByteArrayInputStream(appendedString.getBytes(Charset.forName("UTF-8")));
        int rowsUpdated = logDao.appendContent((Long)log.getId(), (InputStream)appendedIS, log.getMediaType().name());
        MatcherAssert.assertThat((Object)rowsUpdated, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        String expectedLogContent = appendedString;
        LogDao.ContentAndType contentAndType = logDao.getContentById((Long)log.getId());
        MatcherAssert.assertThat((Object)contentAndType, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)contentAndType.getMediaType(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)contentAndType.getMediaType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)log.getMediaType())));
        byte[] actualLogContentBytes = contentAndType.getContent();
        MatcherAssert.assertThat((Object)actualLogContentBytes, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        String actualLogContent = new String(actualLogContentBytes, Charset.forName("UTF-8"));
        MatcherAssert.assertThat((Object)actualLogContent, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedLogContent)));
    }

    static {
        lock = new ReentrantLock();
    }
}

