/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.OrganisationDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Location;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.OrganisationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.OrganisationTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class OrganisationDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static OrganisationDao organisationDao;
    private static Lock lock;
    private OrganisationTestCollection organisationTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        organisationDao = (OrganisationDao)jdbi.onDemand(OrganisationDao.class);
        assert (organisationDao != null);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        assert (organisationDao != null);
        jdbi.close((Object)organisationDao);
        jdbi = null;
        organisationDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.organisationTestCollection = new OrganisationTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testFindByName1() throws Exception {
        Organisation expectedOrganisation = (Organisation)this.organisationTestCollection.getByIndex(0);
        Organisation actualOrganisation = organisationDao.findById((String)expectedOrganisation.getId());
        System.out.println("testFindByName1 res = " + actualOrganisation);
        MatcherAssert.assertThat((Object)actualOrganisation, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.organisationTestCollection.assertSame((JsonLdObjectWithId)actualOrganisation, (JsonLdObjectWithId)expectedOrganisation, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test
    public void testFindByName2() throws Exception {
        Organisation expectedOrganisation = (Organisation)this.organisationTestCollection.getByIndex(1);
        Organisation actualOrganisation = organisationDao.findById((String)expectedOrganisation.getId());
        System.out.println("testFindByName2 res = " + actualOrganisation);
        MatcherAssert.assertThat((Object)actualOrganisation, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.organisationTestCollection.assertSame((JsonLdObjectWithId)actualOrganisation, (JsonLdObjectWithId)expectedOrganisation, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test
    public void testFindAll() throws Exception {
        List res = organisationDao.findAll();
        System.out.println("testFindAll res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)this.organisationTestCollection.getSize()));
        for (Organisation resOrganisation : res) {
            MatcherAssert.assertThat((Object)resOrganisation, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Organisation origOrganisation = (Organisation)this.organisationTestCollection.getById((String)resOrganisation.getId());
            MatcherAssert.assertThat((Object)origOrganisation, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.organisationTestCollection.assertSame((JsonLdObjectWithId)resOrganisation, (JsonLdObjectWithId)origOrganisation, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
        }
    }

    @Test
    public void testUpdate() throws Exception {
        OrganisationBuilder organisationBuilder = ((OrganisationBuilder)new OrganisationBuilder().setId((Object)"iminds")).setName("imec").setSiteUrl("http://ilabt.imec.be").setLogoUrl("http://www.imec.be/logo.png").setLocation(new Location("EU", Double.valueOf(3.733333), Double.valueOf(51.05), "Ghent University - imec, Gaston Crommenlaan 8 (Bus 201), B-9050 Gent, Belgium")).setTechnicalContactEmails(Arrays.asList("one2@example.com", "two2@example.com"));
        organisationBuilder.setTestbeds(null);
        Organisation updatedOrganisation = organisationBuilder.create();
        organisationDao.update(updatedOrganisation);
        organisationBuilder.setTestbeds(((Organisation)this.organisationTestCollection.getById("iminds")).getTestbeds());
        Organisation expectedOrganisation = organisationBuilder.create();
        Organisation lookupRes = organisationDao.findById((String)updatedOrganisation.getId());
        this.organisationTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)lookupRes, (JsonLdObjectWithId)expectedOrganisation);
    }

    @Test
    public void testInsert() throws Exception {
        Organisation newOrganisation = ((OrganisationBuilder)new OrganisationBuilder().setId((Object)"new-test")).setName("New Test Org").setLocation(new Location("BE", Double.valueOf(0.2), Double.valueOf(0.1), "Belgium")).setLogoUrl("logoUrl").setSiteUrl("siteUrl").create();
        String newId = (String)newOrganisation.getId();
        organisationDao.insert(newOrganisation);
        MatcherAssert.assertThat((Object)newId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        OrganisationBuilder expectedNewOrganisationBuilder = new OrganisationBuilder(newOrganisation);
        expectedNewOrganisationBuilder.setId((Object)newId);
        ((FedmonWebApiServiceConfiguration)RULE.getConfiguration()).getJsonLdObjectsMetaData().makeUriTool("http://localhost:9000").setBuilderUri((PrimaryIdObjectBuilder)expectedNewOrganisationBuilder, true);
        expectedNewOrganisationBuilder.setTestbeds(Collections.emptyList());
        Organisation expectedNewOrganisation = expectedNewOrganisationBuilder.create();
        assert (expectedNewOrganisation.getTestbeds() != null);
        assert (expectedNewOrganisation.getTestbeds().isEmpty());
        Organisation actualNewOrganisation = organisationDao.findById(newId);
        System.out.println("Lookup inserted organisation (" + newId + ") result: " + actualNewOrganisation);
        MatcherAssert.assertThat((Object)actualNewOrganisation, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)actualNewOrganisation.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)newId)));
        MatcherAssert.assertThat((Object)actualNewOrganisation.getTestbeds(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualNewOrganisation.getTestbeds(), (Matcher)Matchers.hasSize((int)0));
        this.organisationTestCollection.assertSame((JsonLdObjectWithId)actualNewOrganisation, (JsonLdObjectWithId)expectedNewOrganisation, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.ID_ONLY);
    }

    static {
        lock = new ReentrantLock();
    }
}

