/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ResourceDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ResourceTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class ResourceDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static ResourceDao resourceDao;
    private static Lock lock;
    private ResourceTestCollection resourceTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        resourceDao = (ResourceDao)jdbi.onDemand(ResourceDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)resourceDao);
        jdbi = null;
        resourceDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.resourceTestCollection = new ResourceTestCollection(false, false, true);
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testFindById0() throws Exception {
        Resource expectedResource = (Resource)this.resourceTestCollection.getByIndex(0);
        Resource actualResource = resourceDao.findById((Integer)expectedResource.getId()).create();
        this.resourceTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualResource, (JsonLdObjectWithId)expectedResource);
    }

    @Test
    public void testFindById1() throws Exception {
        Resource expectedResource = (Resource)this.resourceTestCollection.getByIndex(1);
        Resource actualResource = resourceDao.findById((Integer)expectedResource.getId()).create();
        this.resourceTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualResource, (JsonLdObjectWithId)expectedResource);
    }

    @Test
    public void testFindById2() throws Exception {
        Resource expectedResource = (Resource)this.resourceTestCollection.getByIndex(2);
        Resource actualResource = resourceDao.findById((Integer)expectedResource.getId()).create();
        this.resourceTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualResource, (JsonLdObjectWithId)expectedResource);
    }

    @Test
    public void testFindById3() throws Exception {
        Resource expectedResource = (Resource)this.resourceTestCollection.getByIndex(3);
        Resource actualResource = resourceDao.findById((Integer)expectedResource.getId()).create();
        this.resourceTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualResource, (JsonLdObjectWithId)expectedResource);
    }

    @Test
    public void testFindAll() throws Exception {
        List res = resourceDao.findAll();
        System.out.println("testFindAll res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)this.resourceTestCollection.getSize()));
        for (ResourceBuilder resResource : res) {
            MatcherAssert.assertThat((Object)resResource, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Resource origResource = (Resource)this.resourceTestCollection.getById((Integer)resResource.getId());
            MatcherAssert.assertThat((Object)origResource, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.resourceTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resResource.create(), (JsonLdObjectWithId)origResource);
        }
    }

    @Test
    public void testInsert() {
        Resource newResource = ((ResourceBuilder)new ResourceBuilder((Resource)this.resourceTestCollection.getByIndex(0)).setId(null)).setComponentUrn("urn:publicid:IDN+zzz.example.com+node+5").setSliverType("test-insert").setAllowedSliverTypes(Arrays.asList("test-insert", "more")).create();
        Integer newId = resourceDao.insert(newResource);
        MatcherAssert.assertThat((Object)newId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Resource expectedResource = ((ResourceBuilder)new ResourceBuilder(newResource).setId((Object)newId)).create();
        Resource actualNewResource = resourceDao.findById(newId).create();
        System.out.println("Lookup inserted resource (" + newId + ") result: " + actualNewResource);
        MatcherAssert.assertThat((Object)actualNewResource, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)actualNewResource.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)newId)));
        this.resourceTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)expectedResource, (JsonLdObjectWithId)actualNewResource);
    }

    @Test
    public void testUpdate() {
        Resource origResource = (Resource)this.resourceTestCollection.getByIndex(0);
        Resource updatedResource = new ResourceBuilder(origResource).setComponentUrn("urn:publicid:IDN+zzz.example.com+node+5").setSliverType("test-update").setAllowedSliverTypes(Arrays.asList("test-update", "blah", "blih")).setOverwriteServerName("New overwrite server name").setAllowSiteSelection(Boolean.valueOf(true)).create();
        resourceDao.update(updatedResource);
        Resource actualUpdatedResource = resourceDao.findById((Integer)origResource.getId()).create();
        System.out.println("Lookup updated resource (" + origResource.getId() + ") result: " + actualUpdatedResource);
        MatcherAssert.assertThat((Object)actualUpdatedResource, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)actualUpdatedResource.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Integer)origResource.getId()))));
        this.resourceTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)updatedResource, (JsonLdObjectWithId)actualUpdatedResource);
    }

    static {
        lock = new ReentrantLock();
    }
}

