/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ServerGlimpseDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.GuiConfigSetTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServerGlimpseTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.UserInfoTestCollection;
import be.iminds.ilabt.util.jsonld.UriTool;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class ServerGlimpseDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static ServerGlimpseDao serverGlimpseDao;
    private static Lock lock;
    private UserInfoTestCollection userInfoTestCollection;
    private GuiConfigSetTestCollection guiConfigSetTestCollection;
    private ServerGlimpseTestCollection serverGlimpseTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        serverGlimpseDao = (ServerGlimpseDao)jdbi.onDemand(ServerGlimpseDao.class);
        assert (serverGlimpseDao != null);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)serverGlimpseDao);
        jdbi = null;
        serverGlimpseDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        assert (serverGlimpseDao != null);
        this.serverGlimpseTestCollection = new ServerGlimpseTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testTestCollection() throws Exception {
        UriTool uriTool = ((FedmonWebApiServiceConfiguration)RULE.getConfiguration()).getJsonLdObjectsMetaData().makeUriTool("http://localhost:9000");
        this.serverGlimpseTestCollection.setUri(0, uriTool);
        ServerGlimpse sg = (ServerGlimpse)this.serverGlimpseTestCollection.getByIndex(0);
        MatcherAssert.assertThat((Object)sg.getAdvertisementInfo(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)sg.getHealthInfo(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)sg.getServer(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)sg.getAdvertisementInfo().getResult(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)sg.getHealthInfo().getResult(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)sg.getServer().getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Long)sg.getAdvertisementInfo().getResult().getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Long)sg.getHealthInfo().getResult().getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)sg.getServer().getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)sg.getAdvertisementInfo().getResult().getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)sg.getHealthInfo().getResult().getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testGet0() throws Exception {
        assert (serverGlimpseDao != null);
        ServerGlimpse actual = serverGlimpseDao.getServerGlimpse(Integer.valueOf(99)).create();
        ServerGlimpse expected = (ServerGlimpse)this.serverGlimpseTestCollection.getByIndex(0);
        System.out.println("testGetConfig 0 res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverGlimpseTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expected, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test
    public void testGet1() throws Exception {
        assert (serverGlimpseDao != null);
        ServerGlimpse actual = serverGlimpseDao.getServerGlimpse(Integer.valueOf(100)).create();
        ServerGlimpse expected = (ServerGlimpse)this.serverGlimpseTestCollection.getByIndex(1);
        System.out.println("testGetConfig 1 res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverGlimpseTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expected, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test
    public void testFindAll() throws Exception {
        List res = ServerGlimpseBuilder.createAll((Collection)serverGlimpseDao.findAllServerGlimpses());
        System.out.println("testFindAll res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)this.serverGlimpseTestCollection.getSize()));
        for (ServerGlimpse resServerGlimpse : res) {
            MatcherAssert.assertThat((Object)resServerGlimpse, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)resServerGlimpse.getServerId(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            ServerGlimpse origServerGlimpse = this.serverGlimpseTestCollection.getByServerId(resServerGlimpse.getServerId());
            MatcherAssert.assertThat((Object)origServerGlimpse, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.serverGlimpseTestCollection.assertSame((JsonLdObject)resServerGlimpse, (JsonLdObject)origServerGlimpse, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
        }
    }

    @Test
    public void testUpsertInsert1() throws Exception {
        boolean changeAdvertisement = true;
        boolean changeHealth = true;
        boolean changeReputation = false;
        boolean changeMaintenance = false;
        ServerGlimpse update = this.serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        assert (update.getServerId() != null);
        serverGlimpseDao.deleteByServerId(update.getServerId());
        serverGlimpseDao.upsert(update, update.getAdvertisementInfo() != null, update.getHealthInfo() != null, update.getReputation() != null, update.getMaintenance() != null);
        assert (serverGlimpseDao != null);
        ServerGlimpse actual = serverGlimpseDao.getServerGlimpse(update.getServerId()).create();
        ServerGlimpse expected = update;
        System.out.println("testUpsertInsert res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverGlimpseTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expected, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test
    public void testUpsertInsert2() throws Exception {
        boolean changeAdvertisement = false;
        boolean changeHealth = true;
        boolean changeReputation = false;
        boolean changeMaintenance = false;
        ServerGlimpse update = this.serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        assert (update.getServerId() != null);
        serverGlimpseDao.deleteByServerId(update.getServerId());
        serverGlimpseDao.upsert(update, update.getAdvertisementInfo() != null, update.getHealthInfo() != null, update.getReputation() != null, update.getMaintenance() != null);
        assert (serverGlimpseDao != null);
        ServerGlimpse actual = serverGlimpseDao.getServerGlimpse(update.getServerId()).create();
        ServerGlimpse expected = update;
        System.out.println("testUpsertInsert res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverGlimpseTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expected, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test
    public void testUpsertInsert3() throws Exception {
        boolean changeAdvertisement = true;
        boolean changeHealth = false;
        boolean changeReputation = false;
        boolean changeMaintenance = false;
        ServerGlimpse update = this.serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        assert (update.getServerId() != null);
        serverGlimpseDao.deleteByServerId(update.getServerId());
        serverGlimpseDao.upsert(update, update.getAdvertisementInfo() != null, update.getHealthInfo() != null, update.getReputation() != null, update.getMaintenance() != null);
        assert (serverGlimpseDao != null);
        ServerGlimpse actual = serverGlimpseDao.getServerGlimpse(update.getServerId()).create();
        ServerGlimpse expected = update;
        System.out.println("testUpsertInsert res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverGlimpseTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expected, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test
    public void testUpsertInsert4() throws Exception {
        boolean changeAdvertisement = false;
        boolean changeHealth = false;
        boolean changeReputation = false;
        boolean changeMaintenance = false;
        ServerGlimpse update = this.serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        assert (update.getServerId() != null);
        serverGlimpseDao.deleteByServerId(update.getServerId());
        serverGlimpseDao.upsert(update, update.getAdvertisementInfo() != null, update.getHealthInfo() != null, update.getReputation() != null, update.getMaintenance() != null);
        assert (serverGlimpseDao != null);
        ServerGlimpseBuilder actual = serverGlimpseDao.getServerGlimpse(update.getServerId());
        System.out.println("testUpsertInsert res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testUpsertInsert5() throws Exception {
        boolean changeAdvertisement = false;
        boolean changeHealth = false;
        boolean changeReputation = true;
        boolean changeMaintenance = true;
        ServerGlimpse update = this.serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        assert (update.getServerId() != null);
        serverGlimpseDao.deleteByServerId(update.getServerId());
        serverGlimpseDao.upsert(update, update.getAdvertisementInfo() != null, update.getHealthInfo() != null, update.getReputation() != null, update.getMaintenance() != null);
        assert (serverGlimpseDao != null);
        ServerGlimpse actual = serverGlimpseDao.getServerGlimpse(update.getServerId()).create();
        ServerGlimpse expected = update;
        System.out.println("testUpsertInsert res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverGlimpseTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expected, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test
    public void testUpsertInsert6() throws Exception {
        boolean changeAdvertisement = true;
        boolean changeHealth = true;
        boolean changeReputation = true;
        boolean changeMaintenance = true;
        ServerGlimpse update = this.serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        assert (update.getServerId() != null);
        serverGlimpseDao.deleteByServerId(update.getServerId());
        serverGlimpseDao.upsert(update, update.getAdvertisementInfo() != null, update.getHealthInfo() != null, update.getReputation() != null, update.getMaintenance() != null);
        assert (serverGlimpseDao != null);
        ServerGlimpse actual = serverGlimpseDao.getServerGlimpse(update.getServerId()).create();
        ServerGlimpse expected = update;
        System.out.println("testUpsertInsert res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverGlimpseTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expected, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test
    public void testUpsertUpdate1() throws Exception {
        boolean changeAdvertisement = true;
        boolean changeHealth = true;
        boolean changeReputation = false;
        boolean changeMaintenance = false;
        ServerGlimpse update = this.serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        assert (update.getAdvertisementInfo() == null != changeAdvertisement);
        assert (update.getHealthInfo() == null != changeHealth);
        assert (update.getReputation() == null != changeReputation);
        assert (update.getMaintenance() == null != changeMaintenance);
        ServerGlimpse origBeforeUpdate = this.serverGlimpseTestCollection.getByServerId(update.getServerId());
        assert (update.getServerId() != null);
        serverGlimpseDao.upsert(update, update.getAdvertisementInfo() != null, update.getHealthInfo() != null, update.getReputation() != null, update.getMaintenance() != null);
        assert (serverGlimpseDao != null);
        ServerGlimpse actual = serverGlimpseDao.getServerGlimpse(update.getServerId()).create();
        ServerGlimpseBuilder expectedBuilder = new ServerGlimpseBuilder(update);
        if (!changeAdvertisement) {
            expectedBuilder.setAdvertisementInfo(origBeforeUpdate.getAdvertisementInfo());
        }
        if (!changeHealth) {
            expectedBuilder.setHealthInfo(origBeforeUpdate.getHealthInfo());
        }
        if (!changeReputation) {
            expectedBuilder.setReputation(origBeforeUpdate.getReputation());
        }
        if (!changeMaintenance) {
            expectedBuilder.setMaintenance(origBeforeUpdate.getMaintenance());
        }
        System.out.println("testUpsertUpdate res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverGlimpseTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expectedBuilder.create(), CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test
    public void testUpsertUpdate2() throws Exception {
        boolean changeAdvertisement = false;
        boolean changeHealth = true;
        boolean changeReputation = false;
        boolean changeMaintenance = false;
        ServerGlimpse update = this.serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        assert (update.getAdvertisementInfo() == null != changeAdvertisement);
        assert (update.getHealthInfo() == null != changeHealth);
        assert (update.getReputation() == null != changeReputation);
        assert (update.getMaintenance() == null != changeMaintenance);
        ServerGlimpse origBeforeUpdate = this.serverGlimpseTestCollection.getByServerId(update.getServerId());
        assert (update.getServerId() != null);
        serverGlimpseDao.upsert(update, update.getAdvertisementInfo() != null, update.getHealthInfo() != null, update.getReputation() != null, update.getMaintenance() != null);
        assert (serverGlimpseDao != null);
        ServerGlimpse actual = serverGlimpseDao.getServerGlimpse(update.getServerId()).create();
        ServerGlimpseBuilder expectedBuilder = new ServerGlimpseBuilder(update);
        if (!changeAdvertisement) {
            expectedBuilder.setAdvertisementInfo(origBeforeUpdate.getAdvertisementInfo());
        }
        if (!changeHealth) {
            expectedBuilder.setHealthInfo(origBeforeUpdate.getHealthInfo());
        }
        if (!changeReputation) {
            expectedBuilder.setReputation(origBeforeUpdate.getReputation());
        }
        if (!changeMaintenance) {
            expectedBuilder.setMaintenance(origBeforeUpdate.getMaintenance());
        }
        System.out.println("testUpsertUpdate res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverGlimpseTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expectedBuilder.create(), CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test
    public void testUpsertUpdate3() throws Exception {
        boolean changeAdvertisement = true;
        boolean changeHealth = false;
        boolean changeReputation = false;
        boolean changeMaintenance = false;
        ServerGlimpse update = this.serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        assert (update.getAdvertisementInfo() == null != changeAdvertisement);
        assert (update.getHealthInfo() == null != changeHealth);
        assert (update.getReputation() == null != changeReputation);
        assert (update.getMaintenance() == null != changeMaintenance);
        ServerGlimpse origBeforeUpdate = this.serverGlimpseTestCollection.getByServerId(update.getServerId());
        assert (update.getServerId() != null);
        serverGlimpseDao.upsert(update, update.getAdvertisementInfo() != null, update.getHealthInfo() != null, update.getReputation() != null, update.getMaintenance() != null);
        assert (serverGlimpseDao != null);
        ServerGlimpse actual = serverGlimpseDao.getServerGlimpse(update.getServerId()).create();
        ServerGlimpseBuilder expectedBuilder = new ServerGlimpseBuilder(update);
        if (!changeAdvertisement) {
            expectedBuilder.setAdvertisementInfo(origBeforeUpdate.getAdvertisementInfo());
        }
        if (!changeHealth) {
            expectedBuilder.setHealthInfo(origBeforeUpdate.getHealthInfo());
        }
        if (!changeReputation) {
            expectedBuilder.setReputation(origBeforeUpdate.getReputation());
        }
        if (!changeMaintenance) {
            expectedBuilder.setMaintenance(origBeforeUpdate.getMaintenance());
        }
        System.out.println("testUpsertUpdate res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverGlimpseTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expectedBuilder.create(), CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test
    public void testUpsertUpdate4() throws Exception {
        boolean changeAdvertisement = false;
        boolean changeHealth = false;
        boolean changeReputation = false;
        boolean changeMaintenance = false;
        ServerGlimpse update = this.serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        assert (update.getAdvertisementInfo() == null != changeAdvertisement);
        assert (update.getHealthInfo() == null != changeHealth);
        assert (update.getReputation() == null != changeReputation);
        assert (update.getMaintenance() == null != changeMaintenance);
        ServerGlimpse origBeforeUpdate = this.serverGlimpseTestCollection.getByServerId(update.getServerId());
        assert (update.getServerId() != null);
        serverGlimpseDao.upsert(update, update.getAdvertisementInfo() != null, update.getHealthInfo() != null, update.getReputation() != null, update.getMaintenance() != null);
        assert (serverGlimpseDao != null);
        ServerGlimpse actual = serverGlimpseDao.getServerGlimpse(update.getServerId()).create();
        ServerGlimpseBuilder expectedBuilder = new ServerGlimpseBuilder(update);
        if (!changeAdvertisement) {
            expectedBuilder.setAdvertisementInfo(origBeforeUpdate.getAdvertisementInfo());
        }
        if (!changeHealth) {
            expectedBuilder.setHealthInfo(origBeforeUpdate.getHealthInfo());
        }
        if (!changeReputation) {
            expectedBuilder.setReputation(origBeforeUpdate.getReputation());
        }
        if (!changeMaintenance) {
            expectedBuilder.setMaintenance(origBeforeUpdate.getMaintenance());
        }
        System.out.println("testUpsertUpdate res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverGlimpseTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expectedBuilder.create(), CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test
    public void testUpsertUpdate5() throws Exception {
        boolean changeAdvertisement = false;
        boolean changeHealth = false;
        boolean changeReputation = true;
        boolean changeMaintenance = true;
        ServerGlimpse update = this.serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        assert (update.getAdvertisementInfo() == null != changeAdvertisement);
        assert (update.getHealthInfo() == null != changeHealth);
        assert (update.getReputation() == null != changeReputation);
        assert (update.getMaintenance() == null != changeMaintenance);
        ServerGlimpse origBeforeUpdate = this.serverGlimpseTestCollection.getByServerId(update.getServerId());
        assert (update.getServerId() != null);
        serverGlimpseDao.upsert(update, update.getAdvertisementInfo() != null, update.getHealthInfo() != null, update.getReputation() != null, update.getMaintenance() != null);
        assert (serverGlimpseDao != null);
        ServerGlimpse actual = serverGlimpseDao.getServerGlimpse(update.getServerId()).create();
        ServerGlimpseBuilder expectedBuilder = new ServerGlimpseBuilder(update);
        if (!changeAdvertisement) {
            expectedBuilder.setAdvertisementInfo(origBeforeUpdate.getAdvertisementInfo());
        }
        if (!changeHealth) {
            expectedBuilder.setHealthInfo(origBeforeUpdate.getHealthInfo());
        }
        if (!changeReputation) {
            expectedBuilder.setReputation(origBeforeUpdate.getReputation());
        }
        if (!changeMaintenance) {
            expectedBuilder.setMaintenance(origBeforeUpdate.getMaintenance());
        }
        System.out.println("testUpsertUpdate res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverGlimpseTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expectedBuilder.create(), CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test
    public void testUpsertUpdate6() throws Exception {
        boolean changeAdvertisement = true;
        boolean changeHealth = true;
        boolean changeReputation = true;
        boolean changeMaintenance = true;
        ServerGlimpse update = this.serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        assert (update.getAdvertisementInfo() == null != changeAdvertisement);
        assert (update.getHealthInfo() == null != changeHealth);
        assert (update.getReputation() == null != changeReputation);
        assert (update.getMaintenance() == null != changeMaintenance);
        ServerGlimpse origBeforeUpdate = this.serverGlimpseTestCollection.getByServerId(update.getServerId());
        assert (update.getServerId() != null);
        serverGlimpseDao.upsert(update, update.getAdvertisementInfo() != null, update.getHealthInfo() != null, update.getReputation() != null, update.getMaintenance() != null);
        assert (serverGlimpseDao != null);
        ServerGlimpse actual = serverGlimpseDao.getServerGlimpse(update.getServerId()).create();
        ServerGlimpseBuilder expectedBuilder = new ServerGlimpseBuilder(update);
        if (!changeAdvertisement) {
            expectedBuilder.setAdvertisementInfo(origBeforeUpdate.getAdvertisementInfo());
        }
        if (!changeHealth) {
            expectedBuilder.setHealthInfo(origBeforeUpdate.getHealthInfo());
        }
        if (!changeReputation) {
            expectedBuilder.setReputation(origBeforeUpdate.getReputation());
        }
        if (!changeMaintenance) {
            expectedBuilder.setMaintenance(origBeforeUpdate.getMaintenance());
        }
        System.out.println("testUpsertUpdate res = " + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.serverGlimpseTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expectedBuilder.create(), CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    static {
        lock = new ReentrantLock();
    }
}

