/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ServiceDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServerTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServiceTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class ServiceDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static ServiceDao serviceDao;
    private static Lock lock;
    private static Clock.DefaultTestTimeProvider timeProvider;
    private ServerTestCollection serverTestCollection;
    private ServiceTestCollection serviceTestCollection;
    private TestInstancesTestCollection testInstances;

    @BeforeClass
    public static void setUp() throws Exception {
        timeProvider = new Clock.DefaultTestTimeProvider();
        Clock.set((Clock.CurrentTimeProvider)timeProvider);
        Clock.lockProvider();
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        serviceDao = (ServiceDao)jdbi.onDemand(ServiceDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)serviceDao);
        jdbi = null;
        serviceDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        timeProvider.setNowOffsetMinutes(0L);
        this.serviceTestCollection = new ServiceTestCollection();
        this.serverTestCollection = new ServerTestCollection();
        this.testInstances = new TestInstancesTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testInsert() throws Exception {
        Server serverA = (Server)this.serverTestCollection.getByIndex(0);
        Service newService = new ServiceBuilder().setApi("Geni.AM").setApiVersion("3").setUrl("URL").setUrn("urn:publicid:IDN+new.example.com+authority+cm").setServer(serverA).create();
        Integer newId = serviceDao.insert(newService);
        MatcherAssert.assertThat((Object)newId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        ServiceBuilder expectedNewServiceBuilder = new ServiceBuilder(newService);
        expectedNewServiceBuilder.setId((Object)newId);
        ((FedmonWebApiServiceConfiguration)RULE.getConfiguration()).getJsonLdObjectsMetaData().makeUriTool("http://localhost:9000").setBuilderUri((PrimaryIdObjectBuilder)expectedNewServiceBuilder, true);
        Service expectedNewService = expectedNewServiceBuilder.create();
        Service actualNewService = serviceDao.findById(newId);
        System.out.println("Lookup inserted service (" + newId + ") result: " + actualNewService);
        MatcherAssert.assertThat((Object)actualNewService, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)actualNewService.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)newId)));
        this.serviceTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)expectedNewService, (JsonLdObjectWithId)actualNewService, true);
    }

    static {
        lock = new ReentrantLock();
    }
}

