/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TaskDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.UserDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TaskBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TaskTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestClock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesStatisticsTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class TaskDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static TaskDao taskDao;
    private static UserDao userDao;
    private static Lock lock;
    private static Clock.DefaultTestTimeProvider timeProvider;
    private TaskTestCollection taskTestCollection;
    private TestInstancesTestCollection testInstances;
    private TestInstancesStatisticsTestCollection testInstanceStatistics;

    @BeforeClass
    public static void setUp() throws Exception {
        timeProvider = new Clock.DefaultTestTimeProvider();
        Clock.set((Clock.CurrentTimeProvider)timeProvider);
        Clock.lockProvider();
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        taskDao = (TaskDao)jdbi.onDemand(TaskDao.class);
        userDao = (UserDao)jdbi.onDemand(UserDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)taskDao);
        jdbi.close((Object)userDao);
        jdbi = null;
        taskDao = null;
        userDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        timeProvider.setNowOffsetMinutes(0L);
        this.taskTestCollection = new TaskTestCollection();
        this.testInstances = new TestInstancesTestCollection();
        this.testInstanceStatistics = new TestInstancesStatisticsTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testInsert() throws Exception {
        TestInstance testinstance = (TestInstance)this.testInstances.getById(9);
        Timestamp starttime = TestClock.get().getOffsetMinutes(10L);
        Timestamp deadline = TestClock.get().getOffsetMinutes(20L);
        Timestamp endTime = null;
        String log = "new task log";
        Long resultId = null;
        String runInfo = "new task run info";
        Task.State state = Task.State.CREATED;
        Task newTask = new TaskBuilder().setTestInstance(testinstance).setStart(starttime).setDeadline(deadline).setStop(endTime).setLog(log).setResult(resultId, null).setRunInfo(runInfo).setState(state).create();
        Long newId = taskDao.insert(newTask);
        MatcherAssert.assertThat((Object)newId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        ArrayList<Task> expectedAllTasks = new ArrayList<Task>(this.taskTestCollection.getAll());
        expectedAllTasks.add(((TaskBuilder)new TaskBuilder(newTask).setId((Object)newId)).create());
        List res = taskDao.findAll(10);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)expectedAllTasks.size()));
        for (Task resTask : res) {
            MatcherAssert.assertThat((Object)resTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Task origTask = (Task)this.taskTestCollection.searchListById(expectedAllTasks, (Long)resTask.getId());
            MatcherAssert.assertThat((Object)origTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resTask, (JsonLdObjectWithId)origTask);
        }
    }

    @Test
    public void testCancel() throws Exception {
        long id = (Long)((Task)this.taskTestCollection.getByIndex(1)).getId();
        Task actualTask = taskDao.findById(Long.valueOf(id));
        timeProvider.setNowOffset(actualTask.getStart());
        timeProvider.relativeNowOffsetMinutes(1L);
        assert (actualTask.getState() == Task.State.RUNNING);
        assert (timeProvider.currentTimeMillis() > actualTask.getStart().getTime());
        assert (timeProvider.currentTimeMillis() < actualTask.getDeadline().getTime());
        taskDao.updateState(Long.valueOf(id), Task.State.CANCELLING, Clock.nowTimestamp());
        Task expectedTask = new TaskBuilder((Task)this.taskTestCollection.getById(id)).setState(Task.State.CANCELLING).create();
        this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTask, (JsonLdObjectWithId)expectedTask);
    }

    @Test
    public void testSetResult() throws Exception {
        long resId = 50L;
        long id = (Long)((Task)this.taskTestCollection.getByIndex(0)).getId();
        taskDao.setResult(Long.valueOf(id), Long.valueOf(resId));
        Task actualTask = taskDao.findById(Long.valueOf(id));
        Task expectedTask = new TaskBuilder((Task)this.taskTestCollection.getById(id)).setResult(Long.valueOf(resId), null).create();
        this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTask, (JsonLdObjectWithId)expectedTask);
    }

    @Test
    public void testUpdateSuccess1() throws Exception {
        Task task1 = (Task)this.taskTestCollection.getByIndex(0);
        timeProvider.setNowOffset(task1.getStart());
        timeProvider.relativeNowOffsetMinutes(1L);
        assert (task1.getState() == Task.State.CREATED);
        assert (timeProvider.currentTimeMillis() > task1.getStart().getTime());
        assert (timeProvider.currentTimeMillis() < task1.getDeadline().getTime());
        Task updatedTask = new TaskBuilder(task1).setState(Task.State.CANCELLED).setResult(Long.valueOf(53L), null).setRunInfo("new run info").create();
        taskDao.updateAll(updatedTask, Clock.nowTimestamp());
        Task actualTask = taskDao.findById((Long)updatedTask.getId());
        this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTask, (JsonLdObjectWithId)updatedTask);
    }

    @Test
    public void testUpdateFail1() throws Exception {
        Task task = (Task)this.taskTestCollection.getByIndex(3);
        timeProvider.setNowOffset(task.getStop());
        timeProvider.relativeNowOffsetMillis(30000L);
        assert (task.getState() == Task.State.CANCELLED);
        assert (timeProvider.currentTimeMillis() > task.getStart().getTime());
        assert (timeProvider.currentTimeMillis() > task.getStop().getTime());
        assert (timeProvider.currentTimeMillis() < task.getDeadline().getTime());
        Task updatedTask = new TaskBuilder(task).setState(Task.State.FINISHED).setResult(Long.valueOf(53L), null).setRunInfo("new run info").create();
        taskDao.updateAll(updatedTask, Clock.nowTimestamp());
        Task actualTask = taskDao.findById((Long)updatedTask.getId());
        Task expectedTask = (Task)this.taskTestCollection.getByIndex(3);
        this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTask, (JsonLdObjectWithId)expectedTask);
    }

    @Test
    public void testUpdateFail2() throws Exception {
        Task task1 = (Task)this.taskTestCollection.getByIndex(0);
        timeProvider.setNowOffset(task1.getDeadline());
        timeProvider.relativeNowOffsetMinutes(1L);
        assert (task1.getState() == Task.State.CREATED);
        assert (timeProvider.currentTimeMillis() > task1.getStart().getTime());
        assert (timeProvider.currentTimeMillis() > task1.getDeadline().getTime());
        Task updatedTask = new TaskBuilder(task1).setState(Task.State.CANCELLED).setResult(Long.valueOf(53L), null).setRunInfo("new run info").create();
        taskDao.updateAll(updatedTask, Clock.nowTimestamp());
        Task actualTask = taskDao.findById((Long)updatedTask.getId());
        Task expectedTask = (Task)this.taskTestCollection.getByIndex(0);
        this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTask, (JsonLdObjectWithId)expectedTask);
    }

    @Test
    public void testFindById1() throws Exception {
        long id = 1L;
        Task actualTask = taskDao.findById(Long.valueOf(id));
        Task expectedTask = (Task)this.taskTestCollection.getById(id);
        this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTask, (JsonLdObjectWithId)expectedTask);
    }

    @Test
    public void testFindById2() throws Exception {
        long id = 2L;
        Task actualTask = taskDao.findById(Long.valueOf(id));
        Task expectedTask = (Task)this.taskTestCollection.getById(id);
        this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTask, (JsonLdObjectWithId)expectedTask);
    }

    @Test
    public void testFindById3() throws Exception {
        long id = 3L;
        Task actualTask = taskDao.findById(Long.valueOf(id));
        Task expectedTask = (Task)this.taskTestCollection.getById(id);
        this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTask, (JsonLdObjectWithId)expectedTask);
    }

    @Test
    public void testFindById4() throws Exception {
        long id = 4L;
        Task actualTask = taskDao.findById(Long.valueOf(id));
        Task expectedTask = (Task)this.taskTestCollection.getById(id);
        this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTask, (JsonLdObjectWithId)expectedTask);
    }

    @Test
    public void testFindByTestInstanceId1() throws Exception {
        int testInstanceId = 9;
        HashMap<Long, Task> expectedRes = new HashMap<Long, Task>();
        for (Task t : this.taskTestCollection.getAll()) {
            if (t.getTestInstanceId() != testInstanceId) continue;
            expectedRes.put((Long)t.getId(), t);
        }
        List actualRes = taskDao.findByTestInstanceId(Integer.valueOf(9));
        MatcherAssert.assertThat((Object)actualRes, (Matcher)Matchers.hasSize((int)expectedRes.size()));
        for (Task resTask : actualRes) {
            MatcherAssert.assertThat((Object)resTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Task origTask = (Task)expectedRes.get(resTask.getId());
            MatcherAssert.assertThat((Object)origTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resTask, (JsonLdObjectWithId)origTask);
        }
    }

    @Test
    public void testFindByTestInstanceId2() throws Exception {
        int testInstanceId = 9;
        HashMap<Long, Task> expectedRes = new HashMap<Long, Task>();
        for (Task t : this.taskTestCollection.getAll()) {
            if (!t.getTestInstanceId().equals(testInstanceId)) continue;
            expectedRes.put((Long)t.getId(), t);
        }
        List actualRes = taskDao.findByTestInstanceId(Integer.valueOf(testInstanceId));
        MatcherAssert.assertThat((Object)actualRes, (Matcher)Matchers.hasSize((int)expectedRes.size()));
        for (Task resTask : actualRes) {
            MatcherAssert.assertThat((Object)resTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)resTask.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)testInstanceId)));
            Task origTask = (Task)expectedRes.get(resTask.getId());
            MatcherAssert.assertThat((String)("Did not find original task for id " + resTask.getId()), (Object)origTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resTask, (JsonLdObjectWithId)origTask);
        }
    }

    @Test
    public void testFindAll() throws Exception {
        List res = taskDao.findAll(10);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)this.taskTestCollection.getSize()));
        for (Task resTask : res) {
            MatcherAssert.assertThat((Object)resTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Task origTask = (Task)this.taskTestCollection.getById((Long)resTask.getId());
            MatcherAssert.assertThat((Object)origTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resTask, (JsonLdObjectWithId)origTask);
        }
    }

    @Test
    public void testFindAllLimit1() throws Exception {
        int limit = 1;
        List res = taskDao.findAll(limit);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)limit));
        MatcherAssert.assertThat((Object)((Long)((Task)res.get(0)).getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)4L)));
    }

    @Test
    public void testFindAllLimit2() throws Exception {
        int limit = 2;
        List res = taskDao.findAll(limit);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)limit));
    }

    @Test
    public void testFindActive() throws Exception {
        timeProvider.setNowOffset(TestClock.get().getBase());
        timeProvider.relativeNowOffsetMinutes(1L);
        List res = taskDao.findActive(10, Clock.nowTimestamp());
        HashMap<Long, Task> expectedRes = new HashMap<Long, Task>();
        for (Task t : this.taskTestCollection.getAll()) {
            Task tt = new TaskBuilder(t).useImplicitState().create();
            if (!tt.isInActiveState()) continue;
            expectedRes.put((Long)t.getId(), tt);
        }
        assert (expectedRes.size() == 2);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)expectedRes.size()));
        for (Task resTask : res) {
            MatcherAssert.assertThat((Object)resTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Task origTask = (Task)expectedRes.get(resTask.getId());
            MatcherAssert.assertThat((Object)origTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resTask, (JsonLdObjectWithId)origTask);
        }
    }

    @Test
    public void testFindHistoric() throws Exception {
        timeProvider.setNowOffset(TestClock.get().getBase());
        timeProvider.relativeNowOffsetMinutes(1L);
        List res = taskDao.findHistoric(10, Clock.nowTimestamp());
        HashMap<Long, Task> expectedRes = new HashMap<Long, Task>();
        for (Task t : this.taskTestCollection.getAll()) {
            if (t.isInActiveState()) continue;
            expectedRes.put((Long)t.getId(), t);
        }
        assert (expectedRes.size() == 2);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)expectedRes.size()));
        for (Task resTask : res) {
            MatcherAssert.assertThat((Object)resTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Task origTask = (Task)expectedRes.get(resTask.getId());
            MatcherAssert.assertThat((Object)origTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resTask, (JsonLdObjectWithId)origTask);
        }
    }

    @Test
    public void testFindExpired() throws Exception {
        List res = taskDao.findExpired(10, Clock.nowTimestamp());
        Timestamp now = new Timestamp(Clock.currentTimeMillis());
        HashMap<Long, Task> expectedRes = new HashMap<Long, Task>();
        for (Task t : this.taskTestCollection.getAll()) {
            if (!t.isInActiveState() || !t.getDeadline().before(now)) continue;
            expectedRes.put((Long)t.getId(), t);
        }
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)expectedRes.size()));
        for (Task resTask : res) {
            MatcherAssert.assertThat((Object)resTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Task origTask = (Task)expectedRes.get(resTask.getId());
            MatcherAssert.assertThat((Object)origTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resTask, (JsonLdObjectWithId)origTask);
        }
    }

    @Test
    public void testHandleExpired() throws Exception {
        List res = taskDao.handleExpired(Clock.nowTimestamp());
        Timestamp now = new Timestamp(Clock.currentTimeMillis());
        HashMap<Long, Task> expectedRes = new HashMap<Long, Task>();
        for (Task t : this.taskTestCollection.getAll()) {
            if (!t.isInActiveState() || !t.getDeadline().before(now)) continue;
            expectedRes.put((Long)t.getId(), t);
        }
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)expectedRes.size()));
        for (Task resTask : res) {
            MatcherAssert.assertThat((Object)resTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Task origTask = (Task)expectedRes.get(resTask.getId());
            MatcherAssert.assertThat((Object)origTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)resTask.getState(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Task.State.EXPIRED)));
            this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resTask, (JsonLdObjectWithId)origTask);
            Task dbTask = taskDao.findById((Long)resTask.getId());
            MatcherAssert.assertThat((Object)dbTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)dbTask.getState(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Task.State.EXPIRED)));
            this.taskTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resTask, (JsonLdObjectWithId)dbTask);
        }
    }

    @Test
    public void testDeleteById() throws Exception {
        long id = 1L;
        taskDao.deleteById(Long.valueOf(id));
        List res = taskDao.findAll(10);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)(this.taskTestCollection.getSize() - 1)));
        Task actualTask = taskDao.findById(Long.valueOf(id));
        MatcherAssert.assertThat((Object)actualTask, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testDelete() throws Exception {
        long id = 1L;
        Task task = (Task)this.taskTestCollection.getById(id);
        taskDao.delete(task);
        List res = taskDao.findAll(10);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)(this.taskTestCollection.getSize() - 1)));
        Task actualTask = taskDao.findById(Long.valueOf(id));
        MatcherAssert.assertThat((Object)actualTask, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testSearchAndCreate9aWhileRunning() throws Exception {
        timeProvider.setNowOffset(TestClock.get().getBase());
        timeProvider.relativeNowOffsetMinutes(1L);
        int testInstanceId = 9;
        Timestamp start = Clock.nowTimestamp();
        Timestamp deadline = new Timestamp(Clock.currentTimeMillis() + Task.CREATED_TASK_DEADLINE_MILLIS);
        List createdTasks = taskDao.searchAndCreate(Integer.valueOf(2), Integer.valueOf(testInstanceId), "prod", Arrays.asList("ping"), null, null, "automatically created task", start, deadline, Clock.nowTimestamp());
        MatcherAssert.assertThat((Object)createdTasks, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testSearchAndCreate9aWhenExpired() throws Exception {
        timeProvider.setNowOffset(TestClock.get().getBase());
        timeProvider.relativeNowOffsetMinutes(30L);
        int testInstanceId = 9;
        Timestamp start = Clock.nowTimestamp();
        Timestamp deadline = new Timestamp(Clock.currentTimeMillis() + Task.CREATED_TASK_DEADLINE_MILLIS);
        List createdTasks = taskDao.searchAndCreate(Integer.valueOf(2), Integer.valueOf(testInstanceId), "prod", Arrays.asList("ping"), null, null, "automatically created task", start, deadline, Clock.nowTimestamp());
        MatcherAssert.assertThat((Object)createdTasks, (Matcher)Matchers.hasSize((int)1));
        Task createdTask = (Task)createdTasks.get(0);
        MatcherAssert.assertThat((Object)createdTask.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)testInstanceId)));
        MatcherAssert.assertThat((Object)createdTask.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)createdTask.getRunInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"automatically created task")));
    }

    @Test
    public void testSearchAndCreate9bWhenNotExists() throws Exception {
        int testInstanceId = 9;
        for (Task task : this.taskTestCollection.getAll()) {
            if (task.getTestInstanceId() != testInstanceId || task.getState() != Task.State.RUNNING && task.getState() != Task.State.CREATED) continue;
            taskDao.delete(task);
        }
        Timestamp start = Clock.nowTimestamp();
        Timestamp deadline = new Timestamp(Clock.currentTimeMillis() + Task.CREATED_TASK_DEADLINE_MILLIS);
        List createdTasks = taskDao.searchAndCreate(Integer.valueOf(2), Integer.valueOf(testInstanceId), "prod", Arrays.asList("ping"), null, null, "automatically created task", start, deadline, Clock.nowTimestamp());
        MatcherAssert.assertThat((Object)createdTasks, (Matcher)Matchers.hasSize((int)1));
        Task createdTask = (Task)createdTasks.get(0);
        MatcherAssert.assertThat((Object)createdTask.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)testInstanceId)));
        MatcherAssert.assertThat((Object)createdTask.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)createdTask.getRunInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"automatically created task")));
    }

    @Test
    public void testSearchAndCreate9c() throws Exception {
        int testInstanceId = 9;
        for (Task task : this.taskTestCollection.getAll()) {
            if (task.getTestInstanceId() != testInstanceId || task.getState() != Task.State.RUNNING && task.getState() != Task.State.CREATED) continue;
            taskDao.delete(task);
        }
        Timestamp start = Clock.nowTimestamp();
        Timestamp deadline = new Timestamp(Clock.currentTimeMillis() + Task.CREATED_TASK_DEADLINE_MILLIS);
        List createdTasks = taskDao.searchAndCreate(Integer.valueOf(2), null, null, Arrays.asList("ping"), null, null, "automatically created task", start, deadline, Clock.nowTimestamp());
        MatcherAssert.assertThat((Object)createdTasks, (Matcher)Matchers.hasSize((int)1));
        Task createdTask = (Task)createdTasks.get(0);
        MatcherAssert.assertThat((Object)createdTask.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)testInstanceId)));
        MatcherAssert.assertThat((Object)createdTask.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)createdTask.getRunInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"automatically created task")));
    }

    @Test
    public void testSearchAndCreate10and12and13() throws Exception {
        int testInstanceId1 = 10;
        for (Task task : this.taskTestCollection.getAll()) {
            if (task.getTestInstanceId() != testInstanceId1 || task.getState() != Task.State.RUNNING && task.getState() != Task.State.CREATED) continue;
            taskDao.delete(task);
        }
        timeProvider.setNowOffset(TestClock.get().getBase());
        timeProvider.relativeNowOffsetMinutes(1L);
        Timestamp start = Clock.nowTimestamp();
        Timestamp deadline = new Timestamp(Clock.currentTimeMillis() + Task.CREATED_TASK_DEADLINE_MILLIS);
        List createdTasks = taskDao.searchAndCreate(Integer.valueOf(10), null, null, null, null, null, "automatically created task", start, deadline, Clock.nowTimestamp());
        MatcherAssert.assertThat((Object)createdTasks, (Matcher)Matchers.hasSize((int)1));
        for (Task createdTask : createdTasks) {
            boolean expected = false;
            if (createdTask.getTestInstanceId() == testInstanceId1) {
                MatcherAssert.assertThat((Object)createdTask.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                MatcherAssert.assertThat((Object)createdTask.getRunInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"automatically created task")));
                expected = true;
            }
            MatcherAssert.assertThat((String)("unexpected testInstance returned. id=" + createdTask.getTestInstanceId()), (Object)expected, (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    public void testSearchAndCreate10a() throws Exception {
        int testInstanceId = 9;
        timeProvider.setNowOffset(TestClock.get().getBase());
        timeProvider.relativeNowOffsetMinutes(60L);
        assert (Clock.nowTimestamp().after(((Task)this.taskTestCollection.getByIndex(0)).getStart()));
        assert (Clock.nowTimestamp().after(((Task)this.taskTestCollection.getByIndex(0)).getDeadline()));
        assert (this.testInstanceStatistics.getByTestInstanceId(testInstanceId).getNextRun() != null);
        assert (Clock.nowTimestamp().after(this.testInstanceStatistics.getByTestInstanceId(testInstanceId).getNextRun()));
        Timestamp start = Clock.nowTimestamp();
        Timestamp deadline = new Timestamp(Clock.currentTimeMillis() + Task.CREATED_TASK_DEADLINE_MILLIS);
        List createdTasks = taskDao.searchAndCreate(Integer.valueOf(2), Integer.valueOf(testInstanceId), "test", Arrays.asList("anyGetVersion"), null, null, "automatically created task", start, deadline, Clock.nowTimestamp());
        MatcherAssert.assertThat((Object)createdTasks, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testSearchAndCreate10b() throws Exception {
        int testInstanceId = 9;
        timeProvider.setNowOffset(TestClock.get().getBase());
        timeProvider.relativeNowOffsetMinutes(60L);
        assert (Clock.nowTimestamp().after(((Task)this.taskTestCollection.getByIndex(0)).getStart()));
        assert (Clock.nowTimestamp().after(((Task)this.taskTestCollection.getByIndex(0)).getDeadline()));
        assert (this.testInstanceStatistics.getByTestInstanceId(testInstanceId).getNextRun() != null);
        assert (Clock.nowTimestamp().after(this.testInstanceStatistics.getByTestInstanceId(testInstanceId).getNextRun()));
        Timestamp start = Clock.nowTimestamp();
        Timestamp deadline = new Timestamp(Clock.currentTimeMillis() + Task.CREATED_TASK_DEADLINE_MILLIS);
        List createdTasks = taskDao.searchAndCreate(Integer.valueOf(2), Integer.valueOf(testInstanceId), null, null, null, null, "automatically created task", start, deadline, Clock.nowTimestamp());
        MatcherAssert.assertThat((Object)createdTasks, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Task)createdTasks.get(0)).getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)testInstanceId)));
    }

    @Test
    public void testSearchAndCreate10bb() throws Exception {
        int testInstanceId = 9;
        timeProvider.setNowOffset(TestClock.get().getBase());
        timeProvider.relativeNowOffsetMinutes(7L);
        assert (Clock.nowTimestamp().after(((Task)this.taskTestCollection.getByIndex(0)).getStart()));
        assert (Clock.nowTimestamp().after(((Task)this.taskTestCollection.getByIndex(0)).getDeadline()));
        assert (this.testInstanceStatistics.getByTestInstanceId(testInstanceId) != null);
        assert (this.testInstanceStatistics.getByTestInstanceId(testInstanceId).getNextRun() != null);
        assert (!Clock.nowTimestamp().after(this.testInstanceStatistics.getByTestInstanceId(testInstanceId).getNextRun()));
        Timestamp start = Clock.nowTimestamp();
        Timestamp deadline = new Timestamp(Clock.currentTimeMillis() + Task.CREATED_TASK_DEADLINE_MILLIS);
        List createdTasks = taskDao.searchAndCreate(Integer.valueOf(2), Integer.valueOf(testInstanceId), null, null, null, null, "automatically created task", start, deadline, Clock.nowTimestamp());
        System.out.println("Tasks created: " + createdTasks);
        MatcherAssert.assertThat((Object)createdTasks, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testSearchAndCreate10c() throws Exception {
        int testInstanceId = 10;
        for (Task task : this.taskTestCollection.getAll()) {
            if (task.getTestInstanceId() != testInstanceId || task.getState() != Task.State.RUNNING && task.getState() != Task.State.CREATED) continue;
            taskDao.delete(task);
        }
        Timestamp start = Clock.nowTimestamp();
        Timestamp deadline = new Timestamp(Clock.currentTimeMillis() + Task.CREATED_TASK_DEADLINE_MILLIS);
        List createdTasks = taskDao.searchAndCreate(Integer.valueOf(2), Integer.valueOf(testInstanceId), "test", Arrays.asList("anyGetVersion"), null, null, "automatically created task", start, deadline, Clock.nowTimestamp());
        MatcherAssert.assertThat((Object)createdTasks, (Matcher)Matchers.hasSize((int)1));
        Task createdTask = (Task)createdTasks.get(0);
        MatcherAssert.assertThat((Object)createdTask.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)testInstanceId)));
        MatcherAssert.assertThat((Object)createdTask.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)createdTask.getRunInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"automatically created task")));
    }

    @Test
    public void testSearchAndCreate10and9() throws Exception {
        for (Task task : this.taskTestCollection.getAll()) {
            if (task.getTestInstanceId() != 9 && task.getTestInstanceId() != 10 || task.getState() != Task.State.RUNNING && task.getState() != Task.State.CREATED) continue;
            taskDao.delete(task);
        }
        Timestamp start = Clock.nowTimestamp();
        Timestamp deadline = new Timestamp(Clock.currentTimeMillis() + Task.CREATED_TASK_DEADLINE_MILLIS);
        List createdTasks = taskDao.searchAndCreate(Integer.valueOf(4), null, null, Arrays.asList("ping", "anyGetVersion"), null, null, "automatically created task", start, deadline, Clock.nowTimestamp());
        MatcherAssert.assertThat((Object)createdTasks, (Matcher)Matchers.hasSize((int)2));
        Task createdTask1 = (Task)createdTasks.get(0);
        Task createdTask2 = (Task)createdTasks.get(1);
        if (createdTask1.getTestInstanceId() == 9) {
            MatcherAssert.assertThat((Object)createdTask1.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)9)));
            MatcherAssert.assertThat((Object)createdTask2.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)10)));
        } else {
            MatcherAssert.assertThat((Object)createdTask1.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)10)));
            MatcherAssert.assertThat((Object)createdTask2.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)9)));
        }
        MatcherAssert.assertThat((Object)createdTask1.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)createdTask2.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)createdTask1.getRunInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"automatically created task")));
        MatcherAssert.assertThat((Object)createdTask2.getRunInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"automatically created task")));
    }

    @Test
    public void testCreateMultiple() throws Exception {
        int testInstanceId = 10;
        for (Task task : this.taskTestCollection.getAll()) {
            if (task.getTestInstanceId() != testInstanceId) continue;
            taskDao.delete(task);
        }
        Timestamp start = Clock.nowTimestamp();
        Timestamp deadline = new Timestamp(Clock.currentTimeMillis() + Task.CREATED_TASK_DEADLINE_MILLIS);
        List createdTasks = taskDao.createMultiple(3, testInstanceId, "automatically created task", start, deadline, Clock.nowTimestamp());
        MatcherAssert.assertThat((Object)createdTasks, (Matcher)Matchers.hasSize((int)3));
        ArrayList<Long> seenTaskIds = new ArrayList<Long>();
        for (Task createdTask : createdTasks) {
            System.out.println("Created task " + createdTask.getId() + " already seen: " + seenTaskIds);
            MatcherAssert.assertThat((Object)((Long)createdTask.getId()), (Matcher)Matchers.not((Matcher)Matchers.isIn(seenTaskIds)));
            MatcherAssert.assertThat((Object)createdTask.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)testInstanceId)));
            MatcherAssert.assertThat((Object)createdTask.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)createdTask.getRunInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"automatically created task")));
            seenTaskIds.add((Long)createdTask.getId());
        }
        List foundTasks = taskDao.findByTestInstanceId(Integer.valueOf(testInstanceId));
        MatcherAssert.assertThat((Object)foundTasks, (Matcher)Matchers.hasSize((int)3));
        for (Task foundTask : foundTasks) {
            System.out.println("Found task " + foundTask.getId() + " still to be found: " + seenTaskIds);
            MatcherAssert.assertThat((Object)((Long)foundTask.getId()), (Matcher)Matchers.isIn(seenTaskIds));
            MatcherAssert.assertThat((Object)foundTask.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)testInstanceId)));
            MatcherAssert.assertThat((Object)foundTask.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)foundTask.getRunInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"automatically created task")));
            seenTaskIds.remove(foundTask.getId());
        }
        MatcherAssert.assertThat(seenTaskIds, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testSearchAndCreate9WhileSelfTestFailed() throws Exception {
        int testInstanceId = 9;
        for (Task task : this.taskTestCollection.getAll()) {
            if (task.getTestInstanceId() != testInstanceId || task.getState() != Task.State.RUNNING && task.getState() != Task.State.CREATED) continue;
            taskDao.delete(task);
        }
        User origUser = userDao.findById("tester-a");
        UserBuilder selfTestFailedUser = new UserBuilder(origUser);
        selfTestFailedUser.setSelfTestFailed(Boolean.valueOf(true));
        userDao.update(selfTestFailedUser.create());
        Timestamp start = Clock.nowTimestamp();
        Timestamp deadline = new Timestamp(Clock.currentTimeMillis() + Task.CREATED_TASK_DEADLINE_MILLIS);
        List createdTasks = taskDao.searchAndCreate(Integer.valueOf(2), null, null, Arrays.asList("ping"), null, null, "automatically created task", start, deadline, Clock.nowTimestamp());
        MatcherAssert.assertThat((Object)createdTasks, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testSearchAndCreate10and9WhileSelfTestFailed() throws Exception {
        for (Task task : this.taskTestCollection.getAll()) {
            if (task.getTestInstanceId() != 9 && task.getTestInstanceId() != 10 || task.getState() != Task.State.RUNNING && task.getState() != Task.State.CREATED) continue;
            taskDao.delete(task);
        }
        User origUser = userDao.findById("tester-a");
        UserBuilder selfTestFailedUser = new UserBuilder(origUser);
        selfTestFailedUser.setSelfTestFailed(Boolean.valueOf(true));
        userDao.update(selfTestFailedUser.create());
        Timestamp start = Clock.nowTimestamp();
        Timestamp deadline = new Timestamp(Clock.currentTimeMillis() + Task.CREATED_TASK_DEADLINE_MILLIS);
        List createdTasks = taskDao.searchAndCreate(Integer.valueOf(4), null, null, Arrays.asList("ping", "anyGetVersion"), null, null, "automatically created task", start, deadline, Clock.nowTimestamp());
        MatcherAssert.assertThat((Object)createdTasks, (Matcher)Matchers.hasSize((int)1));
        Task createdTask = (Task)createdTasks.get(0);
        MatcherAssert.assertThat((Object)createdTask.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)10)));
        MatcherAssert.assertThat((Object)createdTask.getResultId(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)createdTask.getRunInfo(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"automatically created task")));
    }

    @Test
    public void testForceCancellingForUser() throws Exception {
        Task createdTaskForTI10;
        Task createdTaskForTI9;
        for (Task task : this.taskTestCollection.getAll()) {
            if (task.getTestInstanceId() != 9 && task.getTestInstanceId() != 10 || task.getState() != Task.State.RUNNING && task.getState() != Task.State.CREATED) continue;
            taskDao.delete(task);
        }
        Timestamp start = Clock.nowTimestamp();
        Timestamp deadline = new Timestamp(Clock.currentTimeMillis() + Task.CREATED_TASK_DEADLINE_MILLIS);
        List createdTasks = taskDao.searchAndCreate(Integer.valueOf(4), null, null, Arrays.asList("ping", "anyGetVersion"), null, null, "automatically created task", start, deadline, Clock.nowTimestamp());
        MatcherAssert.assertThat((Object)createdTasks, (Matcher)Matchers.hasSize((int)2));
        Task createdTask1 = (Task)createdTasks.get(0);
        Task createdTask2 = (Task)createdTasks.get(1);
        if (createdTask1.getTestInstanceId() == 9) {
            MatcherAssert.assertThat((Object)createdTask1.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)9)));
            MatcherAssert.assertThat((Object)createdTask2.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)10)));
            createdTaskForTI9 = createdTask1;
            createdTaskForTI10 = createdTask2;
        } else {
            MatcherAssert.assertThat((Object)createdTask1.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)10)));
            MatcherAssert.assertThat((Object)createdTask2.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)9)));
            createdTaskForTI9 = createdTask2;
            createdTaskForTI10 = createdTask1;
        }
        MatcherAssert.assertThat((Object)createdTaskForTI9.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)9)));
        MatcherAssert.assertThat((Object)createdTaskForTI9.getState(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Task.State.CREATED)));
        MatcherAssert.assertThat((Object)createdTaskForTI10.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)10)));
        MatcherAssert.assertThat((Object)createdTaskForTI10.getState(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Task.State.CREATED)));
        taskDao.forceCancellingStateForUser("tester-a", start);
        Task updated9 = taskDao.findById((Long)createdTaskForTI9.getId());
        Task updated10 = taskDao.findById((Long)createdTaskForTI10.getId());
        MatcherAssert.assertThat((Object)updated9.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)9)));
        MatcherAssert.assertThat((Object)updated9.getState(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Task.State.CANCELLING)));
        MatcherAssert.assertThat((Object)updated10.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)10)));
        MatcherAssert.assertThat((Object)updated10.getState(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Task.State.CREATED)));
    }

    static {
        lock = new ReentrantLock();
    }
}

