/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestInstanceDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FrequencyTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestDefinitionsTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.UserTestCollection;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class TestInstanceDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static TestInstanceDao testInstanceDao;
    private static Lock lock;
    private TestInstancesTestCollection testInstancesTestCollection;
    private TestDefinitionsTestCollection testDefinitionsTestCollection;
    private FrequencyTestCollection frequencyTestCollection;
    private TestbedTestCollection testbedTestCollection;
    private UserTestCollection userTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        testInstanceDao = (TestInstanceDao)jdbi.onDemand(TestInstanceDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)testInstanceDao);
        jdbi = null;
        testInstanceDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.testInstancesTestCollection = new TestInstancesTestCollection();
        this.testDefinitionsTestCollection = new TestDefinitionsTestCollection();
        this.frequencyTestCollection = new FrequencyTestCollection();
        this.testbedTestCollection = new TestbedTestCollection();
        this.userTestCollection = new UserTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testFindByName1() throws Exception {
        TestInstance expectedTestInstance = (TestInstance)this.testInstancesTestCollection.getByIndex(0);
        TestInstance actualTestInstance = testInstanceDao.findById(((Integer)expectedTestInstance.getId()).intValue());
        this.testInstancesTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTestInstance, (JsonLdObjectWithId)expectedTestInstance);
    }

    @Test
    public void testFindByName2() throws Exception {
        TestInstance expectedTestInstance = (TestInstance)this.testInstancesTestCollection.getByIndex(1);
        TestInstance actualTestInstance = testInstanceDao.findById(((Integer)expectedTestInstance.getId()).intValue());
        this.testInstancesTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTestInstance, (JsonLdObjectWithId)expectedTestInstance);
    }

    @Test
    public void testFindByName3() throws Exception {
        TestInstance expectedTestInstance = (TestInstance)this.testInstancesTestCollection.getByIndex(2);
        TestInstance actualTestInstance = testInstanceDao.findById(((Integer)expectedTestInstance.getId()).intValue());
        this.testInstancesTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTestInstance, (JsonLdObjectWithId)expectedTestInstance);
    }

    @Test
    public void testFindByName4() throws Exception {
        TestInstance expectedTestInstance = (TestInstance)this.testInstancesTestCollection.getByIndex(3);
        TestInstance actualTestInstance = testInstanceDao.findById(((Integer)expectedTestInstance.getId()).intValue());
        this.testInstancesTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTestInstance, (JsonLdObjectWithId)expectedTestInstance);
    }

    @Test
    public void testFindByName5() throws Exception {
        TestInstance expectedTestInstance = (TestInstance)this.testInstancesTestCollection.getByIndex(4);
        TestInstance actualTestInstance = testInstanceDao.findById(((Integer)expectedTestInstance.getId()).intValue());
        this.testInstancesTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTestInstance, (JsonLdObjectWithId)expectedTestInstance);
    }

    @Test
    public void testFindByName6() throws Exception {
        TestInstance expectedTestInstance = (TestInstance)this.testInstancesTestCollection.getByIndex(5);
        TestInstance actualTestInstance = testInstanceDao.findById(((Integer)expectedTestInstance.getId()).intValue());
        this.testInstancesTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTestInstance, (JsonLdObjectWithId)expectedTestInstance);
    }

    @Test
    public void testSearch1() throws Exception {
        List res = testInstanceDao.search(Arrays.asList("prod", "test"), null, null, null, null, null, null, null, false, null, null, null, null);
        System.out.println("testSearch res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)this.testInstancesTestCollection.getAllNormalBuilders().size()));
        for (TestInstance resTestInstance : res) {
            MatcherAssert.assertThat((Object)resTestInstance, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            TestInstance origTestInstance = (TestInstance)this.testInstancesTestCollection.getById((Integer)resTestInstance.getId());
            MatcherAssert.assertThat((Object)origTestInstance, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.testInstancesTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resTestInstance, (JsonLdObjectWithId)origTestInstance);
        }
    }

    @Test
    public void testInsert() {
        TestDefinition testDefinitionA = (TestDefinition)this.testDefinitionsTestCollection.getByIndex(0);
        Frequency testFrequencyA = (Frequency)this.frequencyTestCollection.getByIndex(0);
        Testbed testbedA = (Testbed)this.testbedTestCollection.getByIndex(0);
        User userA = (User)this.userTestCollection.getByIndex(0);
        TestInstance newTestInstance = new TestInstanceBuilder().setTestDefinition(testDefinitionA).setTestVersion("test").setEnabled(Boolean.valueOf(true)).setFrequency(testFrequencyA).setName("New For Test").setServerParameter((Server)testbedA.getServers().get(0)).setUserParameter(userA).addParameter("keyA", "valA").addParameter("keyB", "valB").create();
        Integer newId = testInstanceDao.insert(newTestInstance);
        MatcherAssert.assertThat((Object)newId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        TestInstanceBuilder expectedNewTestInstanceBuilder = new TestInstanceBuilder(newTestInstance);
        expectedNewTestInstanceBuilder.setId((Object)newId);
        ((FedmonWebApiServiceConfiguration)RULE.getConfiguration()).getJsonLdObjectsMetaData().makeUriTool("http://localhost:9000").setBuilderUri((PrimaryIdObjectBuilder)expectedNewTestInstanceBuilder, true);
        TestInstance expectedNewTestInstance = expectedNewTestInstanceBuilder.create();
        TestInstance actualNewTestInstance = testInstanceDao.findById(newId.intValue());
        System.out.println("Lookup inserted testInstance (" + newId + ") result: " + actualNewTestInstance);
        MatcherAssert.assertThat((Object)actualNewTestInstance, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)actualNewTestInstance.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)newId)));
        this.testInstancesTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)expectedNewTestInstance, (JsonLdObjectWithId)actualNewTestInstance, false);
    }

    @Test
    public void testUpdate() {
        Frequency frequency2 = (Frequency)this.frequencyTestCollection.getByIndex(1);
        TestDefinition getVersionTestDefinition = new TestDefinitionBuilder((TestDefinition)this.testDefinitionsTestCollection.getById("anyGetVersion")).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
        User failUser = (User)this.userTestCollection.getById("fail-b");
        assert (failUser != null);
        TestInstance origTestInstance = (TestInstance)this.testInstancesTestCollection.getByIndex(0);
        TestInstanceBuilder updatedTestInstanceBuilder = new TestInstanceBuilder(origTestInstance);
        updatedTestInstanceBuilder.setEnabled(Boolean.valueOf(origTestInstance.getEnabled() == false));
        updatedTestInstanceBuilder.setName(origTestInstance.getName() + "updated");
        updatedTestInstanceBuilder.setTestVersion(origTestInstance.getTestVersion() + "up");
        updatedTestInstanceBuilder.setFrequency(frequency2);
        updatedTestInstanceBuilder.setTestDefinition(getVersionTestDefinition);
        updatedTestInstanceBuilder.setServerParameter((Server)((Testbed)this.testbedTestCollection.getById("B")).getServers().get(0));
        updatedTestInstanceBuilder.setUserParameter(failUser);
        HashMap<String, String> parameters = new HashMap<String, String>(origTestInstance.getParametersExceptServerAndUser());
        parameters.remove("use_proxy");
        parameters.put("updateTest", "success");
        updatedTestInstanceBuilder.setParametersExceptServerAndUser(parameters);
        TestInstance expectedUpdatedTestInstance = updatedTestInstanceBuilder.create();
        assert (expectedUpdatedTestInstance.getTestDefinitionId().equals(getVersionTestDefinition.getId())) : "expectedUpdatedTestInstance.getTestDefinitionId()=" + expectedUpdatedTestInstance.getTestDefinitionId();
        assert (expectedUpdatedTestInstance.getUserIdParameter() != null);
        assert (expectedUpdatedTestInstance.getServerIdParameter() != null);
        testInstanceDao.update(expectedUpdatedTestInstance);
        TestInstance actualTestInstance = testInstanceDao.findById(((Integer)origTestInstance.getId()).intValue());
        try {
            this.testInstancesTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTestInstance, (JsonLdObjectWithId)expectedUpdatedTestInstance);
        }
        catch (AssertionError e) {
            MatcherAssert.assertThat((Object)("" + actualTestInstance), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)("" + expectedUpdatedTestInstance))));
            throw e;
        }
    }

    static {
        lock = new ReentrantLock();
    }
}

