/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestbedCategoryDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestbedDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategoryBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedCategoriesTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class TestbedCategoryDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static TestbedCategoryDao testbedCategoryDao;
    private static TestbedDao testbedDao;
    private static Lock lock;
    private TestbedCategoriesTestCollection testbedCategoriesTestCollection;
    private TestbedTestCollection testbedTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        testbedCategoryDao = (TestbedCategoryDao)jdbi.onDemand(TestbedCategoryDao.class);
        testbedDao = (TestbedDao)jdbi.onDemand(TestbedDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)testbedCategoryDao);
        jdbi.close((Object)testbedDao);
        jdbi = null;
        testbedCategoryDao = null;
        testbedDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.testbedCategoriesTestCollection = new TestbedCategoriesTestCollection();
        this.testbedTestCollection = new TestbedTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testFindById1() throws Exception {
        TestbedCategory expectedTestbedCategory = (TestbedCategory)this.testbedCategoriesTestCollection.getByIndex(0);
        TestbedCategory actualTestbedCategory = testbedCategoryDao.findById(((Integer)expectedTestbedCategory.getId()).intValue());
        this.testbedCategoriesTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTestbedCategory, (JsonLdObjectWithId)expectedTestbedCategory);
    }

    @Test
    public void testFindById2() throws Exception {
        TestbedCategory expectedTestbedCategory = (TestbedCategory)this.testbedCategoriesTestCollection.getByIndex(1);
        TestbedCategory actualTestbedCategory = testbedCategoryDao.findById(((Integer)expectedTestbedCategory.getId()).intValue());
        this.testbedCategoriesTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTestbedCategory, (JsonLdObjectWithId)expectedTestbedCategory);
    }

    @Test
    public void testFindById3() throws Exception {
        TestbedCategory expectedTestbedCategory = (TestbedCategory)this.testbedCategoriesTestCollection.getByIndex(2);
        TestbedCategory actualTestbedCategory = testbedCategoryDao.findById(((Integer)expectedTestbedCategory.getId()).intValue());
        this.testbedCategoriesTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)actualTestbedCategory, (JsonLdObjectWithId)expectedTestbedCategory);
    }

    @Test
    public void testFindByName0() throws Exception {
        TestbedCategory expectedTestbedCategory = (TestbedCategory)this.testbedCategoriesTestCollection.getByIndex(0);
        Integer actualTestbedCategoryId = testbedCategoryDao.findIdByName(expectedTestbedCategory.getName());
        MatcherAssert.assertThat((Object)actualTestbedCategoryId, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Integer)expectedTestbedCategory.getId()))));
    }

    @Test
    public void testFindByName1() throws Exception {
        TestbedCategory expectedTestbedCategory = (TestbedCategory)this.testbedCategoriesTestCollection.getByIndex(1);
        Integer actualTestbedCategoryId = testbedCategoryDao.findIdByName(expectedTestbedCategory.getName());
        MatcherAssert.assertThat((Object)actualTestbedCategoryId, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Integer)expectedTestbedCategory.getId()))));
    }

    @Test
    public void testFindByName2() throws Exception {
        TestbedCategory expectedTestbedCategory = (TestbedCategory)this.testbedCategoriesTestCollection.getByIndex(2);
        Integer actualTestbedCategoryId = testbedCategoryDao.findIdByName(expectedTestbedCategory.getName());
        MatcherAssert.assertThat((Object)actualTestbedCategoryId, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Integer)expectedTestbedCategory.getId()))));
    }

    @Test
    public void testFindAll() throws Exception {
        List res = testbedCategoryDao.findAll();
        System.out.println("testFindAll res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)this.testbedCategoriesTestCollection.getSize()));
        for (TestbedCategory resTestbedCategory : res) {
            MatcherAssert.assertThat((Object)resTestbedCategory, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            TestbedCategory origTestbedCategory = (TestbedCategory)this.testbedCategoriesTestCollection.getById((Integer)resTestbedCategory.getId());
            MatcherAssert.assertThat((Object)origTestbedCategory, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.testbedCategoriesTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resTestbedCategory, (JsonLdObjectWithId)origTestbedCategory);
        }
    }

    @Test
    public void testInsert() throws Exception {
        TestbedCategoryBuilder testbedCategoryBuilder = new TestbedCategoryBuilder().setName("NewCat1");
        TestbedCategory newTestbedCategory = testbedCategoryBuilder.create();
        Testbed testbedA = (Testbed)this.testbedTestCollection.getByIndex(0);
        testbedCategoryDao.addTestbedToCategory((String)testbedA.getId(), newTestbedCategory.getName(), true);
        TestbedCategory expectedTestbedCategory = testbedCategoryBuilder.create();
        Integer newCatId = testbedCategoryDao.findIdByName(newTestbedCategory.getName());
        TestbedCategory lookupRes = testbedCategoryDao.findById(newCatId.intValue());
        MatcherAssert.assertThat((Object)((Integer)lookupRes.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)lookupRes.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)newTestbedCategory.getName())));
        TestbedBuilder testbedAfterCatAddBuilder = testbedDao.findById(null, (String)testbedA.getId());
        Testbed testbedAfterCatAdd = testbedAfterCatAddBuilder == null ? null : testbedAfterCatAddBuilder.create();
        MatcherAssert.assertThat((Object)testbedAfterCatAdd, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)testbedAfterCatAdd.getCategories(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)testbedAfterCatAdd.getCategories(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        boolean foundInsertedCat = false;
        for (TestbedCategory testbedCategory : testbedAfterCatAdd.getCategories()) {
            MatcherAssert.assertThat((Object)((Integer)testbedCategory.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)testbedCategory.getName(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            if (!((Integer)testbedCategory.getId()).equals(newCatId)) continue;
            foundInsertedCat = true;
            MatcherAssert.assertThat((Object)testbedCategory.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)newTestbedCategory.getName())));
        }
        MatcherAssert.assertThat((String)("Did not find inserted category in testbed: " + testbedA), (Object)foundInsertedCat, (Matcher)Matchers.is((Object)true));
    }

    static {
        lock = new ReentrantLock();
    }
}

