/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TestbedDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.net.URI;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class TestbedDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static TestbedDao testbedDao;
    private static Lock lock;
    private TestbedTestCollection testbedTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        testbedDao = (TestbedDao)jdbi.onDemand(TestbedDao.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)testbedDao);
        jdbi = null;
        testbedDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        this.testbedTestCollection = new TestbedTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testFindByName1() throws Exception {
        Testbed expectedTestbed = (Testbed)this.testbedTestCollection.getByIndex(0);
        TestbedBuilder actualTestbed = testbedDao.findById(null, (String)expectedTestbed.getId());
        this.testbedTestCollection.assertSameButIgnoreUri(actualTestbed, expectedTestbed);
    }

    @Test
    public void testFindByName2() throws Exception {
        Testbed expectedTestbed = (Testbed)this.testbedTestCollection.getByIndex(1);
        TestbedBuilder actualTestbed = testbedDao.findById(null, (String)expectedTestbed.getId());
        this.testbedTestCollection.assertSameButIgnoreUri(actualTestbed, expectedTestbed);
    }

    @Test
    public void testFindByName3() throws Exception {
        Testbed expectedTestbed = (Testbed)this.testbedTestCollection.getByIndex(2);
        TestbedBuilder actualTestbed = testbedDao.findById(null, (String)expectedTestbed.getId());
        this.testbedTestCollection.assertSameButIgnoreUri(actualTestbed, expectedTestbed);
    }

    @Test
    public void testFindAll() throws Exception {
        List res = testbedDao.findAll(null);
        System.out.println("testFindAll res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)this.testbedTestCollection.getSize()));
        for (TestbedBuilder resTestbed : res) {
            MatcherAssert.assertThat((Object)resTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Testbed origTestbed = (Testbed)this.testbedTestCollection.getById((String)resTestbed.getId());
            MatcherAssert.assertThat((Object)origTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.testbedTestCollection.assertSameButIgnoreUri(resTestbed, origTestbed);
        }
    }

    @Test
    public void search0() throws Exception {
        List<String> categories = Arrays.asList(new String[0]);
        List<String> geniIds = Arrays.asList(new String[0]);
        List<String> ids = Arrays.asList(new String[0]);
        List<String> urns = Arrays.asList(new String[0]);
        List expected = this.testbedTestCollection.getAll();
        List res = testbedDao.search(null, categories, geniIds, ids, urns);
        System.out.println("search " + categories + "," + geniIds + " res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)expected.size()));
        for (TestbedBuilder actualTestbed : res) {
            MatcherAssert.assertThat((Object)actualTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Testbed origTestbed = (Testbed)this.testbedTestCollection.searchListById(expected, (String)actualTestbed.getId());
            MatcherAssert.assertThat((Object)origTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.testbedTestCollection.assertSameButIgnoreUri(actualTestbed, origTestbed);
        }
    }

    @Test
    public void search1() throws Exception {
        List<String> categories = Arrays.asList("oneAndTwo");
        List<String> geniIds = Arrays.asList(new String[0]);
        List<String> ids = Arrays.asList(new String[0]);
        List<String> urns = Arrays.asList(new String[0]);
        List expected = this.testbedTestCollection.getByIds(new String[]{"A", "B"});
        List res = testbedDao.search(null, categories, geniIds, ids, urns);
        System.out.println("search " + categories + "," + geniIds + " res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)expected.size()));
        for (TestbedBuilder actualTestbed : res) {
            MatcherAssert.assertThat((Object)actualTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Testbed origTestbed = (Testbed)this.testbedTestCollection.searchListById(expected, (String)actualTestbed.getId());
            MatcherAssert.assertThat((Object)origTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.testbedTestCollection.assertSameButIgnoreUri(actualTestbed, origTestbed);
        }
    }

    @Test
    public void search2() throws Exception {
        List<String> categories = Arrays.asList("oneAndTwo", "one");
        List<String> geniIds = Arrays.asList(new String[0]);
        List<String> ids = Arrays.asList(new String[0]);
        List<String> urns = Arrays.asList(new String[0]);
        List expected = this.testbedTestCollection.getByIds(new String[]{"A", "B"});
        List res = testbedDao.search(null, categories, geniIds, ids, urns);
        System.out.println("search " + categories + "," + geniIds + " res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)expected.size()));
        for (TestbedBuilder actualTestbed : res) {
            MatcherAssert.assertThat((Object)actualTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Testbed origTestbed = (Testbed)this.testbedTestCollection.searchListById(expected, (String)actualTestbed.getId());
            MatcherAssert.assertThat((Object)origTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.testbedTestCollection.assertSameButIgnoreUri(actualTestbed, origTestbed);
        }
    }

    @Test
    public void search3() throws Exception {
        List<String> categories = Arrays.asList(new String[0]);
        List<String> geniIds = Arrays.asList("ex-b");
        List<String> ids = Arrays.asList(new String[0]);
        List<String> urns = Arrays.asList(new String[0]);
        List expected = this.testbedTestCollection.getByIds(new String[]{"B"});
        List res = testbedDao.search(null, categories, geniIds, ids, urns);
        System.out.println("search " + categories + "," + geniIds + " res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)expected.size()));
        for (TestbedBuilder actualTestbed : res) {
            MatcherAssert.assertThat((Object)actualTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Testbed origTestbed = (Testbed)this.testbedTestCollection.searchListById(expected, (String)actualTestbed.getId());
            MatcherAssert.assertThat((Object)origTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.testbedTestCollection.assertSameButIgnoreUri(actualTestbed, origTestbed);
        }
    }

    @Test
    public void search4() throws Exception {
        List<String> categories = Arrays.asList(new String[0]);
        List<String> geniIds = Arrays.asList("ex-b", "ex-a");
        List<String> ids = Arrays.asList(new String[0]);
        List<String> urns = Arrays.asList(new String[0]);
        List expected = this.testbedTestCollection.getByIds(new String[]{"A", "B"});
        List res = testbedDao.search(null, categories, geniIds, ids, urns);
        System.out.println("search " + categories + "," + geniIds + " res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)expected.size()));
        for (TestbedBuilder actualTestbed : res) {
            MatcherAssert.assertThat((Object)actualTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Testbed origTestbed = (Testbed)this.testbedTestCollection.searchListById(expected, (String)actualTestbed.getId());
            MatcherAssert.assertThat((Object)origTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.testbedTestCollection.assertSameButIgnoreUri(actualTestbed, origTestbed);
        }
    }

    @Test
    public void search5() throws Exception {
        List<String> categories = Arrays.asList("one");
        List<String> geniIds = Arrays.asList("ex-b");
        List<String> ids = Arrays.asList(new String[0]);
        List<String> urns = Arrays.asList(new String[0]);
        List expected = this.testbedTestCollection.getByIds(new String[0]);
        List res = testbedDao.search(null, categories, geniIds, ids, urns);
        System.out.println("search " + categories + "," + geniIds + " res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)expected.size()));
        for (TestbedBuilder actualTestbed : res) {
            MatcherAssert.assertThat((Object)actualTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Testbed origTestbed = (Testbed)this.testbedTestCollection.searchListById(expected, (String)actualTestbed.getId());
            MatcherAssert.assertThat((Object)origTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.testbedTestCollection.assertSameButIgnoreUri(actualTestbed, origTestbed);
        }
    }

    @Test
    public void search6() throws Exception {
        List<String> categories = Arrays.asList("oneAndTwo", "one");
        List<String> geniIds = Arrays.asList("ex-b", "ex-a");
        List<String> ids = Arrays.asList(new String[0]);
        List<String> urns = Arrays.asList(new String[0]);
        List expected = this.testbedTestCollection.getByIds(new String[]{"A", "B"});
        List res = testbedDao.search(null, categories, geniIds, ids, urns);
        System.out.println("search " + categories + "," + geniIds + " res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)expected.size()));
        for (TestbedBuilder actualTestbed : res) {
            MatcherAssert.assertThat((Object)actualTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Testbed origTestbed = (Testbed)this.testbedTestCollection.searchListById(expected, (String)actualTestbed.getId());
            MatcherAssert.assertThat((Object)origTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.testbedTestCollection.assertSameButIgnoreUri(actualTestbed, origTestbed);
        }
    }

    @Test
    public void testUpdate() throws Exception {
        TestbedBuilder testbedBuilder = ((TestbedBuilder)new TestbedBuilder().setId((Object)"A")).setLongName("Fake Testbed 1: A-changed").setInterfaceUrl("http://www.example.com/a-changed").setPingHost("www.a.example.com-changed").setInfoUrl("http://www.example.com/doc-changed/").setHelpUrl("http://www.example.com/help-changed.html").setDefaultComponentManagerUrn("urn:publicid:IDN+a-changed.example.com+authority+cm").setOtrsName("OTRS A-changed").setDescription("Description of A-changed").setGeniId("ex-a-changed").setGeniHref(new URI("https://example.com/info/aggregate/ex-a-changed")).setColor("red-changed").setAllowLinks(Boolean.valueOf(false)).setNodesLocationVisualisationCoordinatesUrl("yy-changed").setNodesLocationVisualisationImageUrl("xx-changed");
        testbedBuilder.setCategories(null);
        Testbed updatedTestbed = testbedBuilder.create();
        testbedDao.update(updatedTestbed);
        testbedBuilder.setCategories((Collection)((Testbed)this.testbedTestCollection.getById("A")).getCategories());
        testbedBuilder.setServers(((Testbed)this.testbedTestCollection.getById("A")).getServers());
        testbedBuilder.setProxies(((Testbed)this.testbedTestCollection.getById("A")).getProxies());
        testbedBuilder.setDefaultServer(((Testbed)this.testbedTestCollection.getById("A")).getDefaultServer());
        testbedBuilder.setFederations(((Testbed)this.testbedTestCollection.getById("A")).getFederations());
        Testbed expectedTestbed = testbedBuilder.create();
        TestbedBuilder lookupRes = testbedDao.findById(null, (String)updatedTestbed.getId());
        this.testbedTestCollection.assertSameButIgnoreUri(lookupRes, expectedTestbed);
    }

    @Test
    public void testInsert() throws Exception {
        TestbedBuilder testbedBuilder = ((TestbedBuilder)new TestbedBuilder().setId((Object)"Abis")).setLongName("Fake Testbed 1: A-changed").setInterfaceUrl("http://www.example.com/a-changed").setPingHost("www.a.example.com-changed").setInfoUrl("http://www.example.com/doc-changed/").setHelpUrl("http://www.example.com/help-changed.html").setDefaultComponentManagerUrn("urn:publicid:IDN+a-changed.example.com+authority+cm").setOtrsName("OTRS A-changed").setDescription("Description of A-changed").setGeniId("ex-a-changed").setGeniHref(new URI("https://example.com/info/aggregate/ex-a-changed")).setColor("red-changed").setAllowLinks(Boolean.valueOf(false)).setNodesLocationVisualisationCoordinatesUrl("yy-changed").setNodesLocationVisualisationImageUrl("xx-changed");
        testbedBuilder.setCategories(null);
        Testbed updatedTestbed = testbedBuilder.create();
        testbedDao.insert(updatedTestbed);
        testbedBuilder.setCategories(Collections.emptyList());
        testbedBuilder.setServers(null);
        testbedBuilder.setProxies(null);
        testbedBuilder.setFederations(Collections.emptyList());
        Testbed expectedTestbed = testbedBuilder.create();
        TestbedBuilder lookupRes = testbedDao.findById(null, (String)updatedTestbed.getId());
        this.testbedTestCollection.assertSameButIgnoreUri(lookupRes, expectedTestbed);
    }

    @Test
    public void testInsert2() throws Exception {
        TestbedBuilder testbedBuilder = ((TestbedBuilder)new TestbedBuilder().setId((Object)"testInsert2")).setLongName("2nd test created").setFederations(Collections.emptyList());
        testbedBuilder.setCategories(null);
        Testbed updatedTestbed = testbedBuilder.create();
        testbedDao.insert(updatedTestbed);
        testbedBuilder.setCategories(Collections.emptyList());
        testbedBuilder.setServers(null);
        testbedBuilder.setProxies(null);
        testbedBuilder.setAllowLinks(Boolean.valueOf(false));
        testbedBuilder.setFederations(Collections.emptyList());
        Testbed expectedTestbed = testbedBuilder.create();
        TestbedBuilder lookupRes = testbedDao.findById(null, (String)updatedTestbed.getId());
        this.testbedTestCollection.assertSameButIgnoreUri(lookupRes, expectedTestbed);
    }

    static {
        lock = new ReentrantLock();
    }
}

