/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.UserConfigSetMappingDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserConfigSetMapping;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.UserConfigSetMappingBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.GuiConfigSetTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.UserConfigSetMappingTestCollection;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;

public class UserConfigSetMappingDaoTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static FedmonTestPostgresDB testPostgresDB;
    private static DBI jdbi;
    private static UserConfigSetMappingDao userConfigSetMappingDao;
    private static Lock lock;
    private GuiConfigSetTestCollection guiConfigSetTestCollection;
    private UserConfigSetMappingTestCollection userConfigSetMappingTestCollection;

    @BeforeClass
    public static void setUp() throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.dropAllTables();
        testPostgresDB.createAllTables();
        FedmonWebApiServiceConfiguration configuration = (FedmonWebApiServiceConfiguration)RULE.getConfiguration();
        Environment environment = RULE.getEnvironment();
        DBIFactory factory = new DBIFactory();
        jdbi = factory.build(environment, (PooledDataSourceFactory)configuration.getDataSourceFactory(), "postgresql");
        userConfigSetMappingDao = (UserConfigSetMappingDao)jdbi.onDemand(UserConfigSetMappingDao.class);
        assert (userConfigSetMappingDao != null);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        jdbi.close((Object)userConfigSetMappingDao);
        jdbi = null;
        userConfigSetMappingDao = null;
        testPostgresDB = null;
        System.gc();
        Clock.reset();
    }

    @Before
    public void beforeEachMethod() throws SQLException {
        lock.lock();
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        assert (userConfigSetMappingDao != null);
        this.guiConfigSetTestCollection = new GuiConfigSetTestCollection();
        this.userConfigSetMappingTestCollection = new UserConfigSetMappingTestCollection();
    }

    @After
    public void afterEachMethod() throws SQLException {
        lock.unlock();
    }

    @Test
    public void testGetGuiConfigSetIdFromUserUrn0() {
        Collection actual = userConfigSetMappingDao.getGuiConfigSetIdFromUserUrn("example.com", "anyuser");
        List<String> expected = Arrays.asList("testA");
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.equalTo(expected)));
    }

    @Test
    public void testGetGuiConfigSetIdFromUserUrn1() {
        Collection actual = userConfigSetMappingDao.getGuiConfigSetIdFromUserUrn("2.example.com", "anyotheruser");
        List<String> expected = Arrays.asList("testB");
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.equalTo(expected)));
    }

    @Test
    public void testGetGuiConfigSetIdFromUserUrn2success() {
        Collection actual = userConfigSetMappingDao.getGuiConfigSetIdFromUserUrn("3.example.com", "user0aok");
        List<String> expected = Arrays.asList("testC");
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.equalTo(expected)));
    }

    @Test
    public void testGetGuiConfigSetIdFromUserUrn2fail() {
        Collection actual = userConfigSetMappingDao.getGuiConfigSetIdFromUserUrn("3.example.com", "user8blaok");
        List expected = Collections.emptyList();
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.equalTo(expected)));
    }

    @Nullable
    public UserConfigSetMapping findInTestCollection(UserConfigSetMapping m) {
        for (UserConfigSetMapping cur : this.userConfigSetMappingTestCollection.getAll()) {
            if (!cur.equals((Object)m)) continue;
            return cur;
        }
        return null;
    }

    @Test
    public void testFindAll() throws Exception {
        List res = userConfigSetMappingDao.findAll();
        System.out.println("testFindAll res = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)this.userConfigSetMappingTestCollection.getSize()));
        for (UserConfigSetMapping resUserConfigSetMapping : res) {
            MatcherAssert.assertThat((Object)resUserConfigSetMapping, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            UserConfigSetMapping origUserConfigSetMapping = this.findInTestCollection(resUserConfigSetMapping);
            MatcherAssert.assertThat((Object)origUserConfigSetMapping, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.userConfigSetMappingTestCollection.assertSameDetails(resUserConfigSetMapping, origUserConfigSetMapping);
        }
    }

    @Test
    public void testInsert1() throws Exception {
        UserConfigSetMapping newUserConfigSetMapping = new UserConfigSetMappingBuilder().setConfigSetId("testB").setUserUrnTla("some_new_tla").setUsernameRegex("noregex").create();
        userConfigSetMappingDao.insert(newUserConfigSetMapping);
        List res = userConfigSetMappingDao.findAll();
        System.out.println("testInsert findAll after insert = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)(this.userConfigSetMappingTestCollection.getSize() + 1)));
        for (UserConfigSetMapping resUserConfigSetMapping : res) {
            MatcherAssert.assertThat((Object)resUserConfigSetMapping, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            UserConfigSetMapping origUserConfigSetMapping = this.findInTestCollection(resUserConfigSetMapping);
            if (origUserConfigSetMapping == null) {
                origUserConfigSetMapping = newUserConfigSetMapping;
                newUserConfigSetMapping = null;
            }
            MatcherAssert.assertThat((Object)origUserConfigSetMapping, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.userConfigSetMappingTestCollection.assertSameDetails(resUserConfigSetMapping, origUserConfigSetMapping);
        }
    }

    @Test
    public void testInsert2() throws Exception {
        UserConfigSetMapping baseUserConfigSetMapping = (UserConfigSetMapping)this.userConfigSetMappingTestCollection.getByIndex(1);
        UserConfigSetMapping newUserConfigSetMapping = new UserConfigSetMappingBuilder().setConfigSetId(baseUserConfigSetMapping.getConfigSetId()).setUserUrnTla(baseUserConfigSetMapping.getUserUrnTla()).setUsernameRegex("anotherregex").create();
        userConfigSetMappingDao.insert(newUserConfigSetMapping);
        List res = userConfigSetMappingDao.findAll();
        System.out.println("testInsert findAll after insert = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)(this.userConfigSetMappingTestCollection.getSize() + 1)));
        for (UserConfigSetMapping resUserConfigSetMapping : res) {
            MatcherAssert.assertThat((Object)resUserConfigSetMapping, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            UserConfigSetMapping origUserConfigSetMapping = this.findInTestCollection(resUserConfigSetMapping);
            if (origUserConfigSetMapping == null) {
                origUserConfigSetMapping = newUserConfigSetMapping;
                newUserConfigSetMapping = null;
            }
            MatcherAssert.assertThat((Object)origUserConfigSetMapping, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.userConfigSetMappingTestCollection.assertSameDetails(resUserConfigSetMapping, origUserConfigSetMapping);
        }
    }

    @Test
    public void testDelete() throws Exception {
        UserConfigSetMapping deletedUserConfigSetMapping = (UserConfigSetMapping)this.userConfigSetMappingTestCollection.getByIndex(1);
        System.out.println("testDelete findAll before delete = " + userConfigSetMappingDao.findAll());
        System.out.println("testDelete to delete = " + deletedUserConfigSetMapping);
        int nrDeleted = userConfigSetMappingDao.delete(deletedUserConfigSetMapping);
        MatcherAssert.assertThat((Object)nrDeleted, (Matcher)Matchers.is((Object)1));
        List res = userConfigSetMappingDao.findAll();
        System.out.println("testDelete findAll after delete = " + res);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.hasSize((int)(this.userConfigSetMappingTestCollection.getSize() - 1)));
        for (UserConfigSetMapping resUserConfigSetMapping : res) {
            MatcherAssert.assertThat((Object)resUserConfigSetMapping, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            UserConfigSetMapping origUserConfigSetMapping = this.findInTestCollection(resUserConfigSetMapping);
            MatcherAssert.assertThat((Object)origUserConfigSetMapping, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)resUserConfigSetMapping, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)deletedUserConfigSetMapping))));
            this.userConfigSetMappingTestCollection.assertSameDetails(resUserConfigSetMapping, origUserConfigSetMapping);
        }
    }

    static {
        lock = new ReentrantLock();
    }
}

