/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json_test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import java.net.URI;
import java.net.URISyntaxException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.Test;

public class FedmonApiCommonTest {
    private static JsonLdObjectsMetaData jsonLdObjectsMetaData;

    @BeforeClass
    public static void beforeClass() {
        jsonLdObjectsMetaData = JsonLdObjectsMetaData.getInstance((String)Testbed.class.getPackage().getName());
    }

    @Test
    public void testGetObjectClassFromUri0() throws URISyntaxException {
        URI uri = new URI("https://127.0.0.1/testinstance/id");
        Class res = jsonLdObjectsMetaData.getObjectClassFromUri(uri);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is((Matcher)Matchers.equalTo(TestInstance.class)));
    }

    @Test
    public void testGetObjectClassFromUri1() throws URISyntaxException {
        URI uri = new URI("https://127.0.0.1/testinstance/");
        Class res = jsonLdObjectsMetaData.getObjectClassFromUri(uri);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is((Matcher)Matchers.equalTo(TestInstance.class)));
    }

    @Test
    public void testGetObjectClassFromUri2() throws URISyntaxException {
        URI uri = new URI("https://127.0.0.1/testinstance");
        Class res = jsonLdObjectsMetaData.getObjectClassFromUri(uri);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is((Matcher)Matchers.equalTo(TestInstance.class)));
    }

    @Test
    public void testGetObjectClassFromUri3() throws URISyntaxException {
        URI uri = new URI("https://127.0.0.1/blabla/testinstance/id");
        Class res = jsonLdObjectsMetaData.getObjectClassFromUri(uri);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is((Matcher)Matchers.equalTo(TestInstance.class)));
    }

    @Test
    public void testGetObjectClassFromUri4() throws URISyntaxException {
        URI uri = new URI("https://127.0.0.1/blabla/testinstance/");
        Class res = jsonLdObjectsMetaData.getObjectClassFromUri(uri);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is((Matcher)Matchers.equalTo(TestInstance.class)));
    }

    @Test
    public void testGetObjectClassFromUri5() throws URISyntaxException {
        URI uri = new URI("https://127.0.0.1/blabla/testinstance");
        Class res = jsonLdObjectsMetaData.getObjectClassFromUri(uri);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is((Matcher)Matchers.equalTo(TestInstance.class)));
    }

    @Test
    public void testGetObjectClassFromUri6() throws URISyntaxException {
        URI uri = new URI("https://127.0.0.1/blabla/blibli/testinstance/id");
        Class res = jsonLdObjectsMetaData.getObjectClassFromUri(uri);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is((Matcher)Matchers.equalTo(TestInstance.class)));
    }

    @Test
    public void testGetObjectClassFromUri7() throws URISyntaxException {
        URI uri = new URI("https://127.0.0.1/testinstance/5");
        Class res = jsonLdObjectsMetaData.getObjectClassFromUri(uri);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is((Matcher)Matchers.equalTo(TestInstance.class)));
    }

    @Test
    public void testGetObjectClassFromUri8() throws URISyntaxException {
        URI uri = new URI("https://127.0.0.1/bla/testinstance/result");
        Class res = jsonLdObjectsMetaData.getObjectClassFromUri(uri);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is((Matcher)Matchers.equalTo(TestInstance.class)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetObjectClassFromUri9() throws URISyntaxException {
        URI uri = new URI("https://127.0.0.1/bla/unknown/id");
        Class res = jsonLdObjectsMetaData.getObjectClassFromUri(uri);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is((Matcher)Matchers.equalTo(TestInstance.class)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetObjectClassFromUri10() throws URISyntaxException {
        URI uri = new URI("https://127.0.0.1/");
        Class res = jsonLdObjectsMetaData.getObjectClassFromUri(uri);
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is((Matcher)Matchers.equalTo(TestInstance.class)));
    }
}

