/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json_test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.LinkedTestbedDataTestCollection;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonEmbeddedParentsAndChildrenTest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonEmbeddedParentsAndChildrenTest.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    @Test
    public void testServerA() throws URISyntaxException {
        LinkedTestbedDataTestCollection col = new LinkedTestbedDataTestCollection(true, 0, "http://localhost:9000");
        Server serverA = col.getServerByIndex(0);
        assert (serverA.getServices() != null);
        assert (serverA.getId() != null);
        assert (serverA.getUri() != null);
        assert (serverA.getServices().size() > 0);
        assert (((Service)serverA.getServices().get(0)).getApi() != null);
        assert (((Service)serverA.getServices().get(0)).getId() != null);
        assert (((Service)serverA.getServices().get(0)).getUri() != null);
        assert (serverA.getTestbed() != null);
        assert (serverA.getTestbed().getLongName() != null);
        assert (serverA.getTestbed().getId() != null);
        assert (serverA.getTestbed().getUri() != null);
        Server minimizedServer = new ServerBuilder(serverA).create();
        MatcherAssert.assertThat((Object)minimizedServer.getServices(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedServer.getServices(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        Service minimizedService0 = (Service)minimizedServer.getServices().get(0);
        MatcherAssert.assertThat((Object)minimizedService0.getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((Integer)minimizedService0.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedService0.getServer(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedService0.getApi(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)minimizedServer.getTestbed().getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed().getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed().getServers(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testServerB() throws URISyntaxException, IOException {
        LinkedTestbedDataTestCollection col = new LinkedTestbedDataTestCollection(true, 0, "http://localhost:9000");
        Server serverA = col.getServerByIndex(0);
        assert (serverA.getServices() != null);
        assert (serverA.getId() != null);
        assert (serverA.getUri() != null);
        assert (serverA.getServices().size() > 0);
        assert (((Service)serverA.getServices().get(0)).getApi() != null);
        assert (((Service)serverA.getServices().get(0)).getId() != null);
        assert (((Service)serverA.getServices().get(0)).getUri() != null);
        assert (serverA.getTestbed() != null);
        assert (serverA.getTestbed().getLongName() != null);
        assert (serverA.getTestbed().getId() != null);
        assert (serverA.getTestbed().getUri() != null);
        assert (JsonLdObjectsMetaData.Minimization.ID_ONLY.serializeAsEmbeddedObject());
        assert (!JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY.serializeAsEmbeddedObject());
        assert (JsonLdObjectsMetaData.Minimization.ID_AND_LINKS.serializeAsEmbeddedObject());
        assert (JsonLdObjectsMetaData.Minimization.FULL_WITH_LINK_IDS.serializeAsEmbeddedObject());
        assert (JsonLdObjectsMetaData.Minimization.FULL_WITH_LINK_IDS.getChildrenMinimization().serializeAsEmbeddedObject());
        assert (JsonLdObjectsMetaData.Minimization.FULL_WITH_LINK_IDS.getParentMinimization().serializeAsEmbeddedObject());
        assert (JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS.serializeAsEmbeddedObject());
        assert (!JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS.getChildrenMinimization().serializeAsEmbeddedObject());
        assert (!JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS.getParentMinimization().serializeAsEmbeddedObject());
        Server minimizedServer = new ServerBuilder(serverA).createMinimized(JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS);
        MatcherAssert.assertThat((Object)minimizedServer.getServices(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Service)minimizedServer.getScs().get(0)).getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((Service)minimizedServer.getUserAuth().get(0)).getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimizedServer.getDefaultAMService().getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimizedServer.getDefaultUserAuth().getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimizedServer.getDefaultScs().getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimizedServer.getServices(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        Service minimizedService0 = (Service)minimizedServer.getServices().get(0);
        MatcherAssert.assertThat((Object)minimizedService0.getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((Integer)minimizedService0.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedService0.getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedService0.getServer(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)minimizedService0.getApi(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)minimizedServer.getTestbed().getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed().getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed().getLongName(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed().getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed().getServers(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        String json = MAPPER.writer().with(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)minimizedServer);
        LOG.debug("Generated JSON: " + json);
        Map map = (Map)MAPPER.readValue(json, Map.class);
        LOG.debug("map.get(\"services\"): " + map.get("services"));
        LOG.debug("map.get(\"services\").get(0): " + ((List)map.get("services")).get(0));
        LOG.debug("serverA.getServices().get(0).getUri(): " + ((Service)serverA.getServices().get(0)).getUri().toASCIIString());
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"services"));
        MatcherAssert.assertThat(map.get("services"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(List.class)));
        MatcherAssert.assertThat(map.get("defaultScs"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat(map.get("defaultUserAuth"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat(map.get("defaultAMService"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat(((List)map.get("scs")).get(0), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat(((List)map.get("userAuth")).get(0), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat((Object)((List)map.get("services")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat(((List)map.get("services")).get(0), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat((Object)((String)((List)map.get("services")).get(0)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Service)serverA.getServices().get(0)).getUri().toASCIIString())));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"testbed"));
        MatcherAssert.assertThat(map.get("testbed"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat(map.get("testbed"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)serverA.getTestbed().getUri().toASCIIString())));
    }

    @Test
    public void testServerC() throws URISyntaxException, IOException {
        LinkedTestbedDataTestCollection col = new LinkedTestbedDataTestCollection(true, 0, "http://localhost:9000");
        Server serverA = col.getServerByIndex(0);
        assert (serverA.getServices() != null);
        assert (serverA.getId() != null);
        assert (serverA.getUri() != null);
        assert (serverA.getServices().size() > 0);
        assert (((Service)serverA.getServices().get(0)).getApi() != null);
        assert (((Service)serverA.getServices().get(0)).getId() != null);
        assert (((Service)serverA.getServices().get(0)).getUri() != null);
        assert (serverA.getTestbed() != null);
        assert (serverA.getTestbed().getLongName() != null);
        assert (serverA.getTestbed().getId() != null);
        assert (serverA.getTestbed().getUri() != null);
        Server minimizedServer = new ServerBuilder(serverA).createMinimized(JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN_NOBACKLINK);
        MatcherAssert.assertThat((Object)minimizedServer.getServices(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Service)minimizedServer.getScs().get(0)).getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((Service)minimizedServer.getUserAuth().get(0)).getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimizedServer.getDefaultAMService().getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimizedServer.getDefaultUserAuth().getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimizedServer.getDefaultScs().getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimizedServer.getServices(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        Service minimizedService0 = (Service)minimizedServer.getServices().get(0);
        MatcherAssert.assertThat((Object)minimizedService0.getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((Integer)minimizedService0.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedService0.getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedService0.getServer(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)minimizedService0.getApi(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)minimizedServer.getTestbed().getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed().getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed().getLongName(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed().getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed().getServers(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        String json = MAPPER.writer().with(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)minimizedServer);
        LOG.debug("Generated JSON: " + json);
        Map map = (Map)MAPPER.readValue(json, Map.class);
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"services"));
        MatcherAssert.assertThat(map.get("services"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(List.class)));
        MatcherAssert.assertThat(map.get("defaultScs"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat(map.get("defaultUserAuth"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat(map.get("defaultAMService"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat(((List)map.get("scs")).get(0), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat(((List)map.get("userAuth")).get(0), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat((Object)((List)map.get("services")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat(((List)map.get("services")).get(0), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Map.class)));
        MatcherAssert.assertThat((Object)((Map)((List)map.get("services")).get(0)), (Matcher)Matchers.hasKey((Object)"@id"));
        MatcherAssert.assertThat((Object)((Map)((List)map.get("services")).get(0)), (Matcher)Matchers.hasKey((Object)"id"));
        MatcherAssert.assertThat((Object)((Map)((List)map.get("services")).get(0)), (Matcher)Matchers.hasKey((Object)"@type"));
        MatcherAssert.assertThat((Object)((Map)((List)map.get("services")).get(0)), (Matcher)Matchers.hasKey((Object)"api"));
        MatcherAssert.assertThat((Object)((Map)((List)map.get("services")).get(0)), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"server")));
        MatcherAssert.assertThat((Object)((String)((Map)((List)map.get("services")).get(0)).get("@id")), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Service)serverA.getServices().get(0)).getUri().toASCIIString())));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"testbed"));
        MatcherAssert.assertThat(map.get("testbed"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Map.class)));
        MatcherAssert.assertThat((Object)((Map)map.get("testbed")), (Matcher)Matchers.hasKey((Object)"@id"));
        MatcherAssert.assertThat((Object)((Map)map.get("testbed")), (Matcher)Matchers.hasKey((Object)"@type"));
        MatcherAssert.assertThat((Object)((Map)map.get("testbed")), (Matcher)Matchers.hasKey((Object)"id"));
        MatcherAssert.assertThat((Object)((Map)map.get("testbed")), (Matcher)Matchers.hasKey((Object)"longName"));
        MatcherAssert.assertThat((Object)((Map)map.get("testbed")), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"servers")));
        MatcherAssert.assertThat((Object)((String)((Map)map.get("testbed")).get("@id")), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)serverA.getTestbed().getUri().toASCIIString())));
    }

    @Test
    public void testServerD() throws URISyntaxException, IOException {
        LinkedTestbedDataTestCollection col = new LinkedTestbedDataTestCollection(true, 0, "http://localhost:9000");
        Server serverA = col.getServerByIndex(0);
        assert (serverA.getServices() != null);
        assert (serverA.getId() != null);
        assert (serverA.getUri() != null);
        assert (serverA.getServices().size() > 0);
        assert (((Service)serverA.getServices().get(0)).getApi() != null);
        assert (((Service)serverA.getServices().get(0)).getId() != null);
        assert (((Service)serverA.getServices().get(0)).getUri() != null);
        assert (serverA.getTestbed() != null);
        assert (serverA.getTestbed().getLongName() != null);
        assert (serverA.getTestbed().getId() != null);
        assert (serverA.getTestbed().getUri() != null);
        assert (JsonLdObjectsMetaData.Minimization.ID_ONLY.serializeAsEmbeddedObject());
        assert (!JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY.serializeAsEmbeddedObject());
        assert (JsonLdObjectsMetaData.Minimization.ID_AND_LINKS.serializeAsEmbeddedObject());
        assert (JsonLdObjectsMetaData.Minimization.FULL_EMBED_CHILDREN_LINK_PARENT.serializeAsEmbeddedObject());
        assert (JsonLdObjectsMetaData.Minimization.FULL_EMBED_CHILDREN_LINK_PARENT.getChildrenMinimization().serializeAsEmbeddedObject());
        assert (!JsonLdObjectsMetaData.Minimization.FULL_EMBED_CHILDREN_LINK_PARENT.getParentMinimization().serializeAsEmbeddedObject());
        assert (JsonLdObjectsMetaData.Minimization.FULL_EMBED_CHILDREN_LINK_PARENT.getChildrenMinimization().includeOtherProperties());
        assert (!JsonLdObjectsMetaData.Minimization.FULL_EMBED_CHILDREN_LINK_PARENT.getParentMinimization().includeOtherProperties());
        assert (JsonLdObjectsMetaData.Minimization.FULL_EMBED_ONLY_CHILDREN.serializeAsEmbeddedObject());
        assert (JsonLdObjectsMetaData.Minimization.FULL_EMBED_ONLY_CHILDREN.getChildrenMinimization().serializeAsEmbeddedObject());
        assert (JsonLdObjectsMetaData.Minimization.FULL_EMBED_ONLY_CHILDREN.getParentMinimization() == null);
        assert (JsonLdObjectsMetaData.Minimization.FULL_EMBED_ONLY_CHILDREN.getChildrenMinimization().includeOtherProperties());
        Server minimizedServer = new ServerBuilder(serverA).createMinimized(JsonLdObjectsMetaData.Minimization.FULL_EMBED_CHILDREN_LINK_PARENT);
        MatcherAssert.assertThat((Object)minimizedServer.getServices(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Service)minimizedServer.getScs().get(0)).getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((Service)minimizedServer.getUserAuth().get(0)).getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimizedServer.getDefaultAMService().getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimizedServer.getDefaultUserAuth().getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimizedServer.getDefaultScs().getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimizedServer.getServices(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        Service minimizedService0 = (Service)minimizedServer.getServices().get(0);
        MatcherAssert.assertThat((Object)minimizedService0.getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((Integer)minimizedService0.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedService0.getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedService0.getServer(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)minimizedService0.getApi(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)minimizedServer.getTestbed().getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed().getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed().getLongName(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed().getSerializeAsEmbeddedObject(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimizedServer.getTestbed().getServers(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        String json = MAPPER.writer().with(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)minimizedServer);
        LOG.debug("Generated JSON: " + json);
        Map map = (Map)MAPPER.readValue(json, Map.class);
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"services"));
        MatcherAssert.assertThat(map.get("services"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(List.class)));
        MatcherAssert.assertThat(map.get("defaultScs"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat(map.get("defaultUserAuth"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat(map.get("defaultAMService"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat(((List)map.get("scs")).get(0), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat(((List)map.get("userAuth")).get(0), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat((Object)((List)map.get("services")), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat(((List)map.get("services")).get(0), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Map.class)));
        MatcherAssert.assertThat((Object)((Map)((List)map.get("services")).get(0)), (Matcher)Matchers.hasKey((Object)"@id"));
        MatcherAssert.assertThat((Object)((Map)((List)map.get("services")).get(0)), (Matcher)Matchers.hasKey((Object)"id"));
        MatcherAssert.assertThat((Object)((Map)((List)map.get("services")).get(0)), (Matcher)Matchers.hasKey((Object)"@type"));
        MatcherAssert.assertThat((Object)((Map)((List)map.get("services")).get(0)), (Matcher)Matchers.hasKey((Object)"api"));
        MatcherAssert.assertThat((Object)((Map)((List)map.get("services")).get(0)), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"server")));
        MatcherAssert.assertThat((Object)((String)((Map)((List)map.get("services")).get(0)).get("@id")), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Service)serverA.getServices().get(0)).getUri().toASCIIString())));
        MatcherAssert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"testbed"));
        MatcherAssert.assertThat(map.get("testbed"), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat((Object)((String)map.get("testbed")), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)serverA.getTestbed().getUri().toASCIIString())));
    }
}

