/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json_test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.OrganisationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.LinkedTestbedDataTestCollection;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.testing.FixtureHelpers;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class LinkedTestbedDataJsonTest {
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    @Before
    public void before() throws ParseException, URISyntaxException {
    }

    private void serializesOrganisationToJSON(int index) throws Exception {
        LinkedTestbedDataTestCollection linkedTestbedDataTestCollection = new LinkedTestbedDataTestCollection(index == 0, 0, "http://localhost:9000");
        String id = (String)linkedTestbedDataTestCollection.getOrganisationByIndex(index).getId();
        String organisationFixture = FixtureHelpers.fixture((String)linkedTestbedDataTestCollection.getOrganisationFixture(index));
        String expected = MAPPER.writer().with(SerializationFeature.INDENT_OUTPUT).writeValueAsString(MAPPER.readValue(organisationFixture, Organisation.class));
        assert (((String)linkedTestbedDataTestCollection.getOrganisationById(id).getId()).equals(id));
        assert (linkedTestbedDataTestCollection.getOrganisationById(id).getTestbeds() != null);
        assert (!linkedTestbedDataTestCollection.getOrganisationById(id).getTestbeds().isEmpty());
        assert (((Testbed)linkedTestbedDataTestCollection.getOrganisationById(id).getTestbeds().get(0)).getOrganisation() != null);
        assert (Objects.equals(((Testbed)linkedTestbedDataTestCollection.getOrganisationById(id).getTestbeds().get(0)).getOrganisation().getId(), linkedTestbedDataTestCollection.getOrganisationById(id).getId()));
        assert (!((Testbed)linkedTestbedDataTestCollection.getOrganisationById(id).getTestbeds().get(0)).getFederations().isEmpty());
        Organisation organisation = OrganisationBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN_NOBACKLINK, (Organisation)linkedTestbedDataTestCollection.getOrganisationById(id));
        assert (organisation.getTestbeds() != null);
        assert (!organisation.getTestbeds().isEmpty());
        assert (((Testbed)organisation.getTestbeds().get(0)).getOrganisation() == null);
        assert (((Testbed)organisation.getTestbeds().get(0)).getFederations() == null);
        String actual = MAPPER.writer().with(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)organisation);
        System.out.println("actual: " + actual);
        System.out.println("expected : " + expected);
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected)));
    }

    private void deserializesOrganisationFromJSON(int index) throws Exception {
        LinkedTestbedDataTestCollection linkedTestbedDataTestCollection = new LinkedTestbedDataTestCollection(index == 0, 0, "http://localhost:9000");
        String id = (String)linkedTestbedDataTestCollection.getOrganisationByIndex(index).getId();
        Organisation organisation = OrganisationBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN_NOBACKLINK, (Organisation)linkedTestbedDataTestCollection.getOrganisationById(id));
        MatcherAssert.assertThat((Object)((Organisation)MAPPER.readValue(FixtureHelpers.fixture((String)linkedTestbedDataTestCollection.getOrganisationFixture(index)), Organisation.class)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)organisation)));
    }

    private void serializesTestbedToJSON(int index) throws Exception {
        LinkedTestbedDataTestCollection linkedTestbedDataTestCollection = new LinkedTestbedDataTestCollection(index == 0, 0, "http://localhost:9000");
        String id = (String)linkedTestbedDataTestCollection.getTestbedByIndex(index).getId();
        String expected = MAPPER.writer().with(SerializationFeature.INDENT_OUTPUT).writeValueAsString(MAPPER.readValue(FixtureHelpers.fixture((String)linkedTestbedDataTestCollection.getTestbedFixture(index)), Testbed.class));
        Testbed testbed = TestbedBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN_NOBACKLINK, (Testbed)linkedTestbedDataTestCollection.getTestbedById(id));
        MatcherAssert.assertThat((Object)MAPPER.writer().with(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)testbed), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected)));
        System.out.println("Serialized testbed: " + expected);
    }

    private void deserializesTestbedFromJSON(int index) throws Exception {
        LinkedTestbedDataTestCollection linkedTestbedDataTestCollection = new LinkedTestbedDataTestCollection(index == 0, 0, "http://localhost:9000");
        String id = (String)linkedTestbedDataTestCollection.getTestbedByIndex(index).getId();
        Testbed testbed = TestbedBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_EMBEDDING_PARENT_AND_CHILDREN_NOBACKLINK, (Testbed)linkedTestbedDataTestCollection.getTestbedById(id));
        MatcherAssert.assertThat((Object)((Testbed)MAPPER.readValue(FixtureHelpers.fixture((String)linkedTestbedDataTestCollection.getTestbedFixture(index)), Testbed.class)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)testbed)));
    }

    @Test
    public void serializesOrganisationToJSON0() throws Exception {
        this.serializesOrganisationToJSON(0);
    }

    @Test
    public void deserializesOrganisationFromJSON0() throws Exception {
        this.deserializesOrganisationFromJSON(0);
    }

    @Test
    public void serializesOrganisationToJSON1() throws Exception {
        this.serializesOrganisationToJSON(1);
    }

    @Test
    public void deserializesOrganisationFromJSON1() throws Exception {
        this.deserializesOrganisationFromJSON(1);
    }

    @Test
    public void serializesTestbedToJSON0() throws Exception {
        this.serializesTestbedToJSON(1);
    }

    @Test
    public void deserializesTestbedFromJSON0() throws Exception {
        this.deserializesTestbedFromJSON(1);
    }
}

