/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Admin;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.AdminTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import javax.ws.rs.client.Entity;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class AdminIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected static AdminTestCollection adminTestCollection;
    protected JerseyClient client;

    @BeforeClass
    public static void setUp() throws Exception {
        AdminIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
        adminTestCollection = new AdminTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.refillDB();
        testPostgresDB.close();
    }

    public void testLookup(Admin expected) throws Exception {
        Admin actual = this.doLookup();
        this.checkLookup(expected, actual);
    }

    public Admin doLookup() throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/admin/", RULE.getLocalPort()));
        Admin actual = (Admin)query.request().get(Admin.class);
        System.out.println("Got result Admin: " + actual);
        return actual;
    }

    public void doUpdate(Admin admin) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/admin/", RULE.getLocalPort()));
        query.request().put(Entity.json((Object)admin));
    }

    public void checkLookup(Admin expected, Admin actual) {
        adminTestCollection.assertSameDetails(actual, expected);
    }

    @Test
    public void lookup0() throws Exception {
        Admin expected = (Admin)adminTestCollection.getByIndex(0);
        this.testLookup(expected);
    }

    @Test
    public void update0() throws Exception {
        Admin expected = (Admin)adminTestCollection.getByIndex(0);
        this.doUpdate(expected);
        this.testLookup(expected);
    }

    @Test
    public void update0b() throws Exception {
        this.doUpdate((Admin)adminTestCollection.getByIndex(1));
        this.doUpdate((Admin)adminTestCollection.getByIndex(2));
        Admin expected = (Admin)adminTestCollection.getByIndex(0);
        this.doUpdate(expected);
        this.testLookup(expected);
    }

    @Test
    public void update1() throws Exception {
        Admin expected = (Admin)adminTestCollection.getByIndex(1);
        this.doUpdate(expected);
        this.testLookup(expected);
    }

    @Test
    public void update2() throws Exception {
        Admin expected = (Admin)adminTestCollection.getByIndex(2);
        this.doUpdate(expected);
        this.testLookup(expected);
    }
}

