/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FederationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FederationTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class FederationIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    protected static TestbedTestCollection testbedTestCollection;
    protected static FederationTestCollection federationTestCollection;
    protected JerseyClient client;
    protected static FedmonTestPostgresDB testPostgresDB;
    public static DropwizardAppRule<FedmonWebApiServiceConfiguration> usedRule;

    @BeforeClass
    public static void setUp() throws Exception {
        FederationIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        usedRule = RULE;
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testbedTestCollection = new TestbedTestCollection(false);
        federationTestCollection = new FederationTestCollection(true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
        assert (testPostgresDB != null);
        testPostgresDB.close();
        testPostgresDB = null;
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        ((FedmonWebApiServiceApplication)usedRule.getApplication()).getSharedResourceCache().invalidateFull();
    }

    public List<Federation> testGetAll(List<Federation> expected) throws Exception {
        List<Federation> actual = this.doGetAll();
        this.checkGetAll(expected, actual);
        for (Federation r : actual) {
            Federation federation = expected.stream().filter(t -> ((String)t.getId()).equals(r.getId())).findFirst().orElseThrow(() -> new AssertionError((Object)"did not find federation"));
        }
        return actual;
    }

    public List<Federation> doGetAll() throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/federation/", RULE.getLocalPort()));
        List actual = (List)query.request().accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<Federation>>(){});
        System.out.println("Got " + actual.size() + " federations. Id's: " + actual.stream().map(PrimaryIdObject::getId).collect(Collectors.toList()));
        return actual;
    }

    public void checkGetAll(List<Federation> expected, List<Federation> actual) {
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasSize((int)expected.size()));
        for (Federation ex : expected) {
            Federation ac = (Federation)federationTestCollection.searchListById(actual, (String)ex.getId());
            MatcherAssert.assertThat((String)("Expected id " + (String)ex.getId() + " not found in result"), (Object)ac, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            federationTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)ac, (JsonLdObjectWithId)ex, true);
        }
    }

    public void testLookup(Federation expected, String id) throws Exception {
        Federation actual = this.doLookup(id);
        this.checkLookup(expected, actual);
    }

    public Federation doLookup(String id) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/federation/" + id, RULE.getLocalPort()));
        Federation actual = (Federation)query.request().get(Federation.class);
        System.out.println("Got result Federation. len=" + actual);
        return actual;
    }

    public void checkLookup(Federation expected, Federation actual) {
        federationTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, true);
    }

    @Test
    public void lookup0() throws Exception {
        Federation expected = (Federation)federationTestCollection.getByIndex(0);
        this.testLookup(expected, (String)expected.getId());
    }

    @Test
    public void lookup1() throws Exception {
        Federation expected = (Federation)federationTestCollection.getByIndex(1);
        this.testLookup(expected, (String)expected.getId());
    }

    @Test
    public void lookup2() throws Exception {
        Federation expected = (Federation)federationTestCollection.getByIndex(2);
        this.testLookup(expected, (String)expected.getId());
    }

    @Test
    public void getAll() throws Exception {
        List expected = federationTestCollection.getAll();
        this.testGetAll(expected);
    }

    public Federation createFederationCall(Federation federation) throws Exception {
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/federation/", RULE.getLocalPort()));
        Entity entity = Entity.entity((Object)federation, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        Federation res = (Federation)w.request().post(entity, Federation.class);
        return res;
    }

    public List<URI> getCategoriesCall(Federation federation) throws Exception {
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/federation/%s/categories/", RULE.getLocalPort(), federation.getId()));
        Entity entity = Entity.entity((Object)federation, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        List res = (List)w.request().get((GenericType)new GenericType<List<URI>>(){});
        return res;
    }

    public List<URI> updateCategoriesCall(Federation federation, List<URI> newCategories) throws Exception {
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/federation/%s/categories/", RULE.getLocalPort(), federation.getId()));
        Entity entity = Entity.entity(newCategories, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        List res = (List)w.request().put(entity, (GenericType)new GenericType<List<URI>>(){});
        return res;
    }

    public void deleteFederationCall(String id) throws Exception {
        this.client.target(String.format("http://localhost:%d/federation/%s", RULE.getLocalPort(), id)).request().delete();
    }

    public void updateFederationCall(Federation updatedFederation) throws Exception {
        this.client.target(String.format("http://localhost:%d/federation/%s/", RULE.getLocalPort(), updatedFederation.getId())).request().put(Entity.entity((Object)updatedFederation, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    @Test
    public void update() throws Exception {
        Federation updatedFederation;
        Federation origFederation = (Federation)federationTestCollection.getByIndex(0);
        try {
            updatedFederation = new FederationBuilder(origFederation).setLongName("updateTest").setDescription("update descr").setNotes("notes for the updated").setUrlsFromStrings(Arrays.asList("http://example.com/update", "https://www.example.com/updatealso")).setTestbeds(new ArrayList()).addTestbed("B").addTestbed("C").create();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("should not happen", e);
        }
        this.updateFederationCall(updatedFederation);
        Federation expectedFederation = updatedFederation;
        Federation lookedUpFederation = this.doLookup((String)updatedFederation.getId());
        federationTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)lookedUpFederation, (JsonLdObjectWithId)expectedFederation, true);
    }

    @Test
    public void insert() throws Exception {
        Federation newFederation;
        String newId = "ins";
        try {
            newFederation = ((FederationBuilder)new FederationBuilder().setId((Object)newId)).setLongName("insertTest").setDescription("insert descr").setNotes("notes for the inserted").setUrlsFromStrings(Arrays.asList("http://example.com/insert", "https://www.example.com/insertalso")).setFederatedWith("fed2").addTestbed("A").addTestbed("B").addTestbed("C").setTestbeds(Collections.emptyList()).create();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("should not happen", e);
        }
        Federation actualCreatedFederation = this.createFederationCall(newFederation);
        Federation expectedFederation = newFederation;
        federationTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actualCreatedFederation, (JsonLdObjectWithId)expectedFederation, true);
        Federation lookedUpFederation = this.doLookup((String)newFederation.getId());
        federationTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)lookedUpFederation, (JsonLdObjectWithId)expectedFederation, true);
    }
}

