/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FederationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.util.jsonld.test.ObjectWithIdTestCollection;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class FederationTestCollection
extends ObjectWithIdTestCollection<String, Federation, FederationBuilder> {
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    public FederationTestCollection() {
        this(true);
    }

    public FederationTestCollection(boolean linkWithTestbeds) {
        super(String.class, Federation.class, FederationBuilder.class);
        URI url1a;
        URI url1;
        TestbedTestCollection testbedTestCollection = linkWithTestbeds ? new TestbedTestCollection() : null;
        String id1 = "fed1";
        String id2 = "fed2";
        String id1a = "subfed1a";
        try {
            url1 = new URI("http://example.com/fed1");
            url1a = new URI("http://example.com/fed1a");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Testbed testbedA = null;
        Testbed testbedB = null;
        Testbed testbedC = null;
        if (linkWithTestbeds) {
            testbedA = (Testbed)testbedTestCollection.getByIndex(0);
            testbedB = (Testbed)testbedTestCollection.getByIndex(1);
            testbedC = (Testbed)testbedTestCollection.getByIndex(2);
            assert (testbedA != null);
            assert (testbedA.getId() != null);
            assert (testbedB != null);
            assert (testbedB.getId() != null);
            assert (testbedC != null);
            assert (testbedC.getId() != null);
        }
        FederationBuilder federation1 = ((FederationBuilder)new FederationBuilder().setId((Object)id1)).setLongName("Federation 1").setDescription("This is Federation 1").setNotes("Notes for fed1").addUrl(url1).setFederatedWith((Federation)null);
        if (linkWithTestbeds) {
            federation1 = federation1.setTestbeds(Arrays.asList(testbedA, testbedB));
        }
        this.all.add(federation1);
        FederationBuilder federation2 = ((FederationBuilder)new FederationBuilder().setId((Object)id2)).setLongName("Federation 2").setDescription(null).setNotes(null).setUrls(null).setFederatedWith((Federation)null);
        if (linkWithTestbeds) {
            federation2 = federation2.setTestbeds(Arrays.asList(testbedC));
        }
        this.all.add(federation2);
        FederationBuilder federation1a = ((FederationBuilder)new FederationBuilder().setId((Object)id1a)).setLongName("Federation 1a").setDescription("This is Federation 1a").setNotes("Notes for fed1a").addUrl(url1).addUrl(url1a).setFederatedWith(id1);
        if (linkWithTestbeds) {
            federation1a = federation1a.setTestbeds(Arrays.asList(testbedA));
        }
        this.all.add(federation1a);
    }

    public void assertSameExtraIds(Federation actual, Federation expected) {
    }

    public void assertSameDetails(Federation actual, Federation expected) {
        MatcherAssert.assertThat((String)"long name differs", (Object)actual.getLongName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getLongName())));
        MatcherAssert.assertThat((String)"description differs", (Object)actual.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getDescription())));
        MatcherAssert.assertThat((String)"notes differ", (Object)actual.getNotes(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getNotes())));
        MatcherAssert.assertThat((String)"urls differ", (Object)actual.getUrls(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getUrls())));
        MatcherAssert.assertThat((Object)actual.getClassName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getClassName())));
    }

    public void assertSearchLinks(Federation actual) {
    }
}

