/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FrequencyTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class FrequencyIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected static FrequencyTestCollection frequencyTestCollection;
    protected JerseyClient client;

    @BeforeClass
    public static void setUp() throws Exception {
        FrequencyIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
        frequencyTestCollection = new FrequencyTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
    }

    public void testLookup(Frequency expected, int id) throws Exception {
        Frequency actual = this.doLookup(id);
        this.checkLookup(expected, actual);
    }

    public Frequency doLookup(int id) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/frequency/" + id, RULE.getLocalPort()));
        Frequency actual = (Frequency)query.request().get(Frequency.class);
        System.out.println("Got result frequency: " + actual);
        return actual;
    }

    public void checkLookup(Frequency expected, Frequency actual) {
        frequencyTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, true);
    }

    @Test
    public void lookup0() throws Exception {
        Frequency expected = (Frequency)frequencyTestCollection.getByIndex(0);
        this.testLookup(expected, (Integer)expected.getId());
    }

    @Test
    public void lookup1() throws Exception {
        Frequency expected = (Frequency)frequencyTestCollection.getByIndex(1);
        this.testLookup(expected, (Integer)expected.getId());
    }

    @Test
    public void lookup2() throws Exception {
        Frequency expected = (Frequency)frequencyTestCollection.getByIndex(2);
        this.testLookup(expected, (Integer)expected.getId());
    }
}

