/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Graph;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GraphBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.GraphTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestClock;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(GraphIntegrationTest.class);
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static GraphTestCollection graphTestCollection;
    protected static Clock.DefaultTestTimeProvider timeProvider;
    private static FedmonTestPostgresDB testPostgresDB;
    Client client;

    @BeforeClass
    public static void setUp() throws Exception {
        GraphIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        ((FedmonWebApiServiceConfiguration)RULE.getConfiguration()).setBaseUrl(String.format("http://localhost:%d/", RULE.getLocalPort()));
        timeProvider = new Clock.DefaultTestTimeProvider();
        Clock.set((Clock.CurrentTimeProvider)timeProvider);
        Clock.lockProvider();
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        graphTestCollection = new GraphTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        Clock.reset();
    }

    @Before
    public void initClient() throws Exception {
        this.client = new JerseyClientBuilder().build();
        timeProvider.setNowOffsetMinutes(0L);
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.refillDB();
        testPostgresDB.close();
    }

    public Graph upsertGraphCall(Graph graph) throws Exception, CallFailedException {
        assert (graph.getId() != null);
        WebTarget w = this.client.target(String.format("http://localhost:%d/graph/%s", RULE.getLocalPort(), graph.getId()));
        Graph res = (Graph)w.request().accept(new String[]{"application/json"}).put(Entity.json((Object)graph), Graph.class);
        return res;
    }

    public void updateGraphImageDataCall(Graph graph, byte[] imageData) throws Exception, CallFailedException {
        assert (graph.getId() != null);
        WebTarget wimage = this.client.target(String.format("http://localhost:%d/graph/%s/image", RULE.getLocalPort(), graph.getId()));
        Response response = imageData == null ? wimage.request().put(Entity.entity((Object)new byte[0], (String)"image/png")) : wimage.request().put(Entity.entity((Object)imageData, (String)"image/png"));
        LOG.debug("updateGraphImageDataCall response: " + response);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.isOneOf((Object[])new Integer[]{200, 204}));
    }

    public Graph getGraphCall(String graphId) throws Exception, CallFailedException {
        return (Graph)this.client.target(String.format("http://localhost:%d/graph/%s", RULE.getLocalPort(), graphId)).request().get(Graph.class);
    }

    public List<Graph> getGraphByTestInstanceIdCall(Integer testInstanceId) throws Exception, CallFailedException {
        return (List)this.client.target(String.format("http://localhost:%d/graph?testinstanceid=%d", RULE.getLocalPort(), testInstanceId)).request().get((GenericType)new GenericType<List<Graph>>(){});
    }

    public byte[] getGraphContentCall(Graph graph) throws Exception, CallFailedException {
        assert (graph.getImageUri() != null);
        LOG.debug("Looking up content of graph " + (String)graph.getId() + " using URL " + graph.getImageUri());
        return (byte[])this.client.target(graph.getImageUri()).request().accept(new String[]{"image/png"}).get(byte[].class);
    }

    public void testLookup(Graph expected, String id) throws Exception {
        Graph actual = this.getGraphCall(id);
        this.checkLookup(expected, actual);
    }

    public void checkLookup(Graph expected, Graph actual) {
        graphTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, true);
    }

    @Test
    public void lookup0() throws Exception {
        Graph expected = (Graph)graphTestCollection.getByIndex(0);
        this.testLookup(expected, (String)expected.getId());
    }

    @Test
    public void lookup1() throws Exception {
        Graph expected = (Graph)graphTestCollection.getByIndex(1);
        this.testLookup(expected, (String)expected.getId());
    }

    @Test
    public void lookupByTestInstance0() throws Exception {
        List<Graph> expected = Arrays.asList((Graph)graphTestCollection.getByIndex(0));
        this.testLookupByTestInstanceId(expected, ((Graph)graphTestCollection.getByIndex(0)).getTestInstanceId());
    }

    @Test
    public void lookupByTestInstanceNone() throws Exception {
        this.testLookupByTestInstanceId(Collections.emptyList(), 1234);
    }

    public void testLookupByTestInstanceId(List<Graph> expected, Integer testInstanceId) throws Exception {
        List<Graph> actual = this.getGraphByTestInstanceIdCall(testInstanceId);
        this.checkLookupByTestInstanceId(expected, actual);
    }

    public void checkLookupByTestInstanceId(List<Graph> expectedList, List<Graph> actualList) {
        MatcherAssert.assertThat(actualList, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat(actualList, (Matcher)Matchers.hasSize((int)expectedList.size()));
        int foundCount = 0;
        for (Graph actual : actualList) {
            for (Graph expected : expectedList) {
                if (!((String)actual.getId()).equals(expected.getId())) continue;
                graphTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, true);
                ++foundCount;
            }
        }
        MatcherAssert.assertThat((String)"did not find all graphs", (Object)foundCount, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedList.size())));
    }

    public void testLookupContent(Graph graph, byte[] expectedContent) throws Exception {
        Graph lookedUpGraph = this.getGraphCall((String)graph.getId());
        LOG.debug("testLookupContent for graph with image URI: " + lookedUpGraph.getImageUri());
        byte[] actualContent = this.getGraphContentCall(lookedUpGraph);
        if (expectedContent != null && expectedContent.length > 0) {
            MatcherAssert.assertThat((Object)actualContent, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedContent)));
        } else if (actualContent == null) {
            MatcherAssert.assertThat((Object)actualContent, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        } else {
            MatcherAssert.assertThat((Object)actualContent.length, (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void lookupContent0() throws Exception {
        Graph graph = (Graph)graphTestCollection.getByIndex(0);
        byte[] expected = graphTestCollection.getImageDataByIndex(0);
        this.testLookupContent(graph, expected);
    }

    @Test
    public void lookupContent1() throws Exception {
        Graph graph = (Graph)graphTestCollection.getByIndex(1);
        byte[] expected = graphTestCollection.getImageDataByIndex(1);
        assert (expected == null);
        this.testLookupContent(graph, expected);
    }

    @Test
    public void lookupContentX() throws Exception {
        WebTarget wimage = this.client.target(String.format("http://localhost:%d/graph/%s/image", RULE.getLocalPort(), "nonexisting-1day"));
        Response response = wimage.request().accept(new String[]{"image/png"}).get();
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void testSetContent0a() throws Exception {
        Graph graph = (Graph)graphTestCollection.getByIndex(0);
        byte[] origImageData = graphTestCollection.getImageDataByIndex(0);
        byte[] expectedImageData = new byte[]{88, 99, 11};
        Graph lookedUpGraph = this.getGraphCall((String)graph.getId());
        LOG.debug("appending string content to graph with image URI: " + lookedUpGraph.getImageUri());
        this.updateGraphImageDataCall(lookedUpGraph, expectedImageData);
        this.testLookupContent(lookedUpGraph, expectedImageData);
    }

    @Test
    public void testSetContent0b() throws Exception {
        Graph graph = (Graph)graphTestCollection.getByIndex(0);
        byte[] origImageData = graphTestCollection.getImageDataByIndex(0);
        byte[] expectedImageData = null;
        Graph lookedUpGraph = this.getGraphCall((String)graph.getId());
        LOG.debug("appending string content to graph with image URI: " + lookedUpGraph.getImageUri());
        this.updateGraphImageDataCall(lookedUpGraph, expectedImageData);
        this.testLookupContent(lookedUpGraph, expectedImageData);
    }

    @Test
    public void testUpsertCreateGraph() throws Exception {
        Graph expectedNewGraph = graphTestCollection.getGraphToInsert().create();
        this.upsertGraphCall(expectedNewGraph);
        this.testLookup(expectedNewGraph, (String)expectedNewGraph.getId());
        this.testLookupContent(expectedNewGraph, null);
    }

    @Test
    public void testUpdateGraph0() throws Exception {
        Graph origGraph = (Graph)graphTestCollection.getByIndex(0);
        GraphBuilder updatedGraphBuilder = new GraphBuilder(origGraph);
        updatedGraphBuilder.setGraphDefinitionId("testU");
        updatedGraphBuilder.setSubType("tU");
        updatedGraphBuilder.setPeriodString("2day");
        updatedGraphBuilder.setPeriodInSeconds(Long.valueOf(172800L));
        updatedGraphBuilder.setDescription("Test 2 Day Graph");
        updatedGraphBuilder.setTestInstanceId(Integer.valueOf(11));
        updatedGraphBuilder.setTestDefinitionId("anyGetVersion");
        updatedGraphBuilder.setGraphStartTime(TestClock.get().getOffsetMinutes(103680L));
        updatedGraphBuilder.setGraphEndTime(TestClock.get().getOffsetMinutes(106560L));
        updatedGraphBuilder.setExpire(TestClock.get().getOffsetMinutes(106570L));
        Graph exprectedUpdatedGraph = updatedGraphBuilder.create();
        MatcherAssert.assertThat((Object)((String)exprectedUpdatedGraph.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((String)origGraph.getId()))));
        this.upsertGraphCall(exprectedUpdatedGraph);
        this.testLookup(exprectedUpdatedGraph, (String)exprectedUpdatedGraph.getId());
        this.testLookupContent(exprectedUpdatedGraph, graphTestCollection.getImageDataByIndex(0));
    }

    public static class CallFailedException
    extends Exception {
        public CallFailedException() {
        }

        public CallFailedException(String message) {
            super(message);
        }

        public CallFailedException(String message, Throwable cause) {
            super(message, cause);
        }

        public CallFailedException(Throwable cause) {
            super(cause);
        }

        public CallFailedException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

