/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Graph;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.GraphBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ResultTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TaskTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestClock;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.UriTool;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import be.iminds.ilabt.util.jsonld.test.ObjectWithIdTestCollection;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class GraphTestCollection
extends ObjectWithIdTestCollection<String, Graph, GraphBuilder> {
    private final GraphBuilder graphToInsert;

    public GraphTestCollection() {
        super(String.class, Graph.class, GraphBuilder.class);
        ResultTestCollection resultTestCollection = new ResultTestCollection(true);
        TaskTestCollection taskTestCollection = new TaskTestCollection();
        GraphBuilder graph0 = new GraphBuilder();
        graph0.setId("test-t-1day");
        graph0.setGraphDefinitionId("test");
        graph0.setSubType("t");
        graph0.setPeriodString("1day");
        graph0.setPeriodInSeconds(Long.valueOf(86400L));
        graph0.setDescription("Test Day Graph");
        graph0.setTestInstanceId(Integer.valueOf(9));
        graph0.setTestDefinitionId("ping");
        graph0.setGraphStartTime(TestClock.get().getBase());
        graph0.setGraphEndTime(TestClock.get().getOffsetMinutes(1440L));
        graph0.setExpire(TestClock.get().getOffsetMinutes(1500L));
        this.all.add(graph0);
        GraphBuilder graph1 = new GraphBuilder();
        graph1.setId("test2-1hour");
        graph1.setGraphDefinitionId("test2");
        graph1.setSubType(null);
        graph1.setPeriodString("1hour");
        graph1.setPeriodInSeconds(null);
        graph1.setDescription(null);
        graph1.setTestInstanceId(null);
        graph1.setTestDefinitionId(null);
        graph1.setGraphStartTime(null);
        graph1.setGraphEndTime(null);
        graph1.setExpire(null);
        this.all.add(graph1);
        this.graphToInsert = new GraphBuilder();
        this.graphToInsert.setId("test3-S-1week");
        this.graphToInsert.setGraphDefinitionId("test3");
        this.graphToInsert.setSubType("S");
        this.graphToInsert.setPeriodString("1week");
        this.graphToInsert.setPeriodInSeconds(Long.valueOf(604800L));
        this.graphToInsert.setDescription("Test Week Graph");
        this.graphToInsert.setTestInstanceId(Integer.valueOf(10));
        this.graphToInsert.setTestDefinitionId("anyGetVersion");
        this.graphToInsert.setGraphStartTime(TestClock.get().getOffsetMinutes(1440L));
        this.graphToInsert.setGraphEndTime(TestClock.get().getOffsetMinutes(11520L));
        this.graphToInsert.setExpire(TestClock.get().getOffsetMinutes(11580L));
    }

    public GraphBuilder getGraphToInsert() {
        return this.graphToInsert;
    }

    public byte[] getImageDataByIndex(int index) {
        switch (index) {
            case 0: {
                return new byte[]{0, 1, 2};
            }
            case 1: {
                return null;
            }
        }
        throw new IndexOutOfBoundsException("No Graph in test collection for index " + index);
    }

    public void setUri(int index, UriTool uriTool) throws URISyntaxException {
        super.setUri(index, uriTool);
        GraphBuilder orig = (GraphBuilder)this.all.get(index);
        GraphBuilder updated = orig.setImageUri(new URI(orig.getUri().toASCIIString() + "/image"));
        this.all.set(index, updated);
    }

    public void assertSameExtraIds(Graph actual, Graph expected) {
    }

    public void assertSameDetails(Graph actual, Graph expected) {
        MatcherAssert.assertThat((String)"graphDefinitionId differs", (Object)actual.getGraphDefinitionId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getGraphDefinitionId())));
        MatcherAssert.assertThat((String)"subType differs", (Object)actual.getSubType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getSubType())));
        MatcherAssert.assertThat((String)"periodString differs", (Object)actual.getPeriodString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getPeriodString())));
        MatcherAssert.assertThat((String)"description differs", (Object)actual.getDescription(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getDescription())));
        MatcherAssert.assertThat((String)"periodIsS differs", (Object)actual.getPeriodInSeconds(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getPeriodInSeconds())));
        MatcherAssert.assertThat((String)"start differs", (Object)actual.getGraphStartTime(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getGraphStartTime())));
        MatcherAssert.assertThat((String)"end differs", (Object)actual.getGraphEndTime(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getGraphEndTime())));
        MatcherAssert.assertThat((String)"expire differs", (Object)actual.getExpire(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getExpire())));
    }

    public void assertSearchLinks(Graph actual) {
    }

    public void assertSame(Graph actual, Graph expected, CommonTest.ComparePrecision base, @Nullable CommonTest.ComparePrecision references) {
        super.assertSame((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, base, references);
        if (base != null && base.mustExpectActualHasUri()) {
            MatcherAssert.assertThat((Object)actual.getImageUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)actual.getImageUri().getPath(), (Matcher)Matchers.endsWith((String)"/image"));
        }
    }

    public JsonLdObjectsMetaData.Minimization getFixtureMinimization() {
        return JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS;
    }
}

