/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfigBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.SearchUriGenerator;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.JFedExperimenterGuiConfigTestCollection;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.UriTool;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.testing.FixtureHelpers;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class JFedExperimenterGuiConfigTest {
    private static JsonLdObjectsMetaData jsonLdObjectsMetaData;

    @BeforeClass
    public static void beforeClass() {
        jsonLdObjectsMetaData = JsonLdObjectsMetaData.getInstance((String)Testbed.class.getPackage().getName());
    }

    @Test
    public void testDeserializeWhileIgnoringUnkownProperties() throws Exception {
        ObjectMapper MAPPER = Jackson.newObjectMapper();
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JFedExperimenterGuiConfigTestCollection testCol = new JFedExperimenterGuiConfigTestCollection();
        UriTool uriTool = jsonLdObjectsMetaData.makeUriTool("http://localhost:9000", (UriTool.DerivedUriGenerator)new SearchUriGenerator());
        testCol.setUri(0, uriTool);
        String fixtureFilename = "fixtures/jfedexperimenterguiconfig-0+unknown.json";
        JFedExperimenterGuiConfigBuilder expectedBuilder = (JFedExperimenterGuiConfigBuilder)testCol.getBuilderByIndex(0);
        JFedExperimenterGuiConfig expected = expectedBuilder.createMinimized(testCol.getFixtureMinimization());
        JFedExperimenterGuiConfig actual = (JFedExperimenterGuiConfig)MAPPER.readValue(FixtureHelpers.fixture((String)fixtureFilename), JFedExperimenterGuiConfig.class);
        testCol.assertSame((JsonLdObject)actual, (JsonLdObject)expected, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }

    @Test(expectedExceptions={JsonMappingException.class})
    public void testDeserializeWhileFailingOnUnkownProperties() throws Exception {
        ObjectMapper MAPPER = Jackson.newObjectMapper();
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        JFedExperimenterGuiConfigTestCollection testCol = new JFedExperimenterGuiConfigTestCollection();
        UriTool uriTool = jsonLdObjectsMetaData.makeUriTool("http://localhost:9000", (UriTool.DerivedUriGenerator)new SearchUriGenerator());
        testCol.setUri(0, uriTool);
        String fixtureFilename = "fixtures/jfedexperimenterguiconfig-0+unknown.json";
        JFedExperimenterGuiConfigBuilder expectedBuilder = (JFedExperimenterGuiConfigBuilder)testCol.getBuilderByIndex(0);
        JFedExperimenterGuiConfig expected = expectedBuilder.createMinimized(testCol.getFixtureMinimization());
        JFedExperimenterGuiConfig actual = (JFedExperimenterGuiConfig)MAPPER.readValue(FixtureHelpers.fixture((String)fixtureFilename), JFedExperimenterGuiConfig.class);
        testCol.assertSame((JsonLdObject)actual, (JsonLdObject)expected, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.IGNORE_URI);
    }
}

