/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.OrganisationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Proxy;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ProxyBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.SearchUriGenerator;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.OrganisationTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServerTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServiceTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.UriTool;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LinkedTestbedDataTestCollection {
    private final List<Organisation> organisations;
    private final List<Testbed> testbeds;
    private final List<Server> servers;
    private final List<Service> services;
    private final JsonLdObjectsMetaData jsonLdObjectsMetaData = JsonLdObjectsMetaData.getInstance((String)Testbed.class.getPackage().getName());

    public LinkedTestbedDataTestCollection(boolean setUri, int setUriIndex, String uriBase) {
        OrganisationTestCollection organisationTestCollection = new OrganisationTestCollection();
        TestbedTestCollection testbedTestCollection = new TestbedTestCollection();
        ServerTestCollection serverTestCollection = new ServerTestCollection();
        ServiceTestCollection serviceTestCollection = new ServiceTestCollection();
        OrganisationBuilder orgBuilder0 = (OrganisationBuilder)organisationTestCollection.getBuilderByIndex(0);
        OrganisationBuilder orgBuilder1 = (OrganisationBuilder)organisationTestCollection.getBuilderByIndex(1);
        TestbedBuilder testbedBuilder0 = (TestbedBuilder)testbedTestCollection.getBuilderByIndex(0);
        TestbedBuilder testbedBuilder1 = (TestbedBuilder)testbedTestCollection.getBuilderByIndex(1);
        TestbedBuilder testbedBuilder2 = (TestbedBuilder)testbedTestCollection.getBuilderByIndex(2);
        ServerBuilder serverBuilder0 = new ServerBuilder((Server)serverTestCollection.getByIndex(0));
        ServerBuilder serverBuilder1 = new ServerBuilder((Server)serverTestCollection.getByIndex(1));
        ServerBuilder serverBuilder2 = new ServerBuilder((Server)serverTestCollection.getByIndex(2));
        ServiceBuilder serviceBuilder0 = new ServiceBuilder((Service)serviceTestCollection.getByIndex(0));
        ServiceBuilder serviceBuilder1 = new ServiceBuilder((Service)serviceTestCollection.getByIndex(1));
        ServiceBuilder serviceBuilder2 = new ServiceBuilder((Service)serviceTestCollection.getByIndex(2));
        ServiceBuilder serviceBuilder3 = new ServiceBuilder((Service)serviceTestCollection.getByIndex(3));
        ServiceBuilder serviceBuilder4 = new ServiceBuilder((Service)serviceTestCollection.getByIndex(4));
        ServiceBuilder serviceBuilder5 = new ServiceBuilder((Service)serviceTestCollection.getByIndex(5));
        orgBuilder0.setTestbeds(null);
        orgBuilder1.setTestbeds(null);
        orgBuilder0.setTestbedBuilders(Arrays.asList(testbedBuilder0, testbedBuilder2));
        orgBuilder1.setTestbedBuilders(Arrays.asList(testbedBuilder1));
        testbedBuilder0.setServers(null);
        testbedBuilder1.setServers(null);
        testbedBuilder2.setServers(null);
        testbedBuilder0.setOrganisation(null);
        testbedBuilder1.setOrganisation(null);
        testbedBuilder2.setOrganisation(null);
        testbedBuilder0.setDefaultServer(null);
        testbedBuilder1.setDefaultServer(null);
        testbedBuilder2.setDefaultServer(null);
        testbedBuilder0.setServerBuilders(Arrays.asList(serverBuilder0));
        testbedBuilder1.setServerBuilders(Arrays.asList(serverBuilder1));
        testbedBuilder2.setServerBuilders(Arrays.asList(serverBuilder2));
        testbedBuilder0.setDefaultServerBuilder(serverBuilder0);
        testbedBuilder1.setDefaultServerBuilder(serverBuilder1);
        testbedBuilder2.setDefaultServerBuilder(serverBuilder2);
        testbedBuilder0.addProxyBuilder(new ProxyBuilder((Proxy)testbedBuilder0.getProxies().get(0)));
        testbedBuilder0.setProxies(null);
        serverBuilder0.setDefaultAMService(null);
        serverBuilder1.setDefaultAMService(null);
        serverBuilder0.setServiceBuilders(Arrays.asList(serviceBuilder0, serviceBuilder1, serviceBuilder2, serviceBuilder3));
        serverBuilder1.setServiceBuilders(Arrays.asList(serviceBuilder4, serviceBuilder5));
        serverBuilder0.setDefaultAMServiceBuilder(serviceBuilder3);
        serverBuilder0.setDefaultComponentManagerUrn(serviceBuilder3.getUrn());
        serverBuilder1.setDefaultAMServiceBuilder(serviceBuilder5);
        serverBuilder1.setDefaultComponentManagerUrn(serviceBuilder5.getUrn());
        testbedBuilder0.setDefaultComponentManagerUrn(testbedBuilder0.getDefaultServerBuilder().getDefaultComponentManagerUrn());
        testbedBuilder1.setDefaultComponentManagerUrn(testbedBuilder1.getDefaultServerBuilder().getDefaultComponentManagerUrn());
        if (setUri) {
            try {
                UriTool uriTool = this.jsonLdObjectsMetaData.makeUriTool(uriBase, (UriTool.DerivedUriGenerator)new SearchUriGenerator());
                organisationTestCollection.setUri(setUriIndex, uriTool);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Should not happen", e);
            }
        }
        Organisation newOrg0 = orgBuilder0.create();
        Organisation newOrg1 = orgBuilder1.create();
        Testbed newTestbed0 = (Testbed)newOrg0.getTestbeds().get(0);
        Testbed newTestbed1 = (Testbed)newOrg1.getTestbeds().get(0);
        Testbed newTestbed2 = (Testbed)newOrg0.getTestbeds().get(1);
        Server newServer0 = (Server)newTestbed0.getServers().get(0);
        Server newServer1 = (Server)newTestbed1.getServers().get(0);
        Server newServer2 = (Server)newTestbed2.getServers().get(0);
        Service newService0 = (Service)newServer0.getServices().get(0);
        Service newService1 = (Service)newServer0.getServices().get(1);
        Service newService2 = (Service)newServer0.getServices().get(2);
        Service newService3 = (Service)newServer0.getServices().get(3);
        Service newService4 = (Service)newServer1.getServices().get(0);
        Service newService5 = (Service)newServer1.getServices().get(1);
        assert (newOrg0.getTestbeds().size() == 2);
        assert (newOrg1.getTestbeds().size() == 1);
        this.organisations = new ArrayList<Organisation>();
        this.testbeds = new ArrayList<Testbed>();
        this.servers = new ArrayList<Server>();
        this.services = new ArrayList<Service>();
        this.organisations.addAll(Arrays.asList(newOrg0, newOrg1));
        this.testbeds.addAll(Arrays.asList(newTestbed0, newTestbed1, newTestbed2));
        this.servers.addAll(Arrays.asList(newServer0, newServer1, newServer2));
        this.services.addAll(Arrays.asList(newService0, newService1, newService2, newService3, newService4, newService5));
    }

    public Organisation getOrganisationByIndex(int index) {
        return this.organisations.get(index);
    }

    public Organisation getOrganisationById(String id) {
        for (Organisation t : this.organisations) {
            if (t.getId() == null || !((String)t.getId()).equals(id)) continue;
            return t;
        }
        return null;
    }

    public Testbed getTestbedByIndex(int index) {
        return this.testbeds.get(index);
    }

    public Testbed getTestbedById(String id) {
        for (Testbed t : this.testbeds) {
            if (t.getId() == null || !((String)t.getId()).equals(id)) continue;
            return t;
        }
        return null;
    }

    public Server getServerByIndex(int index) {
        return this.servers.get(index);
    }

    public Server getServerById(String id) {
        for (Server t : this.servers) {
            if (t.getId() == null || !((Integer)t.getId()).equals(id)) continue;
            return t;
        }
        return null;
    }

    public Service getServiceByIndex(int index) {
        return this.services.get(index);
    }

    public Service getServiceById(String id) {
        for (Service t : this.services) {
            if (t.getId() == null || !((Integer)t.getId()).equals(id)) continue;
            return t;
        }
        return null;
    }

    public int getAllOrganisationsSize() {
        return this.organisations.size();
    }

    public int getAllTestbedsSize() {
        return this.testbeds.size();
    }

    public int getAllServersSize() {
        return this.servers.size();
    }

    public int getAllServicesSize() {
        return this.services.size();
    }

    public List<Organisation> getOrganisations() {
        return this.organisations;
    }

    public List<Testbed> getTestbeds() {
        return this.testbeds;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public String getOrganisationFixture(int index) {
        return "fixtures/embedded-organisation-" + index + ".json";
    }

    public String getTestbedFixture(int index) {
        return "fixtures/embedded-testbed-" + index + ".json";
    }
}

