/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LogBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.LogResource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.LogTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ResultTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TaskTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.Timestamp;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(LogIntegrationTest.class);
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static LogTestCollection logTestCollection;
    private static TaskTestCollection taskTestCollection;
    private static ResultTestCollection resultTestCollection;
    protected static Clock.DefaultTestTimeProvider timeProvider;
    private static FedmonTestPostgresDB testPostgresDB;
    Client client;

    @BeforeClass
    public static void setUp() throws Exception {
        LogIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        ((FedmonWebApiServiceConfiguration)RULE.getConfiguration()).setBaseUrl(String.format("http://localhost:%d/", RULE.getLocalPort()));
        timeProvider = new Clock.DefaultTestTimeProvider();
        Clock.set((Clock.CurrentTimeProvider)timeProvider);
        Clock.lockProvider();
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        logTestCollection = new LogTestCollection();
        resultTestCollection = new ResultTestCollection(true);
        taskTestCollection = new TaskTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        assert (testPostgresDB != null);
        testPostgresDB.close();
        Clock.reset();
    }

    @Before
    public void initClient() throws Exception {
        this.client = new JerseyClientBuilder().build();
        timeProvider.setNowOffsetMinutes(0L);
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.refillDB();
        testPostgresDB.close();
    }

    public Log createLogCall(String name, Long taskId, Long resultId, Timestamp startTime, Boolean live, Log.LogMediaType mediaType) throws Exception, CallFailedException {
        WebTarget w = this.client.target(String.format("http://localhost:%d/log/", RULE.getLocalPort()));
        LogBuilder logBuilder = new LogBuilder().setName(name).setLive(live).setMediaType(mediaType).setResultId(resultId).setTaskId(taskId).setStartTime(startTime);
        Log res = (Log)w.request().accept(new String[]{"application/json"}).post(Entity.json((Object)logBuilder.create()), Log.class);
        return res;
    }

    public void appendStringContentCall(Log log, String content) throws Exception, CallFailedException {
        assert (log.getContent() != null);
        Response r = this.client.target(log.getContent()).request().post(Entity.entity((Object)content, (MediaType)LogResource.logMediaTypeToJerseyMediaType((Log.LogMediaType)log.getMediaType())));
        if (r.getStatus() < 200 || r.getStatus() >= 300) {
            throw new CallFailedException("Call went wrong: " + r.getStatus() + " " + r);
        }
    }

    public void appendContentCall(Log log, byte[] content, Log.LogMediaType overrideMediaType) throws Exception, CallFailedException {
        assert (log.getContent() != null);
        Response r = this.client.target(log.getContent()).request().post(Entity.entity((Object)content, (MediaType)(overrideMediaType != null ? LogResource.logMediaTypeToJerseyMediaType((Log.LogMediaType)overrideMediaType) : LogResource.logMediaTypeToJerseyMediaType((Log.LogMediaType)log.getMediaType()))));
        if (r.getStatus() < 200 || r.getStatus() >= 300) {
            throw new CallFailedException("Call went wrong: " + r.getStatus() + " " + r);
        }
    }

    public void updateLogCall(Log updatedLog) throws Exception, CallFailedException {
        Response r = this.client.target(String.format("http://localhost:%d/log/%d/", RULE.getLocalPort(), updatedLog.getId())).request().put(Entity.entity((Object)updatedLog, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        if (r.getStatus() < 200 || r.getStatus() >= 300) {
            throw new CallFailedException("Call went wrong: " + r.getStatus() + " " + r);
        }
    }

    public Log getLogCall(Long logId) throws Exception, CallFailedException {
        return (Log)this.client.target(String.format("http://localhost:%d/log/%d", RULE.getLocalPort(), logId)).request().get(Log.class);
    }

    public String getLogStringContentCall(Log log) throws Exception, CallFailedException {
        assert (log.getContent() != null);
        return (String)this.client.target(log.getContent()).request().get(String.class);
    }

    public byte[] getLogContentCall(Log log) throws Exception, CallFailedException {
        assert (log.getContent() != null);
        return (byte[])this.client.target(log.getContent()).request().accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).get(byte[].class);
    }

    public void testLookup(Log expected, long id) throws Exception {
        Log actual = this.getLogCall(id);
        this.checkLookup(expected, actual);
    }

    public void checkLookup(Log expected, Log actual) {
        logTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, true);
    }

    @Test
    public void lookup0() throws Exception {
        Log expected = (Log)logTestCollection.getByIndex(0);
        this.testLookup(expected, (Long)expected.getId());
    }

    @Test
    public void lookup1() throws Exception {
        Log expected = (Log)logTestCollection.getByIndex(1);
        this.testLookup(expected, (Long)expected.getId());
    }

    public void testLookupContent(Log log, String expectedStringContent) throws Exception {
        Log lookedUpLog = this.getLogCall((Long)log.getId());
        LOG.debug("testLookupContent for log with content URI: " + lookedUpLog.getContent());
        String actualStringContent = this.getLogStringContentCall(lookedUpLog);
        if (expectedStringContent != null) {
            MatcherAssert.assertThat((Object)actualStringContent, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedStringContent)));
        } else {
            MatcherAssert.assertThat((Object)actualStringContent, (Matcher)Matchers.is((Matcher)Matchers.anyOf((Matcher)Matchers.nullValue(), (Matcher)Matchers.equalTo((Object)""))));
        }
    }

    public void testLookupContent(Log log, byte[] expectedContent) throws Exception {
        Log lookedUpLog = this.getLogCall((Long)log.getId());
        LOG.debug("testLookupContent for log with content URI: " + lookedUpLog.getContent());
        byte[] actualContent = this.getLogContentCall(lookedUpLog);
        if (expectedContent != null) {
            MatcherAssert.assertThat((Object)actualContent, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedContent)));
        } else {
            MatcherAssert.assertThat((Object)actualContent, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    @Test
    public void lookupContent0() throws Exception {
        Log log = (Log)logTestCollection.getByIndex(0);
        String expected = logTestCollection.getContent0();
        this.testLookupContent(log, expected);
    }

    @Test
    public void lookupContent1() throws Exception {
        Log log = (Log)logTestCollection.getByIndex(1);
        this.testLookupContent(log, (String)null);
    }

    @Test
    public void lookupContent2() throws Exception {
        Log log = (Log)logTestCollection.getByIndex(2);
        this.testLookupContent(log, logTestCollection.getContent2());
    }

    private void checkAppendedLog(Log log) throws Exception {
        Log currentLog = this.getLogCall((Long)log.getId());
        if (log.isLive().booleanValue()) {
            MatcherAssert.assertThat((Object)currentLog.isComplete(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)currentLog.getStopTime(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        } else {
            MatcherAssert.assertThat((Object)currentLog.isComplete(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)currentLog.getStopTime(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        }
    }

    @Test(expected=CallFailedException.class)
    public void testAppendContent1fail() throws Exception {
        Log log = (Log)logTestCollection.getByIndex(0);
        String orig = logTestCollection.getContent0();
        String additional = "test 1 2 3\ntest!\n";
        Log lookedUpLog = this.getLogCall((Long)log.getId());
        LOG.debug("appending string content to log with content URI: " + lookedUpLog.getContent());
        this.appendStringContentCall(lookedUpLog, additional);
        String expected = orig;
        this.testLookupContent(lookedUpLog, expected);
    }

    @Test
    public void testChangeForTest() throws Exception {
        testPostgresDB.executeStatement("UPDATE log SET complete=false,stop=NULL WHERE id=0");
        Log actual = this.getLogCall(0L);
        MatcherAssert.assertThat((Object)actual.getComplete(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)actual.getStopTime(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testNoChangeForTest() throws Exception {
        Log actual = this.getLogCall(0L);
        MatcherAssert.assertThat((Object)actual.getComplete(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)actual.getStopTime(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testAppendContent0() throws Exception {
        testPostgresDB.executeStatement("UPDATE log SET complete=false,stop=NULL WHERE id=0");
        Log log = (Log)logTestCollection.getByIndex(0);
        String orig = logTestCollection.getContent0();
        String additional = "test 1 2 3\ntest!\n";
        Log lookedUpLog = this.getLogCall((Long)log.getId());
        LOG.debug("appending string content to log with content URI: " + lookedUpLog.getContent());
        this.appendStringContentCall(lookedUpLog, additional);
        String expected = orig + additional;
        this.testLookupContent(lookedUpLog, expected);
        this.checkAppendedLog(lookedUpLog);
    }

    @Test
    public void testAppendContent1() throws Exception {
        Log log = (Log)logTestCollection.getByIndex(1);
        String additional = "{\n  \"test\": \"ok\"\n}\n";
        Log lookedUpLog = this.getLogCall((Long)log.getId());
        LOG.debug("appending string content to log with content URI: " + lookedUpLog.getContent());
        this.appendStringContentCall(lookedUpLog, additional);
        String expected = additional;
        this.testLookupContent(lookedUpLog, expected);
        this.checkAppendedLog(lookedUpLog);
    }

    @Test(expected=CallFailedException.class)
    public void testAppendContent1FailWrongType() throws Exception {
        Log log = (Log)logTestCollection.getByIndex(1);
        byte[] bad = new byte[]{5, 15};
        Log lookedUpLog = this.getLogCall((Long)log.getId());
        LOG.debug("appending string content to log with content URI: " + lookedUpLog.getContent());
        this.appendContentCall(lookedUpLog, bad, Log.LogMediaType.BINARY);
        String expected = null;
        this.testLookupContent(lookedUpLog, expected);
    }

    @Test
    public void testAppendContent2() throws Exception {
        Log log = (Log)logTestCollection.getByIndex(2);
        byte[] orig = logTestCollection.getContent2();
        byte[] additional = new byte[]{50, 60, 70};
        Log lookedUpLog = this.getLogCall((Long)log.getId());
        LOG.debug("appending string content to log with content URI: " + lookedUpLog.getContent());
        this.appendContentCall(lookedUpLog, additional, null);
        byte[] expected = new byte[]{0, 2, 4, 6, 8, 50, 60, 70};
        this.testLookupContent(lookedUpLog, expected);
        this.checkAppendedLog(lookedUpLog);
    }

    @Test
    public void testCreateLog() throws Exception {
        LogBuilder expected = new LogBuilder();
        expected.setMediaType(Log.LogMediaType.JSON);
        expected.setLive(Boolean.valueOf(false));
        expected.setComplete(null);
        expected.setName("createdForTest.html");
        Log createdLog = this.createLogCall(expected.getName(), expected.getTaskId(), expected.getResultId(), expected.getStartTime(), expected.getLive(), expected.getMediaType());
        expected.setStartTime(timeProvider.nowTimestamp());
        expected.setComplete(Boolean.valueOf(false));
        expected.setSize(Long.valueOf(0L));
        MatcherAssert.assertThat((Object)createdLog, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Long)createdLog.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)createdLog.getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)createdLog.getContent(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        expected.setId((Object)((Long)createdLog.getId()));
        logTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)createdLog, (JsonLdObjectWithId)expected.create(), true);
    }

    @Test
    public void testUpdateLog0() throws Exception {
        testPostgresDB.executeStatement("UPDATE log SET complete=false,stop=NULL WHERE id=0");
        Log log = (Log)logTestCollection.getByIndex(0);
        Log serverLog = this.getLogCall((Long)log.getId());
        timeProvider.relativeNowOffsetMinutes(5L);
        LogBuilder logBuilder = new LogBuilder(serverLog).setComplete(Boolean.valueOf(true)).setStopTime(timeProvider.nowTimestamp());
        this.updateLogCall(logBuilder.create());
        this.testLookup(logBuilder.create(), (Long)log.getId());
    }

    @Test
    public void testUpdateLog1() throws Exception {
        Log log = (Log)logTestCollection.getByIndex(2);
        Log serverLog = this.getLogCall((Long)log.getId());
        timeProvider.relativeNowOffsetMinutes(5L);
        LogBuilder logBuilder = new LogBuilder(serverLog).setComplete(Boolean.valueOf(true)).setStopTime(timeProvider.nowTimestamp()).setTask((Task)taskTestCollection.getByIndex(0)).setResult((Result)resultTestCollection.getByIndex(0));
        this.updateLogCall(logBuilder.create());
        this.testLookup(logBuilder.create(), (Long)log.getId());
    }

    public static class CallFailedException
    extends Exception {
        public CallFailedException() {
        }

        public CallFailedException(String message) {
            super(message);
        }

        public CallFailedException(String message, Throwable cause) {
            super(message, cause);
        }

        public CallFailedException(Throwable cause) {
            super(cause);
        }

        public CallFailedException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

