/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LogBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ResultTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TaskTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestClock;
import be.iminds.ilabt.util.jsonld.UriTool;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import be.iminds.ilabt.util.jsonld.test.ObjectWithIdTestCollection;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class LogTestCollection
extends ObjectWithIdTestCollection<Long, Log, LogBuilder> {
    private final String content1;

    public LogTestCollection() {
        super(Long.class, Log.class, LogBuilder.class);
        ResultTestCollection resultTestCollection = new ResultTestCollection(true);
        TaskTestCollection taskTestCollection = new TaskTestCollection();
        this.content1 = "This is the test content of log 1\nOne more line.\n";
        LogBuilder log0 = new LogBuilder();
        log0.setId((Object)0L);
        log0.setName("example.txt");
        log0.setComplete(Boolean.valueOf(true));
        log0.setLive(Boolean.valueOf(true));
        log0.setSize(Long.valueOf((long)this.content1.length() + 0L));
        log0.setStartTime(TestClock.get().getOffsetMinutes(1L));
        log0.setStopTime(TestClock.get().getOffsetMinutes(10L));
        log0.setResult((Result)resultTestCollection.getById(1L));
        log0.setTask((Task)taskTestCollection.getById(1L));
        log0.setMediaType(Log.LogMediaType.TEXT);
        this.all.add(log0);
        LogBuilder log1 = new LogBuilder();
        log1.setId((Object)1L);
        log1.setName("data.json");
        log1.setComplete(Boolean.valueOf(false));
        log1.setLive(Boolean.valueOf(false));
        log1.setSize(Long.valueOf(0L));
        log1.setStartTime(TestClock.get().getOffsetMinutes(11L));
        log1.setStopTime(null);
        log1.setResult(null);
        log1.setTask(null);
        log1.setMediaType(Log.LogMediaType.JSON);
        this.all.add(log1);
        LogBuilder log2 = new LogBuilder();
        log2.setId((Object)2L);
        log2.setName("log.bin");
        log2.setComplete(Boolean.valueOf(false));
        log2.setLive(Boolean.valueOf(false));
        log2.setSize(Long.valueOf(5L));
        log2.setStartTime(TestClock.get().getOffsetMinutes(18L));
        log2.setStopTime(null);
        log2.setResult(null);
        log2.setTask(null);
        log2.setMediaType(Log.LogMediaType.BINARY);
        this.all.add(log2);
    }

    public String getContent0() {
        return this.content1;
    }

    public byte[] getContent2() {
        byte[] res = new byte[]{0, 2, 4, 6, 8};
        return res;
    }

    public void setUri(int index, UriTool uriTool) throws URISyntaxException {
        super.setUri(index, uriTool);
        LogBuilder orig = (LogBuilder)this.all.get(index);
        LogBuilder updated = orig.setContent(new URI(orig.getUri().toASCIIString() + "/content"));
        this.all.set(index, updated);
    }

    public void assertSameExtraIds(Log actual, Log expected) {
    }

    public void assertSameDetails(Log actual, Log expected) {
        MatcherAssert.assertThat((String)"complete differs", (Object)actual.getComplete(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getComplete())));
        MatcherAssert.assertThat((String)"name differs", (Object)actual.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getName())));
        MatcherAssert.assertThat((String)"live differs", (Object)actual.getLive(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getLive())));
        MatcherAssert.assertThat((String)"size differs", (Object)actual.getSize(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getSize())));
        MatcherAssert.assertThat((String)"start differs", (Object)actual.getStartTime(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getStartTime())));
        MatcherAssert.assertThat((String)"stop differs", (Object)actual.getStopTime(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getStopTime())));
        MatcherAssert.assertThat((String)"media type differs", (Object)actual.getMediaType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getMediaType())));
    }

    public void assertSearchLinks(Log actual) {
    }

    public void assertSame(Log actual, Log expected, CommonTest.ComparePrecision base, @Nullable CommonTest.ComparePrecision references) {
        super.assertSame((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, base, references);
        if (base != null && base.mustExpectActualHasUri()) {
            MatcherAssert.assertThat((Object)actual.getContent(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)actual.getContent().getPath(), (Matcher)Matchers.endsWith((String)"/content"));
        }
    }
}

