/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ResourceTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class ResourceIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected static ResourceTestCollection resourceTestCollection;
    protected JerseyClient client;

    @BeforeClass
    public static void setUp() throws Exception {
        ResourceIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
        resourceTestCollection = new ResourceTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
    }

    public void testLookupAll(List<Resource> expected) throws Exception {
        List<Resource> actual = this.doLookupAll();
        this.checkLookupList(expected, actual);
    }

    public void testLookupByServerId(Integer serverId) throws Exception {
        List<Resource> expected = resourceTestCollection.getAll().stream().filter(r -> r.getServerId() == serverId).collect(Collectors.toList());
        List<Resource> actual = this.doLookupByServerId(serverId);
        this.checkLookupList(expected, actual);
    }

    public void testLookupById(Resource expected) throws Exception {
        Resource actual = this.doLookupById((Integer)expected.getId());
        this.checkLookupSingle(expected, actual);
    }

    public List<Resource> doLookupAll() throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/resource/", RULE.getLocalPort()));
        List actual = (List)query.request().get((GenericType)new GenericType<List<Resource>>(){});
        System.out.println("Got result Resource: " + actual);
        return actual;
    }

    public Resource doLookupById(Integer id) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/resource/" + id, RULE.getLocalPort()));
        Resource actual = (Resource)query.request().get(Resource.class);
        System.out.println("Got result Resource: " + actual);
        return actual;
    }

    public List<Resource> doLookupByServerId(Integer serverId) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/resource/?serverId=" + serverId, RULE.getLocalPort()));
        List actual = (List)query.request().get((GenericType)new GenericType<List<Resource>>(){});
        System.out.println("Got result Resource: " + actual);
        return actual;
    }

    public void checkLookupList(List<Resource> expected, List<Resource> actual) {
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasSize((int)expected.size()));
        for (Resource ex : expected) {
            boolean found = false;
            for (Resource ac : actual) {
                if (!Objects.equals(ac.getId(), ex.getId())) continue;
                resourceTestCollection.assertSame((JsonLdObjectWithId)ac, (JsonLdObjectWithId)ex, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.IGNORE_COMPLETELY);
                MatcherAssert.assertThat((Object)ex.getServerId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ac.getServerId())));
                found = true;
            }
            MatcherAssert.assertThat((String)("Expected Resource not found in result: " + ex), (Object)found, (Matcher)Matchers.is((Object)true));
        }
    }

    public void checkLookupSingle(Resource expected, Resource actual) {
        resourceTestCollection.assertSame((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.IGNORE_COMPLETELY);
        MatcherAssert.assertThat((Object)expected.getServerId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)actual.getServerId())));
    }

    @Test
    public void lookupAll() throws Exception {
        List expected = resourceTestCollection.getAll();
        this.testLookupAll(expected);
    }

    @Test
    public void lookupByServerId0() throws Exception {
        Resource expected = (Resource)resourceTestCollection.getByIndex(0);
        this.testLookupByServerId(expected.getServerId());
    }

    @Test
    public void lookupByServerId1() throws Exception {
        Resource expected = (Resource)resourceTestCollection.getByIndex(1);
        this.testLookupByServerId(expected.getServerId());
    }

    @Test
    public void lookupByServerId2() throws Exception {
        Resource expected = (Resource)resourceTestCollection.getByIndex(2);
        this.testLookupByServerId(expected.getServerId());
    }

    @Test
    public void lookupByServerId3() throws Exception {
        Resource expected = (Resource)resourceTestCollection.getByIndex(3);
        this.testLookupByServerId(expected.getServerId());
    }

    @Test
    public void lookupById0() throws Exception {
        Resource expected = (Resource)resourceTestCollection.getByIndex(0);
        this.testLookupById(expected);
    }

    @Test
    public void lookupById1() throws Exception {
        Resource expected = (Resource)resourceTestCollection.getByIndex(1);
        this.testLookupById(expected);
    }

    @Test
    public void lookupById2() throws Exception {
        Resource expected = (Resource)resourceTestCollection.getByIndex(2);
        this.testLookupById(expected);
    }

    @Test
    public void lookupById3() throws Exception {
        Resource expected = (Resource)resourceTestCollection.getByIndex(3);
        this.testLookupById(expected);
    }
}

