/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestClock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestDefinitionsTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestInstancesTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.test.ObjectWithIdTestCollection;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.dropwizard.jackson.Jackson;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class ResultTestCollection
extends ObjectWithIdTestCollection<Long, Result, ResultBuilder> {
    private final TestbedTestCollection testbedTestCollection;
    private final TestInstancesTestCollection testInstancesTestCollection;
    private final TestDefinitionsTestCollection testDefinitionsTestCollection;
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private boolean linkTasks;

    private static Map<Object, Object> makeMap(Object key, Object value) {
        HashMap<Object, Object> res = new HashMap<Object, Object>();
        res.put(key, value);
        return res;
    }

    private static Map<Object, Object> makeMap(Object key1, Object value1, Object key2, Object value2) {
        HashMap<Object, Object> res = new HashMap<Object, Object>();
        res.put(key1, value1);
        res.put(key2, value2);
        return res;
    }

    public ResultTestCollection() {
        this(true);
    }

    public ResultTestCollection(boolean linkTasks) {
        super(Long.class, Result.class, ResultBuilder.class);
        this.linkTasks = linkTasks;
        this.testInstancesTestCollection = new TestInstancesTestCollection();
        this.testbedTestCollection = new TestbedTestCollection();
        this.testDefinitionsTestCollection = new TestDefinitionsTestCollection();
        Long id = 1L;
        Integer testinstanceid = 9;
        TestInstance ti = (TestInstance)this.testInstancesTestCollection.getByIndex(0);
        TestDefinition td = (TestDefinition)this.testDefinitionsTestCollection.getById(ti.getTestDefinitionId());
        assert (((Integer)ti.getId()).equals(testinstanceid));
        assert (td != null);
        assert (((String)td.getId()).equals(ti.getTestDefinitionId()));
        Long taskid = null;
        Timestamp timestamp = TestClock.get().getBase();
        Timestamp expire = TestClock.get().getOffsetMinutes(20L);
        String logFile = "/log/result/" + id;
        String logUrl = "http://localhost/results/log/result/" + id;
        String summary = "SUCCESS";
        HashMap<String, Object> subResults = new HashMap<String, Object>();
        subResults.put("subres1", "1");
        subResults.put("subres2", "2");
        ResultBuilder result = ((ResultBuilder)new ResultBuilder().setId((Object)id)).setTask(linkTasks ? taskid : null, null).setCreated(timestamp).setExpire(expire).setLogFile(logFile).setLogUrl(logUrl).setSummary(summary).setResults(subResults).setTestInstance(new TestInstanceBuilder(ti).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY)).setTestDefinition(new TestDefinitionBuilder(td).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY));
        this.all.add(result);
        id = 2L;
        testinstanceid = 10;
        ti = (TestInstance)this.testInstancesTestCollection.getById(testinstanceid);
        td = (TestDefinition)this.testDefinitionsTestCollection.getById(ti.getTestDefinitionId());
        timestamp = TestClock.get().getOffsetMinutes(-10L);
        expire = TestClock.get().getOffsetMinutes(1L);
        taskid = 3L;
        logFile = "/log/result/" + id;
        logUrl = "http://localhost/results/log/result/" + id;
        summary = "FAILURE";
        subResults = new HashMap();
        subResults.put("subres1", "1b");
        subResults.put("subresLong1", 1L);
        subResults.put("subresInt2", 2);
        subResults.put("subresNest3", ResultTestCollection.makeMap("SUB3", 3));
        subResults.put("subresNest4", ResultTestCollection.makeMap("SUB4a", ResultTestCollection.makeMap("SUB4aSUB", "deep"), "SUB4b", Arrays.asList(4, "four")));
        subResults.put("subresList5", Arrays.asList(5, "five"));
        result = ((ResultBuilder)new ResultBuilder().setId((Object)id)).setTask(linkTasks ? taskid : null, null).setCreated(timestamp).setExpire(expire).setLogFile(logFile).setLogUrl(logUrl).setSummary(summary).setResults(subResults).setTestInstance(new TestInstanceBuilder(ti).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY)).setTestDefinition(new TestDefinitionBuilder(td).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY));
        this.all.add(result);
        id = 3L;
        testinstanceid = 11;
        ti = (TestInstance)this.testInstancesTestCollection.getById(testinstanceid);
        td = (TestDefinition)this.testDefinitionsTestCollection.getById(ti.getTestDefinitionId());
        timestamp = TestClock.get().getOffsetMinutes(-10L);
        expire = TestClock.get().getOffsetMinutes(1L);
        taskid = null;
        logFile = "/log/result/" + id;
        logUrl = "http://localhost/results/log/result/" + id;
        summary = "WARNING";
        subResults = new HashMap();
        subResults.put("subres1", "1d");
        subResults.put("subres2", "2d");
        result = ((ResultBuilder)new ResultBuilder().setId((Object)id)).setTask(linkTasks ? taskid : null, null).setCreated(timestamp).setExpire(expire).setLogFile(logFile).setLogUrl(logUrl).setSummary(summary).setResults(subResults).setTestInstance(new TestInstanceBuilder(ti).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY)).setTestDefinition(new TestDefinitionBuilder(td).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY));
        this.all.add(result);
        id = 4L;
        testinstanceid = 11;
        ti = (TestInstance)this.testInstancesTestCollection.getById(testinstanceid);
        td = (TestDefinition)this.testDefinitionsTestCollection.getById(ti.getTestDefinitionId());
        timestamp = TestClock.get().getBase();
        expire = TestClock.get().getOffsetMinutes(20L);
        taskid = null;
        logFile = "/log/result/" + id;
        logUrl = "http://localhost/results/log/result/" + id;
        summary = "CANCELLED";
        subResults = new HashMap();
        result = ((ResultBuilder)new ResultBuilder().setId((Object)id)).setTask(linkTasks ? taskid : null, null).setCreated(timestamp).setExpire(expire).setLogFile(logFile).setLogUrl(logUrl).setSummary(summary).setResults(subResults).setTestInstance(new TestInstanceBuilder(ti).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY)).setTestDefinition(new TestDefinitionBuilder(td).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY)).addSubResult("cancelled", (Object)"true");
        this.all.add(result);
        id = 5L;
        testinstanceid = 12;
        ti = (TestInstance)this.testInstancesTestCollection.getById(testinstanceid);
        td = (TestDefinition)this.testDefinitionsTestCollection.getById(ti.getTestDefinitionId());
        timestamp = TestClock.get().getOffsetMinutes(-2880L);
        expire = TestClock.get().getOffsetMinutes(-1420L);
        taskid = null;
        logFile = "/log/result/" + id;
        logUrl = "http://localhost/results/log/result/" + id;
        summary = "FAILURE";
        subResults = new HashMap();
        result = ((ResultBuilder)new ResultBuilder().setId((Object)id)).setTask(linkTasks ? taskid : null, null).setCreated(timestamp).setExpire(expire).setLogFile(logFile).setLogUrl(logUrl).setSummary(summary).setResults(subResults).setTestInstance(new TestInstanceBuilder(ti).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY)).setTestDefinition(new TestDefinitionBuilder(td).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY));
        this.all.add(result);
        id = 6L;
        testinstanceid = 12;
        ti = (TestInstance)this.testInstancesTestCollection.getById(testinstanceid);
        td = (TestDefinition)this.testDefinitionsTestCollection.getById(ti.getTestDefinitionId());
        timestamp = TestClock.get().getOffsetMinutes(-1440L);
        expire = TestClock.get().getOffsetMinutes(20L);
        taskid = null;
        logFile = "/log/result/" + id;
        logUrl = "http://localhost/results/log/result/" + id;
        summary = "WARNING";
        subResults = new HashMap();
        result = ((ResultBuilder)new ResultBuilder().setId((Object)id)).setTask(linkTasks ? taskid : null, null).setCreated(timestamp).setExpire(expire).setLogFile(logFile).setLogUrl(logUrl).setSummary(summary).setResults(subResults).setTestInstance(new TestInstanceBuilder(ti).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY)).setTestDefinition(new TestDefinitionBuilder(td).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY)).setResults(subResults);
        this.all.add(result);
        id = 7L;
        testinstanceid = 12;
        ti = (TestInstance)this.testInstancesTestCollection.getById(testinstanceid);
        td = (TestDefinition)this.testDefinitionsTestCollection.getById(ti.getTestDefinitionId());
        timestamp = TestClock.get().getBase();
        expire = TestClock.get().getOffsetMinutes(1460L);
        taskid = null;
        logFile = "/log/result/" + id;
        logUrl = "http://localhost/results/log/result/" + id;
        summary = "SUCCESS";
        subResults = new HashMap();
        result = ((ResultBuilder)new ResultBuilder().setId((Object)id)).setTask(linkTasks ? taskid : null, null).setCreated(timestamp).setExpire(expire).setLogFile(logFile).setLogUrl(logUrl).setSummary(summary).setResults(subResults).setTestInstance(new TestInstanceBuilder(ti).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY)).setTestDefinition(new TestDefinitionBuilder(td).createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY));
        this.all.add(result);
    }

    public ResultBuilder createNewResult(TestInstance testInstance, String summary) {
        Long taskid = null;
        Timestamp timestamp = Clock.nowTimestamp();
        Timestamp expire = new Timestamp(timestamp.getTime());
        String logFile = "/log/result/x";
        String logUrl = "http://localhost/results/log/result/x";
        HashMap<String, String> subResults = new HashMap<String, String>();
        subResults.put("subres1", "1n");
        subResults.put("subres2", "2n");
        return new ResultBuilder().setTask(this.linkTasks ? taskid : null, null).setCreated(timestamp).setExpire(expire).setLogFile(logFile).setLogUrl(logUrl).setSummary(summary).setResults(subResults).setTestInstance(testInstance);
    }

    public List<Result> getByTestInstanceIds(int ... ids) {
        ArrayList<Result> res = new ArrayList<Result>();
        for (int i = 0; i < ids.length; ++i) {
            int testInstanceId = ids[i];
            for (ResultBuilder r : this.all) {
                if (r.getTestInstanceId() != testInstanceId) continue;
                res.add(r.create());
            }
        }
        return res;
    }

    public List<Result> getLastByTestInstanceIds(int ... ids) {
        ArrayList<Result> res = new ArrayList<Result>();
        for (int i = 0; i < ids.length; ++i) {
            int testInstanceId = ids[i];
            for (ResultBuilder r : this.all) {
                if (Arrays.asList(3L, 5L, 6L).contains(r.getId()) || r.getTestInstanceId() != testInstanceId) continue;
                res.add(r.create());
            }
        }
        return res;
    }

    public void assertSameExtraIds(Result actual, Result expected) {
    }

    public void assertSameDetails(Result actual, Result expected) {
        MatcherAssert.assertThat((String)"timestamp differs", (Object)actual.getCreated(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getCreated())));
        MatcherAssert.assertThat((String)"expire differs", (Object)actual.getExpire(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getExpire())));
        MatcherAssert.assertThat((Object)actual.getLogFile(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getLogFile())));
        MatcherAssert.assertThat((Object)actual.getLogUrl(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getLogUrl())));
        MatcherAssert.assertThat((Object)actual.getSummary(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getSummary())));
        MatcherAssert.assertThat((Object)actual.getTestInstanceId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getTestInstanceId())));
        MatcherAssert.assertThat((String)"sub results differ", (Object)(actual.getResults() == null ? 1 : 0), (Matcher)Matchers.is((Object)(expected.getResults() == null ? 1 : 0)));
        if (actual.getResults() != null) {
            try {
                String actualJsonSubResultString = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)actual.getResults());
                String expectedJsonSubResultString = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)expected.getResults());
                ObjectNode actualJsonSubResultObjectNode = (ObjectNode)MAPPER.readValue(actualJsonSubResultString, ObjectNode.class);
                ObjectNode expectedJsonSubResultObjectNode = (ObjectNode)MAPPER.readValue(actualJsonSubResultString, ObjectNode.class);
                MatcherAssert.assertThat((String)"sub results differ", (Object)actualJsonSubResultObjectNode, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedJsonSubResultObjectNode)));
            }
            catch (Exception e) {
                throw new AssertionError("Unexpected: Json error while asserting equality of sub results  (bug in ResultTestcollection.assertSameDetails?)", e);
            }
        }
        if (this.linkTasks) {
            MatcherAssert.assertThat((String)"taskid differs", (Object)actual.getTaskId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getTaskId())));
        }
        MatcherAssert.assertThat((Object)actual.getClassName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getClassName())));
    }

    public void assertSearchLinks(Result actual) {
    }
}

