/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.RootResource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class RootIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected JerseyClient client;

    @BeforeClass
    public static void setUp() throws Exception {
        RootIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        ((FedmonWebApiServiceConfiguration)RULE.getConfiguration()).setBaseUrl(String.format("http://localhost:%d/", RULE.getLocalPort()));
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
    }

    public void testLookup() throws Exception {
        RootResource.Root actual = this.doLookup();
        this.checkLookup(actual);
    }

    public RootResource.Root doLookup() throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/", RULE.getLocalPort()));
        RootResource.Root actual = (RootResource.Root)query.request().get(RootResource.Root.class);
        System.out.println("Got result Root: " + actual);
        return actual;
    }

    public void checkLookup(RootResource.Root actual) {
        System.out.print("actual=" + actual);
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)actual.getAdmin(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)actual.getOrganisations(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)actual.getResults(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)actual.getTasks(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)actual.getTestbeds(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)actual.getTestDefinitions(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)actual.getTestInstances(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void lookup() throws Exception {
        this.testLookup();
    }
}

