/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.MaintenanceInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpse;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServerGlimpseTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServerTestCollection;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class ServerGlimpseIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected static ServerGlimpseTestCollection serverGlimpseTestCollection;
    protected static ServerTestCollection serverTestCollection;
    protected JerseyClient client;
    private static FedmonTestPostgresDB testPostgresDB;
    public static DropwizardAppRule<FedmonWebApiServiceConfiguration> usedRule;

    @BeforeClass
    public static void setUp() throws Exception {
        ServerGlimpseIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        usedRule = RULE;
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        serverGlimpseTestCollection = new ServerGlimpseTestCollection();
        serverTestCollection = new ServerTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
        assert (testPostgresDB != null);
        testPostgresDB.close();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        ((FedmonWebApiServiceApplication)usedRule.getApplication()).getSharedResourceCache().invalidateFull();
    }

    public List<ServerGlimpse> testSearch(List<ServerGlimpse> expected) throws Exception {
        List<ServerGlimpse> actual = this.doSearch();
        this.checkSearch(expected, actual);
        return actual;
    }

    public List<ServerGlimpse> doSearch() throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/serverglimpse/", RULE.getLocalPort()));
        List actual = (List)query.request().accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<ServerGlimpse>>(){});
        System.out.println("Got " + actual.size() + " serverGlimpses. Server ID's: " + actual.stream().map(ServerGlimpse::getServerId).collect(Collectors.toList()));
        return actual;
    }

    public void checkSearch(List<ServerGlimpse> expected, List<ServerGlimpse> actual) {
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasSize((int)expected.size()));
        for (ServerGlimpse ex : expected) {
            assert (ex.getServerId() != null);
            ServerGlimpse ac = ServerGlimpseTestCollection.getByServerId(actual, ex.getServerId());
            MatcherAssert.assertThat((String)("Expected serverId " + ex.getServerId() + " not found in result"), (Object)ac, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            serverGlimpseTestCollection.assertSame((JsonLdObject)ac, (JsonLdObject)ex, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_ONLY);
        }
    }

    public void testLookup(ServerGlimpse expected, Integer serverId) throws Exception {
        ServerGlimpse actual = this.doLookup(serverId);
        this.checkLookup(expected, actual);
    }

    public ServerGlimpse doLookup(Integer serverId) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/serverglimpse/" + serverId, RULE.getLocalPort()));
        ServerGlimpse actual = (ServerGlimpse)query.request().get(ServerGlimpse.class);
        System.out.println("Got result ServerGlimpse. len=" + actual);
        return actual;
    }

    public void checkLookup(ServerGlimpse expected, ServerGlimpse actual) {
        serverGlimpseTestCollection.assertSame((JsonLdObject)actual, (JsonLdObject)expected, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_ONLY);
    }

    @Test
    public void lookup0() throws Exception {
        ServerGlimpse expected = (ServerGlimpse)serverGlimpseTestCollection.getByIndex(0);
        this.testLookup(expected, expected.getServerId());
    }

    @Test
    public void lookup1() throws Exception {
        ServerGlimpse expected = (ServerGlimpse)serverGlimpseTestCollection.getByIndex(1);
        this.testLookup(expected, expected.getServerId());
    }

    @Test
    public void searchAll() throws Exception {
        List expected = serverGlimpseTestCollection.getAll();
        this.testSearch(expected);
    }

    public boolean addMaintenanceCall(Integer serverId, MaintenanceInfo maintenanceInfo) throws Exception {
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/serverglimpse/" + serverId + "/maintenance/", RULE.getLocalPort()));
        Entity entity = Entity.entity((Object)maintenanceInfo, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        Response res = w.request().post(entity);
        return res.getStatus() == Response.Status.CREATED.getStatusCode();
    }

    public boolean replaceMaintenanceCall(Integer serverId, List<MaintenanceInfo> maintenanceInfos) throws Exception {
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/serverglimpse/" + serverId + "/maintenance/", RULE.getLocalPort()));
        Entity entity = Entity.entity(maintenanceInfos, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        Response res = w.request().put(entity);
        return res.getStatus() == Response.Status.NO_CONTENT.getStatusCode();
    }

    public ServerGlimpse upsertServerGlimpseCall(ServerGlimpse serverGlimpse) throws Exception {
        assert (serverGlimpse.getServerId() != null);
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/serverglimpse/" + serverGlimpse.getServerId(), RULE.getLocalPort()));
        Entity entity = Entity.entity((Object)serverGlimpse, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        ServerGlimpse res = (ServerGlimpse)w.request().put(entity, ServerGlimpse.class);
        return res;
    }

    public void deleteServerGlimpseCall(String id) throws Exception {
        this.client.target(String.format("http://localhost:%d/serverGlimpse/%s", RULE.getLocalPort(), id)).request().delete();
    }

    @Test
    public void testUpsertUpdate1() throws Exception {
        boolean changeAdvertisement = true;
        boolean changeHealth = true;
        boolean changeReputation = false;
        boolean changeMaintenance = false;
        ServerGlimpse updateServerGlimpse = serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        ServerGlimpse origBeforeUpdate = serverGlimpseTestCollection.getByServerId(updateServerGlimpse.getServerId());
        this.upsertServerGlimpseCall(updateServerGlimpse);
        ServerGlimpseBuilder expectedBuilder = new ServerGlimpseBuilder(updateServerGlimpse);
        if (!changeAdvertisement) {
            expectedBuilder.setAdvertisementInfo(origBeforeUpdate.getAdvertisementInfo());
        }
        if (!changeHealth) {
            expectedBuilder.setHealthInfo(origBeforeUpdate.getHealthInfo());
        }
        if (!changeReputation) {
            expectedBuilder.setReputation(origBeforeUpdate.getReputation());
        }
        if (!changeMaintenance) {
            expectedBuilder.setMaintenance(origBeforeUpdate.getMaintenance());
        }
        ServerGlimpse expectedServerGlimpse = expectedBuilder.create();
        ServerGlimpse lookedUpServerGlimpse = this.doLookup(updateServerGlimpse.getServerId());
        serverGlimpseTestCollection.assertSame((JsonLdObject)lookedUpServerGlimpse, (JsonLdObject)expectedServerGlimpse, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_ONLY);
    }

    @Test
    public void testUpsertUpdate2() throws Exception {
        boolean changeAdvertisement = true;
        boolean changeHealth = false;
        boolean changeReputation = false;
        boolean changeMaintenance = false;
        ServerGlimpse updateServerGlimpse = serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        ServerGlimpse origBeforeUpdate = serverGlimpseTestCollection.getByServerId(updateServerGlimpse.getServerId());
        this.upsertServerGlimpseCall(updateServerGlimpse);
        ServerGlimpseBuilder expectedBuilder = new ServerGlimpseBuilder(updateServerGlimpse);
        if (!changeAdvertisement) {
            expectedBuilder.setAdvertisementInfo(origBeforeUpdate.getAdvertisementInfo());
        }
        if (!changeHealth) {
            expectedBuilder.setHealthInfo(origBeforeUpdate.getHealthInfo());
        }
        if (!changeReputation) {
            expectedBuilder.setReputation(origBeforeUpdate.getReputation());
        }
        if (!changeMaintenance) {
            expectedBuilder.setMaintenance(origBeforeUpdate.getMaintenance());
        }
        ServerGlimpse expectedServerGlimpse = expectedBuilder.create();
        ServerGlimpse lookedUpServerGlimpse = this.doLookup(updateServerGlimpse.getServerId());
        serverGlimpseTestCollection.assertSame((JsonLdObject)lookedUpServerGlimpse, (JsonLdObject)expectedServerGlimpse, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_ONLY);
    }

    @Test
    public void testUpsertUpdate3() throws Exception {
        boolean changeAdvertisement = false;
        boolean changeHealth = true;
        boolean changeReputation = false;
        boolean changeMaintenance = false;
        ServerGlimpse updateServerGlimpse = serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        ServerGlimpse origBeforeUpdate = serverGlimpseTestCollection.getByServerId(updateServerGlimpse.getServerId());
        this.upsertServerGlimpseCall(updateServerGlimpse);
        ServerGlimpseBuilder expectedBuilder = new ServerGlimpseBuilder(updateServerGlimpse);
        if (!changeAdvertisement) {
            expectedBuilder.setAdvertisementInfo(origBeforeUpdate.getAdvertisementInfo());
        }
        if (!changeHealth) {
            expectedBuilder.setHealthInfo(origBeforeUpdate.getHealthInfo());
        }
        if (!changeReputation) {
            expectedBuilder.setReputation(origBeforeUpdate.getReputation());
        }
        if (!changeMaintenance) {
            expectedBuilder.setMaintenance(origBeforeUpdate.getMaintenance());
        }
        ServerGlimpse expectedServerGlimpse = expectedBuilder.create();
        ServerGlimpse lookedUpServerGlimpse = this.doLookup(updateServerGlimpse.getServerId());
        serverGlimpseTestCollection.assertSame((JsonLdObject)lookedUpServerGlimpse, (JsonLdObject)expectedServerGlimpse, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_ONLY);
    }

    @Test
    public void testUpsertUpdate4() throws Exception {
        boolean changeAdvertisement = false;
        boolean changeHealth = false;
        boolean changeReputation = false;
        boolean changeMaintenance = false;
        ServerGlimpse updateServerGlimpse = serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        ServerGlimpse origBeforeUpdate = serverGlimpseTestCollection.getByServerId(updateServerGlimpse.getServerId());
        this.upsertServerGlimpseCall(updateServerGlimpse);
        ServerGlimpseBuilder expectedBuilder = new ServerGlimpseBuilder(updateServerGlimpse);
        if (!changeAdvertisement) {
            expectedBuilder.setAdvertisementInfo(origBeforeUpdate.getAdvertisementInfo());
        }
        if (!changeHealth) {
            expectedBuilder.setHealthInfo(origBeforeUpdate.getHealthInfo());
        }
        if (!changeReputation) {
            expectedBuilder.setReputation(origBeforeUpdate.getReputation());
        }
        if (!changeMaintenance) {
            expectedBuilder.setMaintenance(origBeforeUpdate.getMaintenance());
        }
        ServerGlimpse expectedServerGlimpse = expectedBuilder.create();
        ServerGlimpse lookedUpServerGlimpse = this.doLookup(updateServerGlimpse.getServerId());
        serverGlimpseTestCollection.assertSame((JsonLdObject)lookedUpServerGlimpse, (JsonLdObject)expectedServerGlimpse, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_ONLY);
    }

    @Test
    public void testUpsertUpdate5() throws Exception {
        boolean changeAdvertisement = false;
        boolean changeHealth = false;
        boolean changeReputation = true;
        boolean changeMaintenance = true;
        ServerGlimpse updateServerGlimpse = serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        ServerGlimpse origBeforeUpdate = serverGlimpseTestCollection.getByServerId(updateServerGlimpse.getServerId());
        this.upsertServerGlimpseCall(updateServerGlimpse);
        ServerGlimpseBuilder expectedBuilder = new ServerGlimpseBuilder(updateServerGlimpse);
        if (!changeAdvertisement) {
            expectedBuilder.setAdvertisementInfo(origBeforeUpdate.getAdvertisementInfo());
        }
        if (!changeHealth) {
            expectedBuilder.setHealthInfo(origBeforeUpdate.getHealthInfo());
        }
        if (!changeReputation) {
            expectedBuilder.setReputation(origBeforeUpdate.getReputation());
        }
        if (!changeMaintenance) {
            expectedBuilder.setMaintenance(origBeforeUpdate.getMaintenance());
        }
        ServerGlimpse expectedServerGlimpse = expectedBuilder.create();
        ServerGlimpse lookedUpServerGlimpse = this.doLookup(updateServerGlimpse.getServerId());
        serverGlimpseTestCollection.assertSame((JsonLdObject)lookedUpServerGlimpse, (JsonLdObject)expectedServerGlimpse, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_ONLY);
    }

    @Test
    public void testUpsertUpdate6() throws Exception {
        boolean changeAdvertisement = true;
        boolean changeHealth = true;
        boolean changeReputation = true;
        boolean changeMaintenance = true;
        ServerGlimpse updateServerGlimpse = serverGlimpseTestCollection.createExtra(changeAdvertisement, changeHealth, changeReputation, changeMaintenance);
        ServerGlimpse origBeforeUpdate = serverGlimpseTestCollection.getByServerId(updateServerGlimpse.getServerId());
        this.upsertServerGlimpseCall(updateServerGlimpse);
        ServerGlimpseBuilder expectedBuilder = new ServerGlimpseBuilder(updateServerGlimpse);
        if (!changeAdvertisement) {
            expectedBuilder.setAdvertisementInfo(origBeforeUpdate.getAdvertisementInfo());
        }
        if (!changeHealth) {
            expectedBuilder.setHealthInfo(origBeforeUpdate.getHealthInfo());
        }
        if (!changeReputation) {
            expectedBuilder.setReputation(origBeforeUpdate.getReputation());
        }
        if (!changeMaintenance) {
            expectedBuilder.setMaintenance(origBeforeUpdate.getMaintenance());
        }
        ServerGlimpse expectedServerGlimpse = expectedBuilder.create();
        ServerGlimpse lookedUpServerGlimpse = this.doLookup(updateServerGlimpse.getServerId());
        serverGlimpseTestCollection.assertSame((JsonLdObject)lookedUpServerGlimpse, (JsonLdObject)expectedServerGlimpse, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.ID_ONLY);
    }

    @Test
    public void testAddMaintenance() throws Exception {
        int serverId = 100;
        ServerGlimpse origBeforeUpdate = serverGlimpseTestCollection.getByServerId(serverId);
        ArrayList origMaintenances = new ArrayList(origBeforeUpdate.getMaintenance());
        assert (origMaintenances.size() == 2);
        MaintenanceInfo target = new MaintenanceInfo(new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2040-02-18T11:00:00Z").getTime()), new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2040-02-20T12:00:11Z").getTime()), new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2040-02-20T13:15:30Z").getTime()), "Added Maintenance", Boolean.valueOf(false));
        ArrayList<MaintenanceInfo> expectedMaintenances = new ArrayList<MaintenanceInfo>(origMaintenances);
        expectedMaintenances.add(target);
        boolean success = this.addMaintenanceCall(serverId, target);
        Assert.assertTrue((boolean)success);
        ServerGlimpse actualServerGlimpse = this.doLookup(serverId);
        MatcherAssert.assertThat((Object)actualServerGlimpse, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        List updatedMaintenances = actualServerGlimpse.getMaintenance();
        MatcherAssert.assertThat((Object)updatedMaintenances, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)updatedMaintenances, (Matcher)Matchers.is((Matcher)Matchers.equalTo(expectedMaintenances)));
    }

    @Test
    public void testReplaceMaintenance1() throws Exception {
        int serverId = 100;
        ServerGlimpse origBeforeUpdate = serverGlimpseTestCollection.getByServerId(serverId);
        ArrayList origMaintenances = new ArrayList(origBeforeUpdate.getMaintenance());
        assert (origMaintenances.size() == 2);
        MaintenanceInfo target = new MaintenanceInfo(new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2040-02-18T11:00:00Z").getTime()), new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2040-02-20T12:00:11Z").getTime()), new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2040-02-20T13:15:30Z").getTime()), "Added Maintenance", Boolean.valueOf(false));
        List<MaintenanceInfo> expectedMaintenances = Arrays.asList(target, (MaintenanceInfo)origMaintenances.get(0));
        boolean success = this.replaceMaintenanceCall(serverId, new ArrayList<MaintenanceInfo>(expectedMaintenances));
        Assert.assertTrue((boolean)success);
        ServerGlimpse actualServerGlimpse = this.doLookup(serverId);
        MatcherAssert.assertThat((Object)actualServerGlimpse, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        List updatedMaintenances = actualServerGlimpse.getMaintenance();
        MatcherAssert.assertThat((Object)updatedMaintenances, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)updatedMaintenances, (Matcher)Matchers.is((Matcher)Matchers.equalTo(expectedMaintenances)));
    }

    @Test
    public void testReplaceMaintenance2() throws Exception {
        int serverId = 100;
        ServerGlimpse origBeforeUpdate = serverGlimpseTestCollection.getByServerId(serverId);
        ArrayList origMaintenances = new ArrayList(origBeforeUpdate.getMaintenance());
        assert (origMaintenances.size() == 2);
        MaintenanceInfo target = new MaintenanceInfo(new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2040-02-18T11:00:00Z").getTime()), new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2040-02-20T12:00:11Z").getTime()), new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2040-02-20T13:15:30Z").getTime()), "Added Maintenance", Boolean.valueOf(false));
        List<MaintenanceInfo> expectedMaintenances = Collections.singletonList((MaintenanceInfo)origMaintenances.get(1));
        boolean success = this.replaceMaintenanceCall(serverId, new ArrayList<MaintenanceInfo>(expectedMaintenances));
        Assert.assertTrue((boolean)success);
        ServerGlimpse actualServerGlimpse = this.doLookup(serverId);
        MatcherAssert.assertThat((Object)actualServerGlimpse, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        List updatedMaintenances = actualServerGlimpse.getMaintenance();
        MatcherAssert.assertThat((Object)updatedMaintenances, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)updatedMaintenances, (Matcher)Matchers.is((Matcher)Matchers.equalTo(expectedMaintenances)));
    }

    @Test
    public void testReplaceMaintenance3() throws Exception {
        int serverId = 100;
        ServerGlimpse origBeforeUpdate = serverGlimpseTestCollection.getByServerId(serverId);
        ArrayList origMaintenances = new ArrayList(origBeforeUpdate.getMaintenance());
        assert (origMaintenances.size() == 2);
        MaintenanceInfo target = new MaintenanceInfo(new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2040-02-18T11:00:00Z").getTime()), new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2040-02-20T12:00:11Z").getTime()), new Timestamp(RFC3339Util.rfc3339StringToDate((String)"2040-02-20T13:15:30Z").getTime()), "Added Maintenance", Boolean.valueOf(false));
        List expectedMaintenances = Collections.emptyList();
        boolean success = this.replaceMaintenanceCall(serverId, new ArrayList<MaintenanceInfo>(expectedMaintenances));
        Assert.assertTrue((boolean)success);
        ServerGlimpse actualServerGlimpse = this.doLookup(serverId);
        MatcherAssert.assertThat((Object)actualServerGlimpse, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        List updatedMaintenances = actualServerGlimpse.getMaintenance();
        MatcherAssert.assertThat((Object)updatedMaintenances, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)updatedMaintenances, (Matcher)Matchers.is((Matcher)Matchers.equalTo(expectedMaintenances)));
    }
}

