/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServerTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServiceTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceIntegrationTest.class);
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static ServerTestCollection serverTestCollection;
    private static ServiceTestCollection serviceTestCollection;
    Client client;

    @BeforeClass
    public static void setUp() throws Exception {
        ServiceIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
        serverTestCollection = new ServerTestCollection();
        serviceTestCollection = new ServiceTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void initClient() throws Exception {
        this.client = new JerseyClientBuilder().build();
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.refillDB();
        testPostgresDB.close();
    }

    public Service createServicesCall(Service service) throws Exception {
        WebTarget w = this.client.target(String.format("http://localhost:%d/service/", RULE.getLocalPort()));
        Entity entity = Entity.entity((Object)service, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        Service res = (Service)w.request().post(entity, Service.class);
        return res;
    }

    public void deleteServiceCall(long id) throws Exception {
        this.client.target(String.format("http://localhost:%d/service/%d", RULE.getLocalPort(), id)).request().delete();
    }

    public void updateServiceCall(Service updatedService) throws Exception {
        this.client.target(String.format("http://localhost:%d/service/%d/", RULE.getLocalPort(), updatedService.getId())).request().put(Entity.entity((Object)updatedService, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    @Test
    public void testInsert() throws Exception {
        Server serverA = (Server)serverTestCollection.getByIndex(0);
        Service newService = new ServiceBuilder().setApi("Geni.AM").setApiVersion("3").setUrl("URL").setUrn("urn:publicid:IDN+new.example.com+authority+cm").setServer(serverA).create();
        Service actualCreatedService = this.createServicesCall(newService);
        System.out.println("Got inserted service: " + actualCreatedService);
        System.out.flush();
        MatcherAssert.assertThat((String)"id of created service is null", (Object)((Integer)actualCreatedService.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Service expectedService = ((ServiceBuilder)new ServiceBuilder(newService).setId((Object)((Integer)actualCreatedService.getId()))).create();
        MatcherAssert.assertThat((String)"URI of created service is null", (Object)actualCreatedService.getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        serviceTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actualCreatedService, (JsonLdObjectWithId)expectedService, true);
        MatcherAssert.assertThat((Object)actualCreatedService.getServer(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)actualCreatedService.getServer().getId()), (Matcher)Matchers.is((Object)((Integer)serverA.getId())));
        Service lookedUpService = this.doLookup(((Integer)actualCreatedService.getId()).intValue());
        serviceTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)lookedUpService, (JsonLdObjectWithId)expectedService, true);
        MatcherAssert.assertThat((Object)lookedUpService.getServer(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)lookedUpService.getServer().getId()), (Matcher)Matchers.is((Object)((Integer)serverA.getId())));
    }

    public void testLookup(Service expected, long id) throws Exception {
        Service actual = this.doLookup(id);
        this.checkLookup(expected, actual);
    }

    public Service doLookup(long id) throws Exception {
        assert (this.client != null);
        WebTarget query = this.client.target(String.format("http://localhost:%d/service/" + id, RULE.getLocalPort()));
        Service actual = (Service)query.request().get(Service.class);
        System.out.println("Got service service: " + actual);
        return actual;
    }

    public void checkLookup(Service expected, Service actual) {
        serviceTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, true);
    }

    @Test
    public void lookup0() throws Exception {
        Service expected = (Service)serviceTestCollection.getByIndex(0);
        this.testLookup(expected, ((Integer)expected.getId()).intValue());
    }

    @Test
    public void lookup1() throws Exception {
        Service expected = (Service)serviceTestCollection.getByIndex(1);
        this.testLookup(expected, ((Integer)expected.getId()).intValue());
    }

    @Test
    public void lookup2() throws Exception {
        Service expected = (Service)serviceTestCollection.getByIndex(2);
        this.testLookup(expected, ((Integer)expected.getId()).intValue());
    }

    @Test
    public void lookup3() throws Exception {
        Service expected = (Service)serviceTestCollection.getByIndex(3);
        this.testLookup(expected, ((Integer)expected.getId()).intValue());
    }

    @Test
    public void lookup4() throws Exception {
        Service expected = (Service)serviceTestCollection.getByIndex(4);
        this.testLookup(expected, ((Integer)expected.getId()).intValue());
    }

    @Test
    public void lookup5() throws Exception {
        Service expected = (Service)serviceTestCollection.getByIndex(5);
        this.testLookup(expected, ((Integer)expected.getId()).intValue());
    }
}

