/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestDefinitionsTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class TestDefinitionIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected static TestDefinitionsTestCollection testDefinitionsTestCollection;
    protected JerseyClient client;

    @BeforeClass
    public static void setUp() throws Exception {
        TestDefinitionIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
        testDefinitionsTestCollection = new TestDefinitionsTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
    }

    public void testLookup(TestDefinition expected, String id) throws Exception {
        TestDefinition actual = this.doLookup(id);
        this.checkLookup(expected, actual);
    }

    public TestDefinition doLookup(String id) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/testdefinition/" + id, RULE.getLocalPort()));
        TestDefinition actual = (TestDefinition)query.request().get(TestDefinition.class);
        System.out.println("Got result TestDefinition: " + actual);
        return actual;
    }

    public void checkLookup(TestDefinition expected, TestDefinition actual) {
        testDefinitionsTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, true);
    }

    public void testLookupAll(List<TestDefinition> expected) throws Exception {
        List<TestDefinition> actual = this.doLookupAll();
        this.checkLookupAll(expected, actual);
    }

    public List<TestDefinition> doLookupAll() throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/testdefinition/", RULE.getLocalPort()));
        List actual = (List)query.request().get((GenericType)new GenericType<List<TestDefinition>>(){});
        System.out.println("Got " + actual.size() + " TestDefinitions. Id's: " + actual.stream().map(PrimaryIdObject::getId).collect(Collectors.toList()));
        return actual;
    }

    public void checkLookupAll(List<TestDefinition> expected, List<TestDefinition> actual) {
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasSize((int)expected.size()));
        for (TestDefinition ex : expected) {
            TestDefinition ac = (TestDefinition)testDefinitionsTestCollection.searchListById(actual, (String)ex.getId());
            MatcherAssert.assertThat((String)("Expected id " + (String)ex.getId() + " not found in result"), (Object)ac, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            testDefinitionsTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)ac, (JsonLdObjectWithId)ex, true);
        }
    }

    @Test
    public void lookup0() throws Exception {
        TestDefinition expected = (TestDefinition)testDefinitionsTestCollection.getByIndex(0);
        this.testLookup(expected, (String)expected.getId());
    }

    @Test
    public void lookup1() throws Exception {
        TestDefinition expected = (TestDefinition)testDefinitionsTestCollection.getByIndex(1);
        this.testLookup(expected, (String)expected.getId());
    }

    @Test
    public void lookupAll() throws Exception {
        List expected = testDefinitionsTestCollection.getAll();
        this.testLookupAll(expected);
    }
}

