/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinitionParameter;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestEmailConfigBuilder;
import be.iminds.ilabt.util.jsonld.test.ObjectWithIdTestCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class TestDefinitionsTestCollection
extends ObjectWithIdTestCollection<String, TestDefinition, TestDefinitionBuilder> {
    public TestDefinitionsTestCollection() {
        super(String.class, TestDefinition.class, TestDefinitionBuilder.class);
        String name = "ping";
        String type = "ping";
        Long maxTestDurationMs = 120000L;
        ArrayList<TestDefinitionParameter> parameters = new ArrayList<TestDefinitionParameter>();
        parameters.add(TestDefinition.getServerTestDefinitionParameter());
        parameters.add(TestDefinition.getUserTestDefinitionParameter());
        parameters.add(new TestDefinitionParameter("warning_threshold_ms", "long", "Ping RTT (in ms) after which the ping test status is set to warning instead of success.", (Object)1000, true));
        parameters.add(new TestDefinitionParameter("timeout_ms", "long", "Timeout (in ms) of the ping command. This is used to generate the ping command, and is not used when the command is overwritten.", (Object)5000, true));
        parameters.add(new TestDefinitionParameter("override_command", "string", "If specified, this command will be used instead of an automatically constructed ping command. This command should only return one thing: a double representing the number of milliseconds RTT.", null, false));
        parameters.add(new TestDefinitionParameter("use_proxy", "boolean", "If set, the ping command will be changed so that it is run from the proxy at bastion.test.iminds.be (if override_command is used, this option is ignored, as the command created by this option is overwritten)", (Object)"false", true));
        parameters.add(new TestDefinitionParameter("list_test", "list of string", "a list of strings", null, false));
        TestDefinitionBuilder testDefinitionPing = ((TestDefinitionBuilder)new TestDefinitionBuilder().setId((Object)name)).setType(type).setMaxTestDurationMs(maxTestDurationMs).setParameters(parameters);
        name = "anyGetVersion";
        type = "anyGetVersion";
        maxTestDurationMs = 300000L;
        parameters = new ArrayList();
        parameters.add(TestDefinition.getServerTestDefinitionParameter());
        parameters.add(TestDefinition.getUserTestDefinitionParameter());
        parameters.add(new TestDefinitionParameter("context-file", "file-content", "Content of the context-file to use for this test. (Leave empty to use default)", (Object)"username = <user.username>\npasswordFilename = <user.passwordfilename>\npemKeyAndCertFilename = <user.pemkeyandcertfilename>\nuserAuthorityUrn = <user.userauthorityurn>\ntestedAggregateManagerUrn = <testbed.urn>\nbe_less_strict = false\ndisable_compliance_tests = false\n\nam_version = <am_version>", true));
        parameters.add(new TestDefinitionParameter("am_version", "string", "The aggregate manager version to use. Options: \"2\", \"3\" or \"auto\"", (Object)"auto", true));
        parameters.add(new TestDefinitionParameter("alternative_test_class", "string", "Alternative Automated Tester Test Class to use. (When not specified, TestAnyGetVersion is used)", null, false));
        parameters.add(new TestDefinitionParameter("email", "TestEmailConfig", "Configuration of \"if\", \"which\" and \"to who\" emails should be sent on test completion", (Object)new TestEmailConfigBuilder().addAddress("test@example.com").create(), false));
        TestDefinitionBuilder testDefinitionGetVersion = ((TestDefinitionBuilder)new TestDefinitionBuilder().setId((Object)name)).setType(type).setMaxTestDurationMs(maxTestDurationMs).setGeniDatastoreMetric("is_available").setGeniDatastoreDescription("Is aggregate manager responsive").setGeniDatastoreUnits("boolean").setParameters(parameters);
        this.all.addAll(Arrays.asList(testDefinitionPing, testDefinitionGetVersion));
    }

    public void assertSameExtraIds(TestDefinition actual, TestDefinition expected) {
    }

    public void assertSameDetails(TestDefinition actual, TestDefinition expected) {
        MatcherAssert.assertThat((String)"type differs", (Object)actual.getType(), (Matcher)Matchers.is((Object)expected.getType()));
        MatcherAssert.assertThat((String)"max test duration differs", (Object)actual.getMaxTestDurationMs(), (Matcher)Matchers.is((Object)expected.getMaxTestDurationMs()));
        MatcherAssert.assertThat((String)"geni datastore metric differs", (Object)actual.getGeniDatastoreMetric(), (Matcher)Matchers.is((Object)expected.getGeniDatastoreMetric()));
        MatcherAssert.assertThat((String)"geni datastore description differs", (Object)actual.getGeniDatastoreDescription(), (Matcher)Matchers.is((Object)expected.getGeniDatastoreDescription()));
        MatcherAssert.assertThat((String)"geni datastore units differs", (Object)actual.getGeniDatastoreUnits(), (Matcher)Matchers.is((Object)expected.getGeniDatastoreUnits()));
        MatcherAssert.assertThat((Object)actual.getParameters(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)expected.getParameters(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        HashSet expectedParams = expected.getParameters() == null ? Collections.emptySet() : new HashSet(expected.getParameters());
        HashSet actualParams = actual.getParameters() == null ? Collections.emptySet() : new HashSet(actual.getParameters());
        MatcherAssert.assertThat(actualParams, (Matcher)Matchers.is((Matcher)Matchers.equalTo(expectedParams)));
        MatcherAssert.assertThat(expectedParams, (Matcher)Matchers.hasSize((int)expected.getParameters().size()));
        MatcherAssert.assertThat((String)"actual parameters has duplicates", actualParams, (Matcher)Matchers.hasSize((int)actual.getParameters().size()));
        MatcherAssert.assertThat(actualParams, (Matcher)Matchers.hasSize((int)expectedParams.size()));
        MatcherAssert.assertThat((Object)actual.getParameters(), (Matcher)Matchers.hasSize((int)expected.getParameters().size()));
        MatcherAssert.assertThat((Object)actual.getClassName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expected.getClassName())));
    }

    public void assertSearchLinks(TestDefinition actual) {
        MatcherAssert.assertThat((Object)actual.getTestInstancesUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actual.getTestInstancesUri().toASCIIString(), (Matcher)Matchers.containsString((String)"/testinstance"));
        MatcherAssert.assertThat((Object)actual.getTestInstancesUri().toASCIIString(), (Matcher)Matchers.containsString((String)("testdefinitionname=" + (String)actual.getId())));
    }
}

