/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedCategoriesTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class TestbedCategoriesIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected static TestbedCategoriesTestCollection testbedCategoriesTestCollection;
    protected JerseyClient client;

    @BeforeClass
    public static void setUp() throws Exception {
        TestbedCategoriesIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
        testbedCategoriesTestCollection = new TestbedCategoriesTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
    }

    public void testLookup(TestbedCategory expected, int id) throws Exception {
        TestbedCategory actual = this.doLookup(id);
        this.checkLookup(expected, actual);
    }

    public TestbedCategory doLookup(int id) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/testbedcategory/" + id, RULE.getLocalPort()));
        TestbedCategory actual = (TestbedCategory)query.request().get(TestbedCategory.class);
        System.out.println("Got result TestbedCategory: " + actual);
        return actual;
    }

    public void checkLookup(TestbedCategory expected, TestbedCategory actual) {
        testbedCategoriesTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, true);
    }

    public void testLookupAll(List<TestbedCategory> expected) throws Exception {
        List<TestbedCategory> actual = this.doLookupAll();
        this.checkLookupAll(expected, actual);
    }

    public List<TestbedCategory> doLookupAll() throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/testbedcategory/", RULE.getLocalPort()));
        List actual = (List)query.request().get((GenericType)new GenericType<List<TestbedCategory>>(){});
        System.out.println("Got " + actual.size() + " TestbedCategories. Id's: " + actual.stream().map(TestbedCategory::getName).collect(Collectors.toList()));
        return actual;
    }

    public void checkLookupAll(List<TestbedCategory> expected, List<TestbedCategory> actual) {
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasSize((int)expected.size()));
        for (TestbedCategory ex : expected) {
            TestbedCategory ac = (TestbedCategory)testbedCategoriesTestCollection.searchListById(actual, (Integer)ex.getId());
            MatcherAssert.assertThat((String)("Expected id " + ex.getId() + " not found in result"), (Object)ac, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            testbedCategoriesTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)ac, (JsonLdObjectWithId)ex, true);
        }
    }

    @Test
    public void lookup0() throws Exception {
        TestbedCategory expected = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(0);
        this.testLookup(expected, (Integer)expected.getId());
    }

    @Test
    public void lookup1() throws Exception {
        TestbedCategory expected = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(1);
        this.testLookup(expected, (Integer)expected.getId());
    }

    @Test
    public void lookup2() throws Exception {
        TestbedCategory expected = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(2);
        this.testLookup(expected, (Integer)expected.getId());
    }

    @Test
    public void lookupAll() throws Exception {
        List expected = testbedCategoriesTestCollection.getAll();
        this.testLookupAll(expected);
    }
}

