/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FederationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.OrganisationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FederationTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.LinkedTestbedDataTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.OrganisationTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServerTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.ServiceTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedCategoriesTestCollection;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.TestbedTestCollection;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import be.iminds.ilabt.util.jsonld.test.CommonTest;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.FixtureHelpers;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class TestbedIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    protected static TestbedCategoriesTestCollection testbedCategoriesTestCollection;
    protected static OrganisationTestCollection organisationTestCollection;
    protected static TestbedTestCollection testbedTestCollection;
    protected static ServerTestCollection serverTestCollection;
    protected static ServiceTestCollection serviceTestCollection;
    protected static FederationTestCollection federationTestCollection;
    protected JerseyClient client;
    protected static FedmonTestPostgresDB testPostgresDB;
    public static DropwizardAppRule<FedmonWebApiServiceConfiguration> usedRule;

    @BeforeClass
    public static void setUp() throws Exception {
        TestbedIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        usedRule = RULE;
        testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testbedTestCollection = new TestbedTestCollection();
        testbedCategoriesTestCollection = new TestbedCategoriesTestCollection();
        organisationTestCollection = new OrganisationTestCollection();
        serverTestCollection = new ServerTestCollection();
        serviceTestCollection = new ServiceTestCollection();
        federationTestCollection = new FederationTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
        assert (testPostgresDB != null);
        testPostgresDB.close();
        testPostgresDB = null;
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
        assert (testPostgresDB != null);
        testPostgresDB.refillDB();
        ((FedmonWebApiServiceApplication)usedRule.getApplication()).getSharedResourceCache().invalidateFull();
    }

    public List<Testbed> testSearch(List<Testbed> expected, String testbedIdArgString, String testbedCategoryArgString, String testbedGeniNameArgString, String testbedUrnArgString, Boolean embed) throws Exception {
        List<Testbed> actual = this.doSearch(testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, embed);
        this.checkSearch(expected, actual);
        boolean mustEmbed = embed != null && embed != false;
        for (Testbed r : actual) {
            Testbed e = expected.stream().filter(t -> ((String)t.getId()).equals(r.getId())).findFirst().orElseThrow(() -> new AssertionError((Object)"did not find testbed"));
            if (mustEmbed) {
                if (e.getServers() != null && !e.getServers().isEmpty()) {
                    MatcherAssert.assertThat((Object)r.getServers(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                    MatcherAssert.assertThat((Object)((Server)r.getServers().get(0)).getCertificateChain(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                    System.out.println("embed test passed");
                    continue;
                }
                System.out.println("embed test skipped");
                continue;
            }
            if (e.getServers() == null || e.getServers().isEmpty()) continue;
            MatcherAssert.assertThat((Object)r.getServers(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)((Server)r.getServers().get(0)).getCertificateChain(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
        return actual;
    }

    public List<Testbed> doSearch(String testbedIdArgString, String testbedCategoryArgString, String testbedGeniNameArgString, String testbedUrnArgString, Boolean embed) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/testbed/", RULE.getLocalPort()));
        if (testbedIdArgString != null) {
            query = query.queryParam("id", new Object[]{testbedIdArgString});
        }
        if (testbedCategoryArgString != null) {
            query = query.queryParam("category", new Object[]{testbedCategoryArgString});
        }
        if (testbedGeniNameArgString != null) {
            query = query.queryParam("geni_name", new Object[]{testbedGeniNameArgString});
        }
        if (testbedUrnArgString != null) {
            query = query.queryParam("urn", new Object[]{testbedUrnArgString});
        }
        if (embed != null) {
            query = query.queryParam("embed", new Object[]{embed});
        }
        query = query.queryParam("full", new Object[]{true});
        List actual = (List)query.request().accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<Testbed>>(){});
        System.out.println("Got " + actual.size() + " testbeds. Id's: " + actual.stream().map(PrimaryIdObject::getId).collect(Collectors.toList()));
        return actual;
    }

    public void checkSearch(List<Testbed> expected, List<Testbed> actual) {
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasSize((int)expected.size()));
        for (Testbed ex : expected) {
            Testbed ac = (Testbed)testbedTestCollection.searchListById(actual, (String)ex.getId());
            MatcherAssert.assertThat((String)("Expected id " + (String)ex.getId() + " not found in result"), (Object)ac, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            testbedTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)ac, (JsonLdObjectWithId)ex, true);
        }
    }

    public String doGetTestbedsXml() throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/testbed.xml", RULE.getLocalPort()));
        String actual = (String)query.request().accept(new String[]{"application/xml"}).get((GenericType)new GenericType<String>(){});
        System.out.println("Got testbeds.xml. length=" + actual.length());
        return actual;
    }

    public void testLookup(Testbed expected, String id) throws Exception {
        Testbed actual = this.doLookup(id, false);
        this.checkLookup(expected, actual);
    }

    public Testbed doLookup(String id, boolean embedded) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/testbed/" + id + (embedded ? "?embed=true" : ""), RULE.getLocalPort()));
        Testbed actual = (Testbed)query.request().get(Testbed.class);
        System.out.println("Got result Testbed. len=" + actual);
        return actual;
    }

    public void checkLookup(Testbed expected, Testbed actual) {
        testbedTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected, true);
    }

    @Test
    public void lookup0() throws Exception {
        Testbed expected = (Testbed)testbedTestCollection.getByIndex(0);
        this.testLookup(expected, (String)expected.getId());
    }

    @Test
    public void lookup1() throws Exception {
        Testbed expected = (Testbed)testbedTestCollection.getByIndex(1);
        this.testLookup(expected, (String)expected.getId());
    }

    @Test
    public void lookup2() throws Exception {
        Testbed expected = (Testbed)testbedTestCollection.getByIndex(2);
        this.testLookup(expected, (String)expected.getId());
    }

    @Test
    public void search1() throws Exception {
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedIdArgString = null;
        String testbedUrnArgString = null;
        List expected = testbedTestCollection.getAll();
        this.testSearch(expected, testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, null);
    }

    @Test
    public void search1b() throws Exception {
        String testbedCategoryArgString = "";
        String testbedGeniNameArgString = "";
        String testbedIdArgString = "";
        String testbedUrnArgString = "";
        List expected = testbedTestCollection.getAll();
        this.testSearch(expected, testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, null);
    }

    @Test
    public void search2() throws Exception {
        String testbedCategoryArgString = "one";
        String testbedGeniNameArgString = null;
        String testbedIdArgString = null;
        String testbedUrnArgString = null;
        List expected = testbedTestCollection.getByIds(new String[]{"A"});
        this.testSearch(expected, testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, null);
    }

    @Test
    public void search3() throws Exception {
        String testbedCategoryArgString = "oneAndTwo";
        String testbedGeniNameArgString = null;
        String testbedIdArgString = null;
        String testbedUrnArgString = null;
        List expected = testbedTestCollection.getByIds(new String[]{"A", "B"});
        this.testSearch(expected, testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, null);
    }

    @Test
    public void search4() throws Exception {
        String testbedCategoryArgString = "none";
        String testbedGeniNameArgString = null;
        String testbedIdArgString = null;
        String testbedUrnArgString = null;
        List expected = testbedTestCollection.getByIds(new String[0]);
        this.testSearch(expected, testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, null);
    }

    @Test
    public void search5() throws Exception {
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedIdArgString = null;
        String testbedUrnArgString = "urn:publicid:IDN+a.example.com+authority+cm";
        List expected = testbedTestCollection.getByIds(new String[]{"A"});
        this.testSearch(expected, testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, null);
    }

    @Test
    public void search6() throws Exception {
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedIdArgString = null;
        String testbedUrnArgString = "urn:publicid:IDN+a.example.com+authority+cm,urn:publicid:IDN+c.example.com:cc+authority+cm";
        List expected = testbedTestCollection.getByIds(new String[]{"A", "C"});
        this.testSearch(expected, testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, null);
    }

    @Test
    public void search7() throws Exception {
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = "ex-b";
        String testbedIdArgString = null;
        String testbedUrnArgString = null;
        List expected = testbedTestCollection.getByIds(new String[]{"B"});
        this.testSearch(expected, testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, null);
    }

    @Test
    public void search8() throws Exception {
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = "ex-b,ex-a";
        String testbedIdArgString = null;
        String testbedUrnArgString = null;
        List expected = testbedTestCollection.getByIds(new String[]{"B", "A"});
        this.testSearch(expected, testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, null);
    }

    @Test
    public void search9() throws Exception {
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedIdArgString = "A";
        String testbedUrnArgString = null;
        List expected = testbedTestCollection.getByIds(new String[]{"A"});
        this.testSearch(expected, testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, null);
    }

    @Test
    public void search3embed() throws Exception {
        String testbedCategoryArgString = "oneAndTwo";
        String testbedGeniNameArgString = null;
        String testbedIdArgString = null;
        String testbedUrnArgString = null;
        List expected = testbedTestCollection.getByIds(new String[]{"A", "B"});
        List<Testbed> resultTestbeds = this.testSearch(expected, testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, true);
    }

    @Test
    public void search9b() throws Exception {
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedIdArgString = "A,B,C";
        String testbedUrnArgString = null;
        List expected = testbedTestCollection.getByIds(new String[]{"A", "B", "C"});
        this.testSearch(expected, testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, null);
    }

    @Test
    public void search10() throws Exception {
        String testbedCategoryArgString = "oneAndTwo";
        String testbedGeniNameArgString = "ex-a,ex-b";
        String testbedIdArgString = "A,B,C";
        String testbedUrnArgString = "urn:publicid:IDN+a.example.com+authority+cm,urn:publicid:IDN+c.example.com:cc+authority+cm";
        List expected = testbedTestCollection.getByIds(new String[]{"A"});
        this.testSearch(expected, testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, null);
    }

    @Test
    public void search10b() throws Exception {
        String testbedCategoryArgString = "oneAndTwo";
        String testbedGeniNameArgString = "ex-a,ex-b";
        String testbedIdArgString = "A,B,C";
        String testbedUrnArgString = "urn:publicid:IDN+a.example.com+authority+cm,urn:publicid:IDN+b.example.com+authority+cm";
        List expected = testbedTestCollection.getByIds(new String[]{"A", "B"});
        this.testSearch(expected, testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, null);
    }

    @Test
    public void searchAllEmbedded() throws Exception {
        String testbedCategoryArgString = null;
        String testbedGeniNameArgString = null;
        String testbedIdArgString = null;
        String testbedUrnArgString = null;
        LinkedTestbedDataTestCollection linkedTestbedDataTestCollection = new LinkedTestbedDataTestCollection(true, 0, "http://localhost:9000");
        List<Testbed> expected = linkedTestbedDataTestCollection.getTestbeds();
        List<Testbed> actual = this.testSearch(expected, testbedIdArgString, testbedCategoryArgString, testbedGeniNameArgString, testbedUrnArgString, true);
        for (Testbed resTestbed : actual) {
            MatcherAssert.assertThat((Object)resTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Testbed origTestbed = linkedTestbedDataTestCollection.getTestbedById((String)resTestbed.getId());
            MatcherAssert.assertThat((Object)origTestbed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            testbedTestCollection.assertSameButIgnoreUri(resTestbed, origTestbed);
            if (origTestbed.getOrganisation() != null) {
                Organisation origOrganMin = OrganisationBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_FOR_EMBEDDING_IN_CHILD, (Organisation)origTestbed.getOrganisation());
                organisationTestCollection.assertSame((JsonLdObjectWithId)resTestbed.getOrganisation(), (JsonLdObjectWithId)origOrganMin, CommonTest.ComparePrecision.IGNORE_URI, CommonTest.ComparePrecision.ID_ONLY);
            } else {
                MatcherAssert.assertThat((Object)resTestbed.getOrganisation(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            }
            if (origTestbed.getServers() != null) {
                MatcherAssert.assertThat((Object)resTestbed.getServers(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                MatcherAssert.assertThat((Object)origTestbed.getDefaultServer(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                MatcherAssert.assertThat((Object)resTestbed.getDefaultServer(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                MatcherAssert.assertThat((Object)((Integer)resTestbed.getDefaultServer().getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Integer)origTestbed.getDefaultServer().getId()))));
                MatcherAssert.assertThat((Object)resTestbed.getDefaultServer().getUri(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                for (int i = 0; i < origTestbed.getServers().size(); ++i) {
                    Server origServer = (Server)origTestbed.getServers().get(i);
                    Server resServer = (Server)resTestbed.getServers().get(i);
                    assert (origServer != null);
                    MatcherAssert.assertThat((Object)resServer, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                    try {
                        serverTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resServer, (JsonLdObjectWithId)origServer);
                    }
                    catch (AssertionError e) {
                        System.err.flush();
                        System.out.println("\n\nCompared servers differ!\nExpected:\n" + origServer);
                        System.out.println("\n\nActual:\n" + resServer + "\n\n");
                        System.out.flush();
                        System.err.flush();
                        throw e;
                    }
                    if (origServer.getServices() != null) {
                        MatcherAssert.assertThat((Object)resServer.getServices(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                        for (int j = 0; j < origServer.getServices().size(); ++j) {
                            Service origService = (Service)origServer.getServices().get(j);
                            Service resService = (Service)resServer.getServices().get(j);
                            assert (origService != null);
                            MatcherAssert.assertThat((Object)resService, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                            try {
                                serviceTestCollection.assertSameButIgnoreUri((JsonLdObjectWithId)resService, (JsonLdObjectWithId)new ServiceBuilder(origService).setServer(null).create());
                                continue;
                            }
                            catch (AssertionError e) {
                                System.err.flush();
                                System.out.println("\n\nCompared services differ!\nExpected:\n" + origService);
                                System.out.println("\n\nActual:\n" + resService + "\n\n");
                                System.out.flush();
                                System.err.flush();
                                throw e;
                            }
                        }
                        continue;
                    }
                    MatcherAssert.assertThat((Object)resServer.getServices(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                }
                continue;
            }
            MatcherAssert.assertThat((Object)resTestbed.getServers(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    public Testbed createTestbedCall(Testbed testbed) throws Exception {
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/testbed/", RULE.getLocalPort()));
        Entity entity = Entity.entity((Object)testbed, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        Testbed res = (Testbed)w.request().post(entity, Testbed.class);
        return res;
    }

    public List<URI> getCategoriesCall(Testbed testbed) throws Exception {
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/testbed/%s/categories/", RULE.getLocalPort(), testbed.getId()));
        Entity entity = Entity.entity((Object)testbed, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        List res = (List)w.request().get((GenericType)new GenericType<List<URI>>(){});
        return res;
    }

    public List<URI> updateCategoriesCall(Testbed testbed, List<URI> newCategories) throws Exception {
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/testbed/%s/categories/", RULE.getLocalPort(), testbed.getId()));
        Entity entity = Entity.entity(newCategories, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        List res = (List)w.request().put(entity, (GenericType)new GenericType<List<URI>>(){});
        return res;
    }

    public List<URI> getFederationsCall(Testbed testbed) throws Exception {
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/testbed/%s/federations/", RULE.getLocalPort(), testbed.getId()));
        Entity entity = Entity.entity((Object)testbed, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        List res = (List)w.request().get((GenericType)new GenericType<List<URI>>(){});
        return res;
    }

    public List<URI> updateFederationsCall(Testbed testbed, List<URI> newFederations) throws Exception {
        JerseyWebTarget w = this.client.target(String.format("http://localhost:%d/testbed/%s/federations/", RULE.getLocalPort(), testbed.getId()));
        Entity entity = Entity.entity(newFederations, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        List res = (List)w.request().put(entity, (GenericType)new GenericType<List<URI>>(){});
        return res;
    }

    public void deleteTestbedCall(String id) throws Exception {
        this.client.target(String.format("http://localhost:%d/testbed/%s", RULE.getLocalPort(), id)).request().delete();
    }

    public void updateTestbedCall(Testbed updatedTestbed) throws Exception {
        this.client.target(String.format("http://localhost:%d/testbed/%s/", RULE.getLocalPort(), updatedTestbed.getId())).request().put(Entity.entity((Object)updatedTestbed, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    @Test
    public void update() throws Exception {
        Organisation iminds = (Organisation)organisationTestCollection.getById("iminds");
        Organisation testorg = (Organisation)organisationTestCollection.getById("testorg");
        TestbedBuilder testbedBuilder = ((TestbedBuilder)new TestbedBuilder().setId((Object)"A")).setLongName("Fake Testbed 1: A-changed").setInterfaceUrl("http://www.example.com/a-changed").setPingHost("www.a.example.com-changed").setInfoUrl("http://www.example.com/doc-changed/").setHelpUrl("http://www.example.com/help-changed.html").setDefaultComponentManagerUrn("urn:publicid:IDN+a-changed.example.com+authority+cm").setOtrsName("OTRS A-changed").setDescription("Description of A-changed").setGeniId("ex-a-changed").setGeniHref(new URI("https://example.com/info/aggregate/ex-a-changed")).setColor("red-changed").setAllowLinks(Boolean.valueOf(false)).setOrganisation(testorg).setNodesLocationVisualisationCoordinatesUrl("yy-changed").setNodesLocationVisualisationImageUrl("xx-changed").setDefaultServerId(Integer.valueOf(99));
        assert (testbedBuilder.getCategories() == null) : "categories should not be specified: " + testbedBuilder.getCategories();
        Testbed updateTestbed = testbedBuilder.create();
        assert (updateTestbed.getCategories() == null);
        this.updateTestbedCall(updateTestbed);
        testbedBuilder.setCategories((Collection)((Testbed)testbedTestCollection.getById("A")).getCategories());
        testbedBuilder.setServers(((Testbed)testbedTestCollection.getById("A")).getServers());
        testbedBuilder.setProxies(((Testbed)testbedTestCollection.getById("A")).getProxies());
        testbedBuilder.setFederations(((Testbed)testbedTestCollection.getById("A")).getFederations());
        Testbed expectedTestbed = testbedBuilder.create();
        Testbed lookedUpTestbed = this.doLookup((String)updateTestbed.getId(), false);
        testbedTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)lookedUpTestbed, (JsonLdObjectWithId)expectedTestbed, true);
        MatcherAssert.assertThat((Object)lookedUpTestbed.getOrganisation(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)lookedUpTestbed.getOrganisation().getId()), (Matcher)Matchers.is((Object)((String)testorg.getId())));
    }

    @Test
    public void insert() throws Exception {
        Organisation iminds = (Organisation)organisationTestCollection.getById("iminds");
        Organisation testorg = (Organisation)organisationTestCollection.getById("testorg");
        TestbedBuilder testbedBuilder = ((TestbedBuilder)new TestbedBuilder().setId((Object)"Abis")).setLongName("Fake Testbed 1: A-changed").setInterfaceUrl("http://www.example.com/a-changed").setPingHost("www.a.example.com-changed").setInfoUrl("http://www.example.com/doc-changed/").setHelpUrl("http://www.example.com/help-changed.html").setDefaultComponentManagerUrn("urn:publicid:IDN+a-changed.example.com+authority+cm").setOtrsName("OTRS A-changed").setDescription("Description of A-changed").setGeniId("ex-a-changed").setGeniHref(new URI("https://example.com/info/aggregate/ex-a-changed")).setColor("red-changed").setAllowLinks(Boolean.valueOf(false)).setOrganisation(testorg).setNodesLocationVisualisationCoordinatesUrl("yy-changed").setNodesLocationVisualisationImageUrl("xx-changed");
        Testbed newTestbed = testbedBuilder.create();
        Testbed actualCreatedTestbed = this.createTestbedCall(newTestbed);
        testbedBuilder.setCategories(Collections.emptyList());
        testbedBuilder.setFederations(Collections.emptyList());
        testbedBuilder.setServers(null);
        testbedBuilder.setProxies(null);
        Testbed expectedTestbed = testbedBuilder.create();
        testbedTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actualCreatedTestbed, (JsonLdObjectWithId)expectedTestbed, true);
        Testbed lookedUpTestbed = this.doLookup((String)newTestbed.getId(), false);
        testbedTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)lookedUpTestbed, (JsonLdObjectWithId)expectedTestbed, true);
        MatcherAssert.assertThat((Object)lookedUpTestbed.getOrganisation(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)lookedUpTestbed.getOrganisation().getId()), (Matcher)Matchers.is((Object)((String)testorg.getId())));
    }

    @Test(expected=ExceptionInCall.class)
    public void embeddedCreateFail1() throws Exception {
        Testbed testbedToInsert = (Testbed)MAPPER.readValue(FixtureHelpers.fixture((String)"fixtures/new-embedded-testbed-1.json"), Testbed.class);
        TestbedBuilder testbedToInsertBuilder = new TestbedBuilder(testbedToInsert);
        testbedToInsertBuilder.setDefaultComponentManagerUrn("urn:publicid:IDN+b.example.com+authority+cm");
        Testbed editedTestbedToInsert = testbedToInsertBuilder.create();
        MatcherAssert.assertThat((Object)editedTestbedToInsert.getDefaultComponentManagerUrn(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        try {
            Testbed testbed = this.createTestbedCall(editedTestbedToInsert);
        }
        catch (Exception e) {
            throw new ExceptionInCall("Exception in call", e);
        }
    }

    @Test(expected=ExceptionInCall.class)
    public void embeddedCreateFail2b() throws Exception {
        Testbed testbedToInsert = (Testbed)MAPPER.readValue(FixtureHelpers.fixture((String)"fixtures/new-embedded-testbed-1.json"), Testbed.class);
        TestbedBuilder testbedToInsertBuilder = new TestbedBuilder(testbedToInsert, true);
        ServerBuilder firstServerBuilder = (ServerBuilder)testbedToInsertBuilder.getServerBuilders().get(0);
        firstServerBuilder.setId((Object)5);
        assert (firstServerBuilder != null);
        assert (firstServerBuilder.getId() != null);
        testbedToInsertBuilder.setDefaultServerBuilder(firstServerBuilder);
        Testbed editedTestbedToInsert = testbedToInsertBuilder.create();
        MatcherAssert.assertThat((Object)editedTestbedToInsert.getDefaultServer(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        try {
            Testbed testbed = this.createTestbedCall(editedTestbedToInsert);
        }
        catch (Exception e) {
            throw new ExceptionInCall("Exception in call", e);
        }
    }

    @Test(expected=ExceptionInCall.class)
    public void embeddedCreateFail3() throws Exception {
        Testbed testbedToInsert = (Testbed)MAPPER.readValue(FixtureHelpers.fixture((String)"fixtures/new-embedded-testbed-1.json"), Testbed.class);
        TestbedBuilder testbedToInsertBuilder = new TestbedBuilder(testbedToInsert, true);
        ((ServerBuilder)testbedToInsertBuilder.getServerBuilders().get(0)).setDefaultComponentManagerUrn("urn:publicid:IDN+b.example.com+authority+cm");
        Testbed editedTestbedToInsert = testbedToInsertBuilder.create();
        MatcherAssert.assertThat((Object)((Server)editedTestbedToInsert.getServers().get(0)).getDefaultComponentManagerUrn(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        try {
            Testbed testbed = this.createTestbedCall(editedTestbedToInsert);
        }
        catch (Exception e) {
            throw new ExceptionInCall("Exception in call", e);
        }
    }

    @Test(expected=ExceptionInCall.class)
    public void embeddedCreateFail4a() throws Exception {
        Testbed testbedToInsert = (Testbed)MAPPER.readValue(FixtureHelpers.fixture((String)"fixtures/new-embedded-testbed-1.json"), Testbed.class);
        TestbedBuilder testbedToInsertBuilder = new TestbedBuilder(testbedToInsert, true);
        ((ServerBuilder)testbedToInsertBuilder.getServerBuilders().get(0)).setDefaultAMServiceBuilder(((ServiceBuilder)new ServiceBuilder().setId((Object)5)).setApi("Geni.AM").setApiVersion("3").setUrl("http://example.com/am/3/").setUrn("urn:publicid:IDN+n.example.com+authority+am"));
        try {
            Testbed testbed = this.createTestbedCall(testbedToInsertBuilder.create());
        }
        catch (Exception e) {
            throw new ExceptionInCall("Exception in call", e);
        }
    }

    @Test(expected=ExceptionInCall.class)
    public void embeddedCreateFail4b() throws Exception {
        Testbed testbedToInsert = (Testbed)MAPPER.readValue(FixtureHelpers.fixture((String)"fixtures/new-embedded-testbed-1.json"), Testbed.class);
        TestbedBuilder testbedToInsertBuilder = new TestbedBuilder(testbedToInsert, true);
        ((ServerBuilder)testbedToInsertBuilder.getServerBuilders().get(0)).setDefaultAMServiceBuilder((ServiceBuilder)((ServerBuilder)testbedToInsertBuilder.getServerBuilders().get(0)).getServiceBuilders().get(0));
        try {
            Testbed testbed = this.createTestbedCall(testbedToInsertBuilder.create());
        }
        catch (Exception e) {
            throw new ExceptionInCall("Exception in call", e);
        }
    }

    @Test
    public void embeddedCreate() throws Exception {
        Testbed testbedToInsert = (Testbed)MAPPER.readValue(FixtureHelpers.fixture((String)"fixtures/new-embedded-testbed-1.json"), Testbed.class);
        MatcherAssert.assertThat((Object)testbedToInsert.getCategories(), (Matcher)Matchers.hasSize((int)4));
        MatcherAssert.assertThat((Object)testbedToInsert.getProxies(), (Matcher)Matchers.hasSize((int)1));
        Testbed actualCreatedTestbed = this.createTestbedCall(testbedToInsert);
        System.out.println("actualCreatedTestbed=" + actualCreatedTestbed);
        MatcherAssert.assertThat((Object)actualCreatedTestbed.getCategories(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualCreatedTestbed.getCategories(), (Matcher)Matchers.hasSize((int)4));
        MatcherAssert.assertThat((Object)actualCreatedTestbed.getProxies(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualCreatedTestbed.getProxies(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)actualCreatedTestbed.getServers(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualCreatedTestbed.getServers(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat((Object)((Server)actualCreatedTestbed.getServers().get(0)).getServices(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Server)actualCreatedTestbed.getServers().get(0)).getServices(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat((Object)((String)actualCreatedTestbed.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)((Server)actualCreatedTestbed.getServers().get(0)).getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)((Service)((Server)actualCreatedTestbed.getServers().get(0)).getServices().get(0)).getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)((Service)((Server)actualCreatedTestbed.getServers().get(0)).getServices().get(1)).getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)actualCreatedTestbed.getDefaultServer(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Server)actualCreatedTestbed.getServers().get(0)).getName(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Service)((Server)actualCreatedTestbed.getServers().get(0)).getServices().get(0)).getApi(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Service)((Server)actualCreatedTestbed.getServers().get(0)).getServices().get(1)).getApi(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        TestbedBuilder expectedTestbedBuilder = new TestbedBuilder(testbedToInsert, true).setDefaultComponentManagerUrn("urn:publicid:IDN+n.example.com+authority+cm").setDefaultServerBuilder((ServerBuilder)new ServerBuilder().setId((Object)((Integer)((Server)actualCreatedTestbed.getServers().get(0)).getId())));
        ServerBuilder expectedServerBuilder = (ServerBuilder)expectedTestbedBuilder.getServerBuilders().get(0);
        expectedServerBuilder.setDefaultComponentManagerUrn("urn:publicid:IDN+n.example.com+authority+cm");
        expectedServerBuilder.setId((Object)((Integer)((Server)actualCreatedTestbed.getServers().get(0)).getId()));
        MatcherAssert.assertThat((Object)((Integer)expectedServerBuilder.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        for (ServiceBuilder expectedServiceBuilder : expectedServerBuilder.getServiceBuilders()) {
            for (Service actualService : ((Server)actualCreatedTestbed.getServers().get(0)).getServices()) {
                if (!actualService.getApiVersion().equals(expectedServiceBuilder.getApiVersion()) || !actualService.getApi().equals(expectedServiceBuilder.getApi())) continue;
                expectedServiceBuilder.setId((Object)((Integer)actualService.getId()));
                if (!actualService.getApiVersion().equals("3") || !actualService.getApi().equals("Geni.AM")) continue;
                expectedServerBuilder.setDefaultAMServiceBuilder((ServiceBuilder)new ServiceBuilder().setId((Object)((Integer)actualService.getId())));
            }
        }
        expectedTestbedBuilder.setCategories(new ArrayList());
        for (TestbedCategory cat : testbedToInsert.getCategories()) {
            Integer actualCatId = null;
            for (TestbedCategory actualCat : actualCreatedTestbed.getCategories()) {
                MatcherAssert.assertThat((String)("A TestbedCategory in the actual testbed has no ID. name=" + actualCat.getName()), (Object)((Integer)actualCat.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
                if (actualCat.getName().equals(cat.getName())) {
                    actualCatId = (Integer)actualCat.getId();
                }
                if (!actualCat.getName().equals("oneAndTwo") && !actualCat.getName().equals("one")) continue;
                MatcherAssert.assertThat((String)"existing category needs to have correct ID", (Object)((Integer)actualCat.getId()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Integer)testbedCategoriesTestCollection.getByName(actualCat.getName()).getId()))));
            }
            MatcherAssert.assertThat((String)("category \"" + cat.getName() + "\" is not in actual testbed"), actualCatId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            expectedTestbedBuilder.addCategory(actualCatId, cat.getName());
        }
        MatcherAssert.assertThat((Object)expectedTestbedBuilder.getCategories(), (Matcher)Matchers.hasSize((int)4));
        expectedTestbedBuilder.setFederations(Collections.singletonList(((FederationBuilder)federationTestCollection.getBuilderById("fed2")).createMinimized(JsonLdObjectsMetaData.Minimization.MINIMAL_ID_ONLY)));
        Testbed expectedTestbed = expectedTestbedBuilder.create();
        System.out.println("expectedTestbed=" + expectedTestbed);
        testbedTestCollection.assertSame((JsonLdObjectWithId)actualCreatedTestbed, (JsonLdObjectWithId)expectedTestbed, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.FULL);
        Testbed lookedUpTestbed = this.doLookup((String)expectedTestbed.getId(), true);
        MatcherAssert.assertThat((Object)lookedUpTestbed.getCategories(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)lookedUpTestbed.getCategories(), (Matcher)Matchers.hasSize((int)4));
        MatcherAssert.assertThat((Object)lookedUpTestbed.getProxies(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)lookedUpTestbed.getProxies(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)lookedUpTestbed.getServers(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)lookedUpTestbed.getServers(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat((Object)((Server)lookedUpTestbed.getServers().get(0)).getServices(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Server)lookedUpTestbed.getServers().get(0)).getServices(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat((Object)((String)lookedUpTestbed.getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)((Server)lookedUpTestbed.getServers().get(0)).getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)((Service)((Server)lookedUpTestbed.getServers().get(0)).getServices().get(0)).getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)((Service)((Server)lookedUpTestbed.getServers().get(0)).getServices().get(1)).getId()), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)lookedUpTestbed.getDefaultServer(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Server)lookedUpTestbed.getServers().get(0)).getName(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Service)((Server)lookedUpTestbed.getServers().get(0)).getServices().get(0)).getApi(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Service)((Server)lookedUpTestbed.getServers().get(0)).getServices().get(1)).getApi(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        testbedTestCollection.assertSame((JsonLdObjectWithId)lookedUpTestbed, (JsonLdObjectWithId)expectedTestbed, CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.FULL);
        MatcherAssert.assertThat((Object)lookedUpTestbed.getOrganisation(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((String)lookedUpTestbed.getOrganisation().getId()), (Matcher)Matchers.is((Object)((String)expectedTestbed.getOrganisation().getId())));
        MatcherAssert.assertThat((Object)lookedUpTestbed.getDefaultServer(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Integer)lookedUpTestbed.getDefaultServer().getId()), (Matcher)Matchers.is((Object)((Integer)((Server)expectedTestbed.getServers().get(0)).getId())));
        MatcherAssert.assertThat((Object)lookedUpTestbed.getDefaultComponentManagerUrn(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)lookedUpTestbed.getDefaultComponentManagerUrn(), (Matcher)Matchers.is((Object)((Server)expectedTestbed.getServers().get(0)).getDefaultComponentManagerUrn()));
        MatcherAssert.assertThat((Object)lookedUpTestbed.getServers(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat((Object)((Server)lookedUpTestbed.getServers().get(0)), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((Server)lookedUpTestbed.getServers().get(0)).getServices(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((Server)lookedUpTestbed.getServers().get(0)).getDefaultAMService(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        serverTestCollection.assertSame((JsonLdObjectWithId)((Server)lookedUpTestbed.getServers().get(0)), (JsonLdObjectWithId)((Server)expectedTestbed.getServers().get(0)), CommonTest.ComparePrecision.FULL, CommonTest.ComparePrecision.FULL);
    }

    @Test
    public void getCategories1() throws Exception {
        Testbed testbed = (Testbed)testbedTestCollection.getByIndex(0);
        List actualCategories = this.getCategoriesCall(testbed).stream().map(URI::toASCIIString).collect(Collectors.toList());
        List<String> expectedCategories = testbed.getCategories().stream().map(cat -> "http://localhost:9000/testbedcategory/" + cat.getId()).collect(Collectors.toList());
        System.out.println("actualCategories  =" + actualCategories);
        System.out.println("expectedCategories=" + expectedCategories);
        MatcherAssert.assertThat(actualCategories, (Matcher)Matchers.containsInAnyOrder((Object[])expectedCategories.toArray(new String[1])));
    }

    @Test
    public void getCategories2() throws Exception {
        Testbed testbed = (Testbed)testbedTestCollection.getByIndex(1);
        List actualCategories = this.getCategoriesCall(testbed).stream().map(URI::toASCIIString).collect(Collectors.toList());
        List<String> expectedCategories = testbed.getCategories().stream().map(cat -> "http://localhost:9000/testbedcategory/" + cat.getId()).collect(Collectors.toList());
        System.out.println("actualCategories  =" + actualCategories);
        System.out.println("expectedCategories=" + expectedCategories);
        MatcherAssert.assertThat(actualCategories, (Matcher)Matchers.containsInAnyOrder((Object[])expectedCategories.toArray(new String[1])));
    }

    @Test
    public void getCategories3() throws Exception {
        Testbed testbed = (Testbed)testbedTestCollection.getByIndex(2);
        List actualCategories = this.getCategoriesCall(testbed).stream().map(URI::toASCIIString).collect(Collectors.toList());
        List<String> expectedCategories = testbed.getCategories().stream().map(cat -> "http://localhost:9000/testbedcategory/" + cat.getId()).collect(Collectors.toList());
        System.out.println("actualCategories  =" + actualCategories);
        System.out.println("expectedCategories=" + expectedCategories);
        if (expectedCategories.isEmpty()) {
            MatcherAssert.assertThat(actualCategories, (Matcher)Matchers.hasSize((int)0));
        } else {
            MatcherAssert.assertThat(actualCategories, (Matcher)Matchers.containsInAnyOrder((Object[])expectedCategories.toArray(new String[1])));
        }
    }

    @Test
    public void updateCategories1a() throws Exception {
        Testbed testbed = (Testbed)testbedTestCollection.getByIndex(0);
        TestbedCategory a = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(0);
        TestbedCategory b = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(1);
        TestbedCategory c = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(2);
        List<String> expectedCategories = Arrays.asList("http://localhost:9000/testbedcategory/" + a.getId());
        List<URI> expectedCategoryUris = expectedCategories.stream().map(s -> {
            try {
                return new URI((String)s);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("should not happen", e);
            }
        }).collect(Collectors.toList());
        List actualCategories1 = this.updateCategoriesCall(testbed, expectedCategoryUris).stream().map(URI::toASCIIString).collect(Collectors.toList());
        List actualCategories2 = this.getCategoriesCall(testbed).stream().map(URI::toASCIIString).collect(Collectors.toList());
        System.out.println("actualCategories1  =" + actualCategories1);
        System.out.println("actualCategories2  =" + actualCategories2);
        System.out.println("expectedCategories=" + expectedCategories);
        MatcherAssert.assertThat(actualCategories1, (Matcher)Matchers.containsInAnyOrder((Object[])expectedCategories.toArray(new String[1])));
        MatcherAssert.assertThat(actualCategories2, (Matcher)Matchers.containsInAnyOrder((Object[])expectedCategories.toArray(new String[1])));
    }

    @Test
    public void updateCategories1b() throws Exception {
        Testbed testbed = (Testbed)testbedTestCollection.getByIndex(0);
        TestbedCategory a = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(0);
        TestbedCategory b = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(1);
        TestbedCategory c = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(2);
        List<String> expectedCategories = Arrays.asList("http://localhost:9000/testbedcategory/" + b.getId());
        List<URI> expectedCategoryUris = expectedCategories.stream().map(s -> {
            try {
                return new URI((String)s);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("should not happen", e);
            }
        }).collect(Collectors.toList());
        List actualCategories1 = this.updateCategoriesCall(testbed, expectedCategoryUris).stream().map(URI::toASCIIString).collect(Collectors.toList());
        List actualCategories2 = this.getCategoriesCall(testbed).stream().map(URI::toASCIIString).collect(Collectors.toList());
        System.out.println("actualCategories1  =" + actualCategories1);
        System.out.println("actualCategories2  =" + actualCategories2);
        System.out.println("expectedCategories=" + expectedCategories);
        MatcherAssert.assertThat(actualCategories1, (Matcher)Matchers.containsInAnyOrder((Object[])expectedCategories.toArray(new String[1])));
        MatcherAssert.assertThat(actualCategories2, (Matcher)Matchers.containsInAnyOrder((Object[])expectedCategories.toArray(new String[1])));
    }

    @Test
    public void updateCategories1c() throws Exception {
        Testbed testbed = (Testbed)testbedTestCollection.getByIndex(0);
        TestbedCategory a = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(0);
        TestbedCategory b = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(1);
        TestbedCategory c = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(2);
        List<String> expectedCategories = Arrays.asList("http://localhost:9000/testbedcategory/" + c.getId(), "http://localhost:9000/testbedcategory/" + b.getId());
        List<URI> expectedCategoryUris = expectedCategories.stream().map(s -> {
            try {
                return new URI((String)s);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("should not happen", e);
            }
        }).collect(Collectors.toList());
        List actualCategories1 = this.updateCategoriesCall(testbed, expectedCategoryUris).stream().map(URI::toASCIIString).collect(Collectors.toList());
        List actualCategories2 = this.getCategoriesCall(testbed).stream().map(URI::toASCIIString).collect(Collectors.toList());
        System.out.println("actualCategories1  =" + actualCategories1);
        System.out.println("actualCategories2  =" + actualCategories2);
        System.out.println("expectedCategories=" + expectedCategories);
        MatcherAssert.assertThat(actualCategories1, (Matcher)Matchers.containsInAnyOrder((Object[])expectedCategories.toArray(new String[1])));
        MatcherAssert.assertThat(actualCategories2, (Matcher)Matchers.containsInAnyOrder((Object[])expectedCategories.toArray(new String[1])));
    }

    @Test
    public void updateCategories2a() throws Exception {
        Testbed testbed = (Testbed)testbedTestCollection.getByIndex(0);
        TestbedCategory a = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(0);
        TestbedCategory b = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(1);
        TestbedCategory c = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(2);
        List<String> expectedCategories = Arrays.asList("http://localhost:9000/testbedcategory/" + a.getId(), "http://localhost:9000/testbedcategory/" + b.getId());
        List<URI> expectedCategoryUris = expectedCategories.stream().map(s -> {
            try {
                return new URI((String)s);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("should not happen", e);
            }
        }).collect(Collectors.toList());
        List actualCategories1 = this.updateCategoriesCall(testbed, expectedCategoryUris).stream().map(URI::toASCIIString).collect(Collectors.toList());
        List actualCategories2 = this.getCategoriesCall(testbed).stream().map(URI::toASCIIString).collect(Collectors.toList());
        System.out.println("actualCategories1  =" + actualCategories1);
        System.out.println("actualCategories2  =" + actualCategories2);
        System.out.println("expectedCategories=" + expectedCategories);
        MatcherAssert.assertThat(actualCategories1, (Matcher)Matchers.containsInAnyOrder((Object[])expectedCategories.toArray(new String[1])));
        MatcherAssert.assertThat(actualCategories2, (Matcher)Matchers.containsInAnyOrder((Object[])expectedCategories.toArray(new String[1])));
    }

    @Test
    public void updateCategories2b() throws Exception {
        Testbed testbed = (Testbed)testbedTestCollection.getByIndex(0);
        TestbedCategory a = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(0);
        TestbedCategory b = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(1);
        TestbedCategory c = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(2);
        List<String> expectedCategories = Arrays.asList("http://localhost:9000/testbedcategory/" + a.getId(), "http://localhost:9000/testbedcategory/" + b.getId(), "http://localhost:9000/testbedcategory/" + c.getId());
        List<URI> expectedCategoryUris = expectedCategories.stream().map(s -> {
            try {
                return new URI((String)s);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("should not happen", e);
            }
        }).collect(Collectors.toList());
        List actualCategories1 = this.updateCategoriesCall(testbed, expectedCategoryUris).stream().map(URI::toASCIIString).collect(Collectors.toList());
        List actualCategories2 = this.getCategoriesCall(testbed).stream().map(URI::toASCIIString).collect(Collectors.toList());
        System.out.println("actualCategories1  =" + actualCategories1);
        System.out.println("actualCategories2  =" + actualCategories2);
        System.out.println("expectedCategories=" + expectedCategories);
        MatcherAssert.assertThat(actualCategories1, (Matcher)Matchers.containsInAnyOrder((Object[])expectedCategories.toArray(new String[1])));
        MatcherAssert.assertThat(actualCategories2, (Matcher)Matchers.containsInAnyOrder((Object[])expectedCategories.toArray(new String[1])));
    }

    @Test
    public void updateCategories2c() throws Exception {
        Testbed testbed = (Testbed)testbedTestCollection.getByIndex(0);
        TestbedCategory a = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(0);
        TestbedCategory b = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(1);
        TestbedCategory c = (TestbedCategory)testbedCategoriesTestCollection.getByIndex(2);
        List<String> expectedCategories = Arrays.asList(new String[0]);
        List<URI> expectedCategoryUris = expectedCategories.stream().map(s -> {
            try {
                return new URI((String)s);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("should not happen", e);
            }
        }).collect(Collectors.toList());
        List actualCategories1 = this.updateCategoriesCall(testbed, expectedCategoryUris).stream().map(URI::toASCIIString).collect(Collectors.toList());
        List actualCategories2 = this.getCategoriesCall(testbed).stream().map(URI::toASCIIString).collect(Collectors.toList());
        System.out.println("actualCategories1  =" + actualCategories1);
        System.out.println("actualCategories2  =" + actualCategories2);
        System.out.println("expectedCategories=" + expectedCategories);
        MatcherAssert.assertThat(expectedCategories, (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat(actualCategories1, (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat(actualCategories2, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void getFederations1() throws Exception {
        Testbed testbed = (Testbed)testbedTestCollection.getByIndex(0);
        List actualFederations = this.getFederationsCall(testbed).stream().map(URI::toASCIIString).collect(Collectors.toList());
        List<String> expectedFederations = testbed.getFederations().stream().map(fed -> "http://localhost:9000/federation/" + (String)fed.getId()).collect(Collectors.toList());
        System.out.println("actualFederations  =" + actualFederations);
        System.out.println("expectedFederations=" + expectedFederations);
        MatcherAssert.assertThat(actualFederations, (Matcher)Matchers.containsInAnyOrder((Object[])expectedFederations.toArray(new String[1])));
    }

    @Test
    public void updateFederations1a() throws Exception {
        Testbed testbed = (Testbed)testbedTestCollection.getByIndex(0);
        Federation a = (Federation)federationTestCollection.getByIndex(0);
        Federation b = (Federation)federationTestCollection.getByIndex(1);
        Federation c = (Federation)federationTestCollection.getByIndex(2);
        List<String> expectedFederations = Arrays.asList("http://localhost:9000/federation/" + (String)c.getId());
        List<URI> expectedFederationUris = expectedFederations.stream().map(s -> {
            try {
                return new URI((String)s);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("should not happen", e);
            }
        }).collect(Collectors.toList());
        List<URI> upCallRes = this.updateFederationsCall(testbed, expectedFederationUris);
        System.out.println("upCallRes=" + upCallRes);
        List actualFederations1 = upCallRes.stream().map(URI::toASCIIString).collect(Collectors.toList());
        List actualFederations2 = this.getFederationsCall(testbed).stream().map(URI::toASCIIString).collect(Collectors.toList());
        System.out.println("actualFederations1  =" + actualFederations1);
        System.out.println("actualFederations2  =" + actualFederations2);
        System.out.println("expectedFederations =" + expectedFederations);
        MatcherAssert.assertThat(actualFederations1, (Matcher)Matchers.containsInAnyOrder((Object[])expectedFederations.toArray(new String[1])));
        MatcherAssert.assertThat(actualFederations2, (Matcher)Matchers.containsInAnyOrder((Object[])expectedFederations.toArray(new String[1])));
    }

    private static class ExceptionInCall
    extends Exception {
        public ExceptionInCall(String msg, Exception e) {
            super(msg, e);
        }
    }
}

