/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.test;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceApplication;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.FedmonTestPostgresDB;
import be.iminds.ilabt.jfed.fedmon.webapi.service.test.UserTestCollection;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.junit.DropwizardAppRule;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class UserIntegrationTest {
    @ClassRule
    public static final DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE = new DropwizardAppRule(FedmonWebApiServiceApplication.class, "../fedmon-webapi-service-TESTING.yml", new ConfigOverride[0]);
    protected static UserTestCollection userTestCollection;
    protected JerseyClient client;

    @BeforeClass
    public static void setUp() throws Exception {
        UserIntegrationTest.setUp(RULE);
    }

    public static void setUp(DropwizardAppRule<FedmonWebApiServiceConfiguration> RULE) throws Exception {
        Clock.set((Clock.CurrentTimeProvider)new Clock.DefaultTestTimeProvider());
        assert (RULE != null);
        FedmonTestPostgresDB testPostgresDB = new FedmonTestPostgresDB(RULE);
        testPostgresDB.recreateDB();
        testPostgresDB.close();
        userTestCollection = new UserTestCollection();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Clock.reset();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.client = new JerseyClientBuilder().build();
        assert (this.client != null);
    }

    public void testLookup(User expected, String id) throws Exception {
        User actual = this.doLookup(id);
        this.checkLookup(expected, actual);
    }

    public User doLookup(String id) throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/user/" + id, RULE.getLocalPort()));
        User actual = (User)query.request().get(User.class);
        System.out.println("Got result User: " + actual);
        return actual;
    }

    public void checkLookup(User expected, User actual) {
        userTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)actual, (JsonLdObjectWithId)expected);
    }

    public void testLookupAll(List<User> expected) throws Exception {
        List<User> actual = this.doLookupAll();
        this.checkLookupAll(expected, actual);
    }

    public List<User> doLookupAll() throws Exception {
        assert (this.client != null);
        JerseyWebTarget query = this.client.target(String.format("http://localhost:%d/user/", RULE.getLocalPort()));
        List actual = (List)query.request().get((GenericType)new GenericType<List<User>>(){});
        System.out.println("Got " + actual.size() + " Users. Id's: " + actual.stream().map(User::getUsername).collect(Collectors.toList()));
        return actual;
    }

    public void checkLookupAll(List<User> expected, List<User> actual) {
        MatcherAssert.assertThat(actual, (Matcher)Matchers.hasSize((int)expected.size()));
        for (User ex : expected) {
            User ac = (User)userTestCollection.searchListById(actual, (String)ex.getId());
            MatcherAssert.assertThat((String)("Expected id " + (String)ex.getId() + " not found in result"), (Object)ac, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            userTestCollection.assertSameAndExpectActualHasUri((JsonLdObjectWithId)ac, (JsonLdObjectWithId)ex);
        }
    }

    @Test
    public void lookup0() throws Exception {
        User expected = (User)userTestCollection.getByIndex(0);
        System.out.println("looking for: " + expected);
        this.testLookup(expected, (String)expected.getId());
    }

    @Test
    public void lookup1() throws Exception {
        User expected = (User)userTestCollection.getByIndex(1);
        System.out.println("looking for: " + expected);
        this.testLookup(expected, (String)expected.getId());
    }

    @Test
    public void lookupAll() throws Exception {
        List expected = userTestCollection.getAll();
        this.testLookupAll(expected);
    }
}

