/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.app;

import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.base.AbstractWebApiConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.SearchUriGenerator;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.UriTool;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FedmonWebApiServiceConfiguration
extends AbstractWebApiConfiguration<FedmonAccess>
implements RrdConfig {
    private static final Logger LOG = LoggerFactory.getLogger(FedmonWebApiServiceConfiguration.class);
    private List<String> createTaskAndResultUsers;
    private List<String> restartUsers;
    @JsonIgnore
    private List<GeniUrn> createTaskAndResultUsersUrns;
    @JsonIgnore
    private List<GeniUrn> restartUsersUrns;
    private List<String> createTaskAndResultHosts;
    private List<String> restartHosts;
    @JsonIgnore
    private List<InetAddress> createTaskAndResultHostsAddresses;
    @JsonIgnore
    private List<InetAddress> restartHostsAddresses;
    private String rrdDbDir;

    public FedmonWebApiServiceConfiguration() {
        super(FedmonAccess.class, (AbstractWebApiConfiguration.BaseAccessEnumFactory)new AbstractWebApiConfiguration.BaseAccessEnumFactory<FedmonAccess>(){

            public FedmonAccess getRead() {
                return FedmonAccess.READ;
            }

            public FedmonAccess getAdmin() {
                return FedmonAccess.ADMIN;
            }
        });
    }

    protected JsonLdObjectsMetaData createJsonLdObjectsMetaData() {
        return JsonLdObjectsMetaData.getInstance((String)Testbed.class.getPackage().getName());
    }

    @JsonProperty
    public String getRrdDbDir() {
        return this.rrdDbDir;
    }

    @JsonProperty
    public void setRrdDbDir(String rrdDbDir) {
        this.rrdDbDir = rrdDbDir;
    }

    @JsonProperty
    public List<String> getCreateTaskAndResultUsers() {
        return this.createTaskAndResultUsers;
    }

    @JsonProperty
    public void setCreateTaskAndResultUsers(List<String> createTaskAndResultUsers) {
        this.createTaskAndResultUsers = createTaskAndResultUsers;
    }

    @JsonProperty
    public List<String> getRestartUsers() {
        return this.restartUsers;
    }

    @JsonProperty
    public void setRestartUsers(List<String> restartUsers) {
        this.restartUsers = restartUsers;
    }

    @JsonProperty
    public List<String> getCreateTaskAndResultHosts() {
        return this.createTaskAndResultHosts;
    }

    @JsonProperty
    public void setCreateTaskAndResultHosts(List<String> createTaskAndResultHosts) {
        this.createTaskAndResultHosts = createTaskAndResultHosts;
    }

    @JsonProperty
    public List<String> getRestartHosts() {
        return this.restartHosts;
    }

    @JsonProperty
    public void setRestartHosts(List<String> restartHosts) {
        this.restartHosts = restartHosts;
    }

    @Nonnull
    protected UriTool createUriTool(String baseUrl) {
        return this.getJsonLdObjectsMetaData().makeUriTool(baseUrl, (UriTool.DerivedUriGenerator)new SearchUriGenerator());
    }

    @Nonnull
    @JsonIgnore
    protected Set<FedmonAccess> getUserBasedAccess(@Nonnull GeniUrn user) {
        Set res = super.getUserBasedAccess(user);
        if (this.createTaskAndResultUsersUrns.contains(user)) {
            res.add(FedmonAccess.CREATE_TASK_AND_RESULT);
        }
        if (this.restartUsersUrns.contains(user)) {
            res.add(FedmonAccess.RESTART);
        }
        LOG.debug("   access=" + res + " for user=\"" + user + "\"");
        return res;
    }

    @Nonnull
    @JsonIgnore
    protected Set<FedmonAccess> getHostBasedAccess(@Nonnull String remoteAddress) {
        InetAddress remote;
        Set res = super.getHostBasedAccess(remoteAddress);
        try {
            remote = InetAddress.getByName(remoteAddress);
            if (remote == null) {
                LOG.warn("remote address is null");
            }
        }
        catch (UnknownHostException e) {
            LOG.error("Unknown host: \"" + remoteAddress + "\"", (Throwable)e);
            return res;
        }
        if (this.createTaskAndResultHostsAddresses.contains(remote)) {
            res.add(FedmonAccess.ADMIN);
        }
        if (this.restartHostsAddresses.contains(remote)) {
            res.add(FedmonAccess.ADMIN);
        }
        LOG.debug("   access=" + res + " for remoteAddress=\"" + remoteAddress + "\"");
        return res;
    }

    @JsonIgnore
    protected synchronized void initAccessAddresses() {
        super.initAccessAddresses();
        if (this.createTaskAndResultHostsAddresses == null) {
            InetAddress address;
            this.createTaskAndResultHostsAddresses = new ArrayList<InetAddress>();
            this.restartHostsAddresses = new ArrayList<InetAddress>();
            if (this.createTaskAndResultHosts != null) {
                for (String addressStr : this.createTaskAndResultHosts) {
                    try {
                        address = InetAddress.getByName(addressStr);
                        if (address != null) {
                            this.createTaskAndResultHostsAddresses.add(address);
                            continue;
                        }
                        LOG.error("Config error: Invalid Internet address in createTaskAndResultHosts: " + addressStr);
                    }
                    catch (UnknownHostException e) {
                        LOG.error("UnknownHostException calling InetAddress.getByName(\"" + addressStr + "\")", (Throwable)e);
                    }
                }
            }
            if (this.restartHosts != null) {
                for (String addressStr : this.restartHosts) {
                    try {
                        address = InetAddress.getByName(addressStr);
                        if (address != null) {
                            this.restartHostsAddresses.add(address);
                            continue;
                        }
                        LOG.error("Config error: Invalid Internet address in restartHosts: " + addressStr);
                    }
                    catch (UnknownHostException e) {
                        LOG.error("UnknownHostException calling InetAddress.getByName(\"" + addressStr + "\")", (Throwable)e);
                    }
                }
            }
        }
        assert (this.createTaskAndResultHostsAddresses != null);
        assert (this.restartHostsAddresses != null);
    }

    @JsonIgnore
    protected synchronized void initAccessUrns() {
        super.initAccessUrns();
        if (this.createTaskAndResultUsersUrns == null) {
            GeniUrn urn;
            this.createTaskAndResultUsersUrns = new ArrayList<GeniUrn>();
            this.restartUsersUrns = new ArrayList<GeniUrn>();
            if (this.createTaskAndResultUsers != null) {
                for (String uStr : this.createTaskAndResultUsers) {
                    urn = GeniUrn.parse((String)uStr.trim());
                    if (urn != null) {
                        this.createTaskAndResultUsersUrns.add(urn);
                        continue;
                    }
                    LOG.error("Config error: Invalid user URN in createTaskAndResultUsers: " + uStr);
                }
            }
            if (this.restartUsers != null) {
                for (String uStr : this.restartUsers) {
                    urn = GeniUrn.parse((String)uStr.trim());
                    if (urn != null) {
                        this.restartUsersUrns.add(urn);
                        continue;
                    }
                    LOG.error("Config error: Invalid user URN in restartUsers: " + uStr);
                }
            }
        }
        assert (this.createTaskAndResultUsersUrns != null);
        assert (this.restartUsersUrns != null);
    }
}

