/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.Transaction;

public abstract class FederationTestbedMappingDao {
    @SqlQuery(value="SELECT federation_id  FROM testbed_federation_mapping WHERE testbed_id=:testbedId")
    @Nonnull
    public abstract List<String> getFederationIdsByTestbedId(@NotNull @Bind(value="testbedId") String var1);

    @SqlQuery(value="SELECT testbed_id  FROM testbed_federation_mapping WHERE federation_id=:federationId")
    @Nonnull
    public abstract List<String> getTestbedIdsByFederationId(@NotNull @Bind(value="federationId") String var1);

    @SqlUpdate(value="INSERT INTO testbed_federation_mapping      (testbed_id,federation_id) \n VALUES (:testbedId,:federationId) ")
    public abstract int insert(@NotNull @Bind(value="testbedId") String var1, @NotNull @Bind(value="federationId") String var2);

    @SqlUpdate(value="DELETE FROM testbed_federation_mapping  WHERE testbed_id=:testbedId AND federation_id=:federationId")
    public abstract int delete(@NotNull @Bind(value="testbedId") String var1, @NotNull @Bind(value="federationId") String var2);

    @Transaction
    public int updateTestbedsForFederation(@NotNull @Bind(value="federationId") String federationId, @NotNull @Bind(value="testbedIds") List<String> newTestbedIds) {
        List<String> currentTestbedIds = this.getTestbedIdsByFederationId(federationId);
        ArrayList<String> toRemove = new ArrayList<String>(currentTestbedIds);
        toRemove.removeAll(newTestbedIds);
        ArrayList<String> toAdd = new ArrayList<String>(newTestbedIds);
        toAdd.removeAll(currentTestbedIds);
        int rowsChanged = 0;
        for (String r : toRemove) {
            rowsChanged += this.delete(r, federationId);
        }
        for (String a : toAdd) {
            rowsChanged += this.insert(a, federationId);
        }
        return rowsChanged;
    }

    @Transaction
    public int updateFederationsForTestbed(@NotNull @Bind(value="testbedId") String testbedId, @NotNull @Bind(value="federationIds") List<String> newFederationIds) {
        List<String> currentFederationIds = this.getFederationIdsByTestbedId(testbedId);
        ArrayList<String> toRemove = new ArrayList<String>(currentFederationIds);
        toRemove.removeAll(newFederationIds);
        ArrayList<String> toAdd = new ArrayList<String>(newFederationIds);
        toAdd.removeAll(currentFederationIds);
        int rowsChanged = 0;
        for (String r : toRemove) {
            rowsChanged += this.delete(testbedId, r);
        }
        for (String a : toAdd) {
            rowsChanged += this.insert(testbedId, a);
        }
        return rowsChanged;
    }
}

