/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.dao;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class ResultMapper
implements ResultSetMapper<Result> {
    private static final ObjectMapper mapper = Jackson.newObjectMapper();
    private static final TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};

    public Result map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        TestInstance testInstance;
        Long id = r.getLong("id");
        assert (id != null);
        Timestamp timestamp = r.getTimestamp("created");
        Timestamp expire = r.getTimestamp("expire");
        String logFile = r.getString("log_file");
        String logUrl = r.getString("log_url");
        String summary = r.getString("summary");
        Integer testinstanceId = r.getObject("testinstance_id") == null ? null : Integer.valueOf(r.getInt("testinstance_id"));
        String testDefinitionId = r.getString("testdefinition_id");
        String detailsJsonText = r.getString("details_json_text");
        if (testinstanceId != null) {
            TestInstanceBuilder testInstanceBuilder = new TestInstanceBuilder();
            testInstanceBuilder.setId((Object)testinstanceId);
            testInstance = testInstanceBuilder.create();
        } else {
            testInstance = null;
        }
        ResultBuilder res = ((ResultBuilder)new ResultBuilder().setId((Object)id)).setCreated(timestamp).setExpire(expire).setLogFile(logFile).setLogUrl(logUrl).setSummary(summary).setResults(new HashMap()).setTestInstance(testInstance).setTestDefinitionId(testDefinitionId);
        if (detailsJsonText != null) {
            try {
                HashMap detailedResults = (HashMap)mapper.readValue(detailsJsonText, typeRef);
                res.setResults((Map)detailedResults);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to convert JSON in DB to Map<String, Object>", e);
            }
        }
        return res.create();
    }
}

