/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.AdminDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.TaskDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Admin;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.AdminBuilder;
import com.codahale.metrics.annotation.Timed;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/admin")
@Produces(value={"application/json"})
public class AdminResource {
    @Context
    UriInfo uriInfo;
    private final AdminDao adminDAO;
    private final TaskDao taskDAO;
    private final FedmonWebApiServiceConfiguration configuration;

    public AdminResource(AdminDao adminDAO, TaskDao taskDAO, FedmonWebApiServiceConfiguration configuration) {
        this.adminDAO = adminDAO;
        this.taskDAO = taskDAO;
        this.configuration = configuration;
    }

    @GET
    @Timed
    public Admin get() {
        Admin res = this.adminDAO.get();
        if (res == null) {
            return null;
        }
        AdminBuilder adminBuilder = new AdminBuilder(res);
        adminBuilder.setUri(this.uriInfo.getAbsolutePathBuilder().build(new Object[0]));
        return adminBuilder.create();
    }

    @PUT
    @Timed
    public Admin set(Admin admin, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        this.adminDAO.update(admin);
        if (admin.getDisableAllTests().booleanValue()) {
            this.taskDAO.forceCancellingStateAll(new Timestamp(System.currentTimeMillis()));
        }
        return this.get();
    }
}

