/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.FederationDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.FederationTestbedMappingDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.SharedResourceCache;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.TestbedResource;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.codahale.metrics.annotation.Timed;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/federation")
@Produces(value={"application/json"})
@Singleton
public class FederationResource {
    private static final Logger LOG = LoggerFactory.getLogger(FederationResource.class);
    @Context
    UriInfo uriInfo;
    private final FederationDao federationDao;
    private final FederationTestbedMappingDao ftMappingDao;
    private final FedmonWebApiServiceConfiguration configuration;
    private final SharedResourceCache sharedResourceCache;
    private final TestbedResource testbedResource;

    public FederationResource(FederationDao federationDao, FederationTestbedMappingDao ftMappingDao, SharedResourceCache sharedResourceCache, TestbedResource testbedResource, FedmonWebApiServiceConfiguration configuration) {
        this.federationDao = federationDao;
        this.ftMappingDao = ftMappingDao;
        this.sharedResourceCache = sharedResourceCache;
        this.testbedResource = testbedResource;
        this.configuration = configuration;
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Federation update(@NotNull @PathParam(value="id") String id, Federation federation, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (federation.getId() == null || !((String)federation.getId()).equals(id)) {
            throw new WebApplicationException("ID of provided Federation differs with ID in request URL path", Response.Status.BAD_REQUEST);
        }
        this.federationDao.update(federation);
        if (federation.getTestbeds() != null) {
            this.ftMappingDao.updateTestbedsForFederation((String)federation.getId(), federation.getTestbeds().stream().map(PrimaryIdObject::getId).collect(Collectors.toList()));
            this.testbedResource.invalidateSearchCache();
        }
        this.sharedResourceCache.getFederationCache().invalidateOnlySingle(id);
        return this.get(id, request);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Federation create(@NotNull Federation newFederation, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (newFederation.getId() == null) {
            throw new WebApplicationException("Provided federation must have an (new and non existing) ID", Response.Status.BAD_REQUEST);
        }
        if (this.federationDao.findById((String)newFederation.getId()) != null) {
            throw new WebApplicationException("A Federation with that ID (" + (String)newFederation.getId() + ") already exists.", Response.Status.CONFLICT);
        }
        LOG.debug("Federation.create: Federation \"" + (String)newFederation.getId() + "\" does not exist yet.");
        LOG.debug("Federation.create: Creating Federation \"" + (String)newFederation.getId() + "\".");
        this.federationDao.insert(newFederation);
        if (newFederation.getTestbeds() != null && !newFederation.getTestbeds().isEmpty()) {
            this.ftMappingDao.updateTestbedsForFederation((String)newFederation.getId(), newFederation.getTestbeds().stream().map(PrimaryIdObject::getId).collect(Collectors.toList()));
            this.sharedResourceCache.invalidateFull();
        }
        return this.get((String)newFederation.getId(), request);
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @Timed
    public Federation get(@NotNull @PathParam(value="id") String id, @Context HttpServletRequest request) {
        Federation res = this.sharedResourceCache.getFederationCache().getById(id);
        if (res == null) {
            throw new NotFoundException("No Federation with id " + id + " found");
        }
        return res;
    }

    @GET
    @Produces(value={"application/json"})
    @Timed
    public List<Federation> getAll(@Context HttpServletRequest request) {
        List<Federation> res = this.sharedResourceCache.getFederationCache().getAll();
        return res;
    }

    @DELETE
    @Path(value="{id}")
    @Timed
    public void delete(@NotNull @PathParam(value="id") String id, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        throw new WebApplicationException("not yet implemented", Response.Status.NOT_IMPLEMENTED);
    }
}

