/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.FrequencyDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import com.codahale.metrics.annotation.Timed;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="/frequency")
@Produces(value={"application/json"})
public class FrequencyResource {
    @Context
    UriInfo uriInfo;
    private final FrequencyDao frequencyDAO;
    private final FedmonWebApiServiceConfiguration configuration;

    public FrequencyResource(FrequencyDao frequencyDAO, FedmonWebApiServiceConfiguration configuration) {
        this.frequencyDAO = frequencyDAO;
        this.configuration = configuration;
    }

    @GET
    @Timed
    public List<Frequency> all() {
        List<Frequency> resBase = this.frequencyDAO.findAll();
        if (resBase == null) {
            return null;
        }
        ArrayList<Frequency> res = new ArrayList<Frequency>();
        for (Frequency base : resBase) {
            res.add(this.addUris(this.uriInfo, base));
        }
        return res;
    }

    @GET
    @Path(value="{id}")
    @Timed
    public Frequency get(@NotNull @PathParam(value="id") Integer id) {
        Frequency res = this.frequencyDAO.findById(id);
        if (res == null) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        return this.addUris(this.uriInfo, res);
    }

    public Frequency addUris(UriInfo uriInfo, Frequency orig) {
        assert (uriInfo != null);
        assert (orig != null);
        assert (orig.getId() != null);
        return (Frequency)this.configuration.getUriTool().setUriRecursive((JsonLdObject)orig);
    }
}

