/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.util.Clock;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.LogDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LogBuilder;
import com.codahale.metrics.annotation.Timed;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/log")
@Produces(value={"application/json"})
public class LogResource {
    private static final Logger LOG = LoggerFactory.getLogger(LogResource.class);
    @Context
    UriInfo uriInfo;
    private final LogDao logDAO;
    private final FedmonWebApiServiceConfiguration configuration;

    public LogResource(LogDao logDAO, FedmonWebApiServiceConfiguration configuration) {
        this.logDAO = logDAO;
        this.configuration = configuration;
    }

    private URI getUri(Long logId, boolean contentUri) {
        try {
            String slash;
            String string = slash = this.configuration.getBaseUrl().endsWith("/") ? "" : "/";
            if (logId == null) {
                return new URI(this.configuration.getBaseUrl() + slash + "log");
            }
            if (contentUri) {
                return new URI(this.configuration.getBaseUrl() + slash + "log/" + logId + "/content");
            }
            return new URI(this.configuration.getBaseUrl() + slash + "log/" + logId);
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException("Failed to construct URI. Server misconfiguration? baseUrl=\"" + this.configuration.getBaseUrl() + "\"", (Throwable)e);
        }
    }

    @GET
    @Path(value="{id}")
    @Timed
    public Log getLog(@NotNull @PathParam(value="id") Long id, @Context HttpServletRequest request) throws SQLException {
        Log res = this.logDAO.getById(id);
        if (res == null) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        LogBuilder logBuilder = new LogBuilder(res);
        logBuilder.setUri(this.getUri(id, false));
        logBuilder.setContent(this.getUri(id, true));
        return logBuilder.create();
    }

    @GET
    @Path(value="{id}/content")
    @Produces(value={"*/*"})
    @Timed
    public Response getContent(@NotNull @PathParam(value="id") Long id, @Context HttpServletRequest request) throws SQLException {
        final LogDao.ContentAndType res = this.logDAO.getContentById(id);
        if (res == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Log " + id + " does not exist")).type(MediaType.TEXT_PLAIN_TYPE).build();
        }
        if (res.getMediaType() == null) {
            LOG.error("Got invalid res from logDAO res.getContent() == null -> " + (res.getContent() == null) + " res.getMediaType() == null -> " + (res.getMediaType() == null));
            return Response.serverError().entity((Object)"Got invalid res from logDAO").type(MediaType.TEXT_PLAIN_TYPE).build();
        }
        if (res.getContent() == null) {
            return Response.noContent().build();
        }
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                os.write(res.getContent());
            }
        };
        return Response.ok((Object)stream, (MediaType)LogResource.logMediaTypeToJerseyMediaType(res.getMediaType())).build();
    }

    public static MediaType logMediaTypeToJerseyMediaType(Log.LogMediaType logMediaType) {
        switch (logMediaType) {
            case TEXT: {
                return MediaType.TEXT_PLAIN_TYPE;
            }
            case JSON: {
                return MediaType.APPLICATION_JSON_TYPE;
            }
            case XML: {
                return MediaType.APPLICATION_XML_TYPE;
            }
            case HTML: {
                return MediaType.TEXT_HTML_TYPE;
            }
            case BINARY: {
                return MediaType.APPLICATION_OCTET_STREAM_TYPE;
            }
        }
        throw new RuntimeException("Unsupported Log.LogMediaType \"" + logMediaType + "\"");
    }

    public static Log.LogMediaType jerseyMediaTypeToLogMediaType(MediaType jerseyMediaType) {
        if (jerseyMediaType.equals((Object)MediaType.TEXT_PLAIN_TYPE)) {
            return Log.LogMediaType.TEXT;
        }
        if (jerseyMediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            return Log.LogMediaType.JSON;
        }
        if (jerseyMediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            return Log.LogMediaType.XML;
        }
        if (jerseyMediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            return Log.LogMediaType.HTML;
        }
        if (jerseyMediaType.equals((Object)MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
            return Log.LogMediaType.BINARY;
        }
        LOG.warn("Unsupported jersey MediaType \"" + jerseyMediaType + "\". Will treat as plain text instead!");
        return Log.LogMediaType.TEXT;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Log createLog(@NotNull Log log, @Context HttpServletRequest request) throws SQLException {
        Long logId;
        this.configuration.assureAccessAllowed(FedmonAccess.CREATE_TASK_AND_RESULT, request);
        if (log.getComplete() != null && log.getComplete().booleanValue()) {
            throw new BadRequestException("Log to create may not be complete");
        }
        if (log.getStopTime() != null) {
            throw new BadRequestException("Log to create may not have a stop time");
        }
        if (log.getMediaType() == null) {
            throw new BadRequestException("Log to create must have a media type");
        }
        if (log.getContent() != null) {
            throw new BadRequestException("Log to create may not have content URI filled in");
        }
        if (log.getId() != null) {
            throw new BadRequestException("Log to create may not have ID filled in");
        }
        if (log.getUri() != null) {
            throw new BadRequestException("Log to create may not have URI filled in");
        }
        if (log.getLive() == null) {
            throw new BadRequestException("Log to create must specify \"live\"");
        }
        if (log.getName() == null) {
            throw new BadRequestException("Log to create must specify \"name\"");
        }
        if (log.getSize() != null) {
            throw new BadRequestException("Log to create must not have size");
        }
        if (log.getStartTime() == null) {
            log = new LogBuilder(log).setStartTime(Clock.nowTimestamp()).create();
        }
        if ((logId = this.logDAO.insert(log)) == null) {
            LOG.error("Error creating Log (logDAO.insert returned null ID)");
            throw new InternalServerErrorException("Error creating Log (logDAO.insert returned null ID)");
        }
        LogBuilder logBuilder = (LogBuilder)new LogBuilder(log).setId((Object)logId);
        logBuilder.setUri(this.getUri(logId, false));
        logBuilder.setContent(this.getUri(logId, true));
        logBuilder.setSize(Long.valueOf(0L));
        return logBuilder.create();
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Timed
    public Response updateLog(@NotNull Log userUpdateRequest, @Context HttpServletRequest request) throws SQLException {
        this.configuration.assureAccessAllowed(FedmonAccess.CREATE_TASK_AND_RESULT, request);
        Log origLog = this.getLog((Long)userUpdateRequest.getId(), request);
        LogBuilder updatedLog = new LogBuilder(userUpdateRequest);
        if (origLog.getComplete() != null && userUpdateRequest.getComplete() != null && !userUpdateRequest.getComplete().booleanValue() && origLog.getComplete().booleanValue()) {
            throw new BadRequestException("complete cannot be changed to false");
        }
        if (userUpdateRequest.getComplete() == null) {
            updatedLog.setComplete(origLog.getComplete());
        }
        if (origLog.getName() != null && userUpdateRequest.getName() != null && !userUpdateRequest.getName().equals(origLog.getName())) {
            throw new BadRequestException("name cannot be changed");
        }
        if (origLog.getName() != null && userUpdateRequest.getName() == null) {
            updatedLog.setName(origLog.getName());
        }
        if (origLog.getStopTime() != null && userUpdateRequest.getStopTime() != null && !userUpdateRequest.getStopTime().equals(origLog.getStopTime())) {
            throw new BadRequestException("stopTime cannot be changed once set");
        }
        if (origLog.getStopTime() != null && userUpdateRequest.getStopTime() == null) {
            updatedLog.setStopTime(origLog.getStopTime());
        }
        if (origLog.getTaskId() != null && userUpdateRequest.getTaskId() != null && !userUpdateRequest.getTaskId().equals(origLog.getTaskId())) {
            throw new BadRequestException("task cannot be changed once set");
        }
        if (origLog.getTaskId() != null && userUpdateRequest.getTaskId() == null) {
            updatedLog.setTaskId(origLog.getTaskId());
        }
        if (origLog.getResultId() != null && userUpdateRequest.getResultId() != null && !userUpdateRequest.getResultId().equals(origLog.getResultId())) {
            throw new BadRequestException("result cannot be changed once set");
        }
        if (origLog.getResultId() != null && userUpdateRequest.getResultId() == null) {
            updatedLog.setResultId(origLog.getResultId());
        }
        if (origLog.getMediaType() != null && userUpdateRequest.getMediaType() != null && !userUpdateRequest.getMediaType().equals((Object)origLog.getMediaType())) {
            throw new BadRequestException("mediaType cannot be changed");
        }
        if (origLog.getLive() != null && userUpdateRequest.getLive() != null && !userUpdateRequest.getLive().equals(origLog.getLive())) {
            throw new BadRequestException("live cannot be changed");
        }
        if (origLog.getStartTime() != null && userUpdateRequest.getStartTime() != null && !userUpdateRequest.getStartTime().equals(origLog.getStartTime())) {
            throw new BadRequestException("startTime cannot be changed");
        }
        int rowsModified = this.logDAO.updateFields((Long)userUpdateRequest.getId(), userUpdateRequest.getStopTime(), userUpdateRequest.getComplete(), userUpdateRequest.getResultId(), userUpdateRequest.getTaskId());
        if (rowsModified != 1) {
            throw new NotFoundException("Failed to update log with id=" + userUpdateRequest.getId() + " (modified DB rows=" + rowsModified + ")");
        }
        return Response.ok((Object)this.getLog((Long)userUpdateRequest.getId(), request), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @POST
    @Path(value="{id}/content")
    @Consumes(value={"application/octet-stream"})
    @Timed
    public Response appendContent(@NotNull @PathParam(value="id") Long id, byte[] content, @Context HttpServletRequest httpServletRequest) throws SQLException {
        this.configuration.assureAccessAllowed(FedmonAccess.CREATE_TASK_AND_RESULT, httpServletRequest);
        Log.LogMediaType mediaType = Log.LogMediaType.byHttpMediaType((String)httpServletRequest.getContentType());
        if (mediaType == null) {
            LOG.error("appendStringContent call for UNSUPPORTED_MEDIA_TYPE: \"" + httpServletRequest.getContentType() + "\"");
            return Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build();
        }
        assert (mediaType.equals((Object)Log.LogMediaType.BINARY));
        ByteArrayInputStream appendedIS = new ByteArrayInputStream(content);
        int rowsChanged = this.logDAO.appendContent(id, appendedIS, Log.LogMediaType.BINARY.name());
        if (rowsChanged == 0) {
            LOG.error("Could not append binary content to log " + id);
            if (LOG.isDebugEnabled()) {
                Log log = this.logDAO.getById(id);
                if (log == null) {
                    LOG.debug("Log is null");
                } else {
                    LOG.debug("request.mediaType=" + Log.LogMediaType.BINARY.name() + " log.mediaType=" + log.getMediaType() + " log.complete=" + log.isComplete());
                }
            }
            throw new WebApplicationException("Could not append content to log " + id, Response.Status.BAD_REQUEST);
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="{id}/content")
    @Consumes(value={"*/*"})
    @Timed
    public Response appendStringContent(@NotNull @PathParam(value="id") Long id, String content, @Context HttpServletRequest httpServletRequest) throws SQLException {
        this.configuration.assureAccessAllowed(FedmonAccess.CREATE_TASK_AND_RESULT, httpServletRequest);
        Log.LogMediaType mediaType = Log.LogMediaType.byHttpMediaType((String)httpServletRequest.getContentType());
        if (mediaType == null) {
            LOG.error("appendStringContent call for UNSUPPORTED_MEDIA_TYPE: \"" + httpServletRequest.getContentType() + "\"");
            return Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build();
        }
        assert (!mediaType.equals((Object)Log.LogMediaType.BINARY));
        ByteArrayInputStream contentIS = new ByteArrayInputStream(content.getBytes(Charset.forName("UTF-8")));
        int rowsChanged = this.logDAO.appendContent(id, contentIS, mediaType.name());
        if (rowsChanged == 0) {
            LOG.error("Could not append String content to log " + id);
            if (LOG.isDebugEnabled()) {
                Log log = this.logDAO.getById(id);
                if (log == null) {
                    LOG.debug("Log is null");
                } else {
                    LOG.debug("request.mediaType=" + mediaType.name() + " log.mediaType=" + log.getMediaType() + " log.complete=" + log.isComplete());
                }
            }
            throw new WebApplicationException("Could not append content to log " + id, Response.Status.BAD_REQUEST);
        }
        return Response.noContent().build();
    }
}

