/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.OrganisationDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.OrganisationBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.SharedResourceCache;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import com.codahale.metrics.annotation.Timed;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/organisation")
@Produces(value={"application/json"})
public class OrganisationResource {
    private static final Logger LOG = LoggerFactory.getLogger(OrganisationResource.class);
    @Context
    UriInfo uriInfo;
    private final OrganisationDao organisationDAO;
    private final FedmonWebApiServiceConfiguration configuration;
    private final SharedResourceCache sharedResourceCache;

    public OrganisationResource(OrganisationDao organisationDAO, FedmonWebApiServiceConfiguration configuration, SharedResourceCache sharedResourceCache) {
        this.organisationDAO = organisationDAO;
        this.configuration = configuration;
        this.sharedResourceCache = sharedResourceCache;
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Organisation update(@NotNull @PathParam(value="id") String id, Organisation organisation, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (organisation.getId() == null || !((String)organisation.getId()).equals(id)) {
            throw new WebApplicationException("Id of provided organisation does not match path", Response.Status.BAD_REQUEST);
        }
        this.organisationDAO.update(organisation);
        this.sharedResourceCache.invalidateFull();
        OrganisationBuilder organisationBuilder = new OrganisationBuilder(organisation);
        this.configuration.getUriTool().setUriRecursive((JsonLdObjectBuilder)organisationBuilder);
        return organisationBuilder.create();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public Organisation create(Organisation organisation, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (organisation.getId() == null) {
            throw new WebApplicationException("Provided organisation must have an (new and non existing) ID", Response.Status.BAD_REQUEST);
        }
        if (organisation.getTestbeds() != null && !organisation.getTestbeds().isEmpty()) {
            throw new WebApplicationException("Provided organisation must not have testbeds", Response.Status.NOT_IMPLEMENTED);
        }
        this.organisationDAO.insert(organisation);
        this.sharedResourceCache.invalidateFull();
        OrganisationBuilder organisationBuilder = new OrganisationBuilder(organisation);
        organisationBuilder.setTestbeds(Collections.emptyList());
        this.configuration.getUriTool().setUriRecursive((JsonLdObjectBuilder)organisationBuilder);
        return organisationBuilder.create();
    }

    @GET
    @Timed
    public List<Organisation> getAll() {
        List<Organisation> resBase = this.organisationDAO.findAll();
        ArrayList<Organisation> res = new ArrayList<Organisation>(resBase.size());
        for (Organisation orig : resBase) {
            res.add(this.minimize(this.addUris(this.uriInfo, orig)));
        }
        return res;
    }

    @GET
    @Path(value="{id}")
    @Timed
    public Organisation get(@NotNull @PathParam(value="id") String id, @Context HttpServletRequest request) {
        Organisation res = this.organisationDAO.findById(id);
        LOG.debug("organisationDAO.findById(" + id + ") returned " + res);
        if (res == null) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        boolean showEmails = this.configuration.hasAnyAccess(request, new FedmonAccess[]{FedmonAccess.CREATE_TASK_AND_RESULT});
        if (!showEmails) {
            res = new OrganisationBuilder(res).setTechnicalContactEmails(null).create();
        }
        return this.minimize(this.addUris(this.uriInfo, res));
    }

    @DELETE
    @Path(value="{id}")
    @Timed
    public void delete(@NotNull @PathParam(value="id") Integer id, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        throw new WebApplicationException("not yet implemented", Response.Status.NOT_IMPLEMENTED);
    }

    public Organisation minimize(Organisation orig) {
        return OrganisationBuilder.minimize((JsonLdObjectsMetaData.Minimization)JsonLdObjectsMetaData.Minimization.FULL_WITH_MINIMAL_LINK_IDS, (Organisation)orig);
    }

    public Organisation addUris(UriInfo uriInfo, Organisation orig) {
        assert (uriInfo != null);
        assert (orig != null);
        assert (orig.getId() != null);
        return (Organisation)this.configuration.getUriTool().setUriRecursive((JsonLdObject)orig);
    }
}

