/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.resource;

import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonAccess;
import be.iminds.ilabt.jfed.fedmon.webapi.service.app.FedmonWebApiServiceConfiguration;
import be.iminds.ilabt.jfed.fedmon.webapi.service.dao.ResourceClassDao;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClassBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.resource.JFedExperimenterGuiConfigResource;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import com.codahale.metrics.annotation.Timed;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/resourceclass")
@Produces(value={"application/json"})
public class ResourceClassResource {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceClassResource.class);
    @Context
    UriInfo uriInfo;
    private final ResourceClassDao resourceClassDao;
    private final FedmonWebApiServiceConfiguration configuration;
    private final JFedExperimenterGuiConfigResource jFedExperimenterGuiConfigResource;

    public ResourceClassResource(ResourceClassDao resourceClassDao, FedmonWebApiServiceConfiguration configuration, JFedExperimenterGuiConfigResource jFedExperimenterGuiConfigResource) {
        this.resourceClassDao = resourceClassDao;
        this.configuration = configuration;
        this.jFedExperimenterGuiConfigResource = jFedExperimenterGuiConfigResource;
    }

    @GET
    @Timed
    public List<ResourceClass> all(@Context HttpServletRequest request) {
        List<ResourceClassBuilder> resBase = this.resourceClassDao.findAll();
        if (resBase == null) {
            return null;
        }
        ArrayList<ResourceClass> res = new ArrayList<ResourceClass>();
        for (ResourceClassBuilder rb : resBase) {
            rb = (ResourceClassBuilder)this.configuration.getUriTool().setUriRecursive((JsonLdObjectBuilder)rb, false);
            res.add(rb.create());
        }
        return res;
    }

    @GET
    @Path(value="{id}")
    @Timed
    public ResourceClass get(@NotNull @PathParam(value="id") String id) {
        ResourceClassBuilder resBuilder = this.resourceClassDao.findById(id);
        if (resBuilder == null) {
            throw new NotFoundException("There is no object with id=" + id);
        }
        resBuilder = (ResourceClassBuilder)this.configuration.getUriTool().setUriRecursive((JsonLdObjectBuilder)resBuilder, false);
        return resBuilder.create();
    }

    @POST
    @Timed
    public void insert(@NotNull ResourceClass resourceClass, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        this.resourceClassDao.insert(resourceClass);
        this.jFedExperimenterGuiConfigResource.invalidateCache();
    }

    @DELETE
    @Path(value="{id}")
    @Timed
    public void delete(@NotNull String id, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        this.resourceClassDao.delete(id);
        this.jFedExperimenterGuiConfigResource.invalidateCache();
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Timed
    public ResourceClass update(@NotNull @PathParam(value="id") String id, ResourceClass resourceClass, @Context HttpServletRequest request) {
        this.configuration.assureAccessAllowed(FedmonAccess.ADMIN, request);
        if (resourceClass.getId() == null || !((String)resourceClass.getId()).equals(id)) {
            throw new WebApplicationException("ID of provided ResourceClass differs with ID in request URL path", Response.Status.BAD_REQUEST);
        }
        this.resourceClassDao.update(resourceClass);
        this.jFedExperimenterGuiConfigResource.invalidateCache();
        return this.get(id);
    }
}

